/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.centralcobranca;

import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.ModeloEmail;
import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.mail.ExceptionEmail;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.boletotitulo.ServiceBoletoTituloImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.nfce.ServiceNFCeImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.ServiceNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.service.impl.titulo.ServiceTituloImpl;
import com.touchcomp.basementorservice.service.interfaces.ServicePessoa;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.ToolSendEmail;
import com.touchcomp.touchvomodel.vo.centralcobranca.DTOBoletoCentralCobranca;
import com.touchcomp.touchvomodel.vo.centralcobranca.DTOCentralCobraca;
import com.touchcomp.touchvomodel.vo.centralcobranca.DTOEnvioEmailBoleto;
import com.touchcomp.touchvomodel.vo.centralcobranca.DTOValoresCentralCobranca;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceCentralCobranca
extends ServiceGenericImpl {
    @Autowired
    ServiceBoletoTituloImpl serviceBoletoTituloImpl;
    @Autowired
    ServicePessoa servicePessoa;
    @Autowired
    ServiceTituloImpl serviceTituloImpl;
    @Autowired
    ServiceNotaFiscalPropriaImpl serviceNotaFiscalPropriaImpl;
    @Autowired
    ServiceNFCeImpl serviceNFCeImpl;

    public DTOCentralCobraca getBoletosEmAberto(String cnpj) throws ExceptionObjNotFound {
        DTOCentralCobraca dto = new DTOCentralCobraca();
        Pessoa p = this.servicePessoa.getByCPFCNPJ(cnpj);
        if (this.isNull(p).booleanValue()) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0047.058", new String[]{cnpj}));
        }
        ArrayList<DTOBoletoCentralCobranca> boletosDTO = new ArrayList<DTOBoletoCentralCobranca>();
        if (this.isNotNull(p).booleanValue() && this.isNotNull(p.getComplemento()).booleanValue()) {
            List<BoletoTitulo> boletos = this.serviceBoletoTituloImpl.getBoletosParaCentralCobranca(p.getComplemento().getCnpj());
            for (BoletoTitulo blt : boletos) {
                DTOBoletoCentralCobranca b = new DTOBoletoCentralCobranca();
                b.setIdBoleto(blt.getIdentificador());
                b.setDataEmissao(blt.getTitulo().getDataEmissao());
                b.setDataVencimento(blt.getDataVencimento());
                b.setParcela(blt.getTitulo().getNumParcTituloEstnota() + "/" + blt.getTitulo().getNumeroParcelas());
                b.setCodigoBarras(blt.getCodigoBarras());
                b.setValor(blt.getValorBoleto());
                b.setObservacaoTitulo(blt.getTitulo().getObservacao());
                b.setInscricaoEstadual(blt.getTitulo().getPessoa().getComplemento().getInscEst());
                this.setOrigemDocumentoTitulo(b, blt);
                this.setStatusVencido(b);
                boletosDTO.add(b);
            }
        }
        dto.setBoletos(boletosDTO);
        dto.setValores(this.getValoresAnalise(new Date(), p));
        return dto;
    }

    private void setOrigemDocumentoTitulo(DTOBoletoCentralCobranca dto, BoletoTitulo b) {
        if (b.getTitulo().getInfPagamentoPedido() != null) {
            dto.setOrigemDocumento("Pedido");
            dto.setNumeroDocumentoOrigem(b.getTitulo().getInfPagamentoPedido().getPedido().getCodigoPedido().toString());
        } else if (b.getTitulo().getInfPagamentoNfPropria() != null) {
            dto.setOrigemDocumento("NFe-P");
            dto.setNumeroDocumentoOrigem(b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString());
        } else if (b.getTitulo().getNotaContratoLocacao() != null) {
            dto.setOrigemDocumento("C. Loca\u00e7\u00e3o");
            dto.setNumeroDocumentoOrigem(b.getTitulo().getNotaContratoLocacao().getNumero().toString());
        } else if (b.getTitulo().getPedidoComercio() != null) {
            dto.setOrigemDocumento("P. Cormecio");
            dto.setNumeroDocumentoOrigem(b.getTitulo().getPedidoComercio().getIdentificador().toString());
        } else if (b.getTitulo().getRps() != null) {
            dto.setOrigemDocumento("RPs");
            dto.setNumeroDocumentoOrigem(b.getTitulo().getRps().getNumero().toString());
        } else if (b.getTitulo().getRenegociacaoTitulos() != null) {
            dto.setOrigemDocumento("Renegocia\u00e7\u00e3o");
            dto.setNumeroDocumentoOrigem(b.getTitulo().getRenegociacaoTitulos().getIdentificador().toString());
        } else if (!this.isNull(b.getTitulo().getNfcePagamento()).booleanValue()) {
            dto.setOrigemDocumento("NFCe");
            dto.setNumeroDocumentoOrigem(b.getTitulo().getNfcePagamento().getNfce().getNumero().toString());
        }
    }

    public DTOValoresCentralCobranca getValoresAnalise(Date periodo, String cnpj) {
        Pessoa p = this.servicePessoa.getByCPFCNPJ(cnpj);
        return this.getValoresAnalise(periodo, p);
    }

    private DTOValoresCentralCobranca getValoresAnalise(Date date, Pessoa p) {
        Date dataIncial = ToolDate.getDateFirstMonthDay((Date)date);
        Date dataFinal = ToolDate.getLastDateOnMonth((Date)date);
        DTOValoresCentralCobranca valores = new DTOValoresCentralCobranca();
        valores.setTotalCompras(this.serviceTituloImpl.findTotalCompraPorPeriodoAndPessoa(dataIncial, dataFinal, p.getComplemento().getCnpj()));
        valores.setTotalPago(this.serviceTituloImpl.findTotalPagoPorPeriodoAndPessoa(dataIncial, dataFinal, p.getComplemento().getCnpj()));
        valores.setTotalAVencer(this.serviceTituloImpl.findTotalAVencerPorPeriodoAndPessoa(dataIncial, dataFinal, p.getComplemento().getCnpj()));
        valores.setTotalVencido(this.serviceTituloImpl.findTotalVencidoPorPessoa(dataIncial, p.getComplemento().getCnpj()));
        NotaFiscalPropria n = this.serviceNotaFiscalPropriaImpl.getultimaNotaByPessoa(p.getComplemento().getCnpj());
        NFCe nfce = this.serviceNFCeImpl.getUltimaNotaByPessoa(p.getComplemento().getCnpj());
        Date dataNfce = n != null ? n.getDataEmissaoNota() : new Date(0L);
        Date dataNfe = nfce != null ? nfce.getDataPrevSaida() : new Date(0L);
        int mes = ToolDate.getMonthFromDate((Date)date) + 1;
        String mesStr = mes < 10 ? "0" + mes : "" + mes;
        valores.setPeriodo(mesStr + ToolDate.getYearFromDate((Date)date));
        if (dataNfce.after(dataNfe) && nfce != null) {
            valores.setValorUltimaCompra(nfce.getTotalizadores().getValorTotalII());
            valores.setDataUltimaCompra(nfce.getDataPrevSaida());
        } else if (n != null) {
            valores.setValorUltimaCompra(n.getValoresNfPropria().getValorTotal());
            valores.setDataUltimaCompra(n.getDataEntradaSaida());
        }
        return valores;
    }

    public File getBoletoPDF(Long idBoleto, Long idUsuario, Empresa emp, Usuario user, Grupo grupoUsuario) throws ExceptionIO, ExceptionBuildBI, MalformedURLException, ExceptionGeracaoTitulos {
        BoletoTitulo boleto = (BoletoTitulo)this.serviceBoletoTituloImpl.get(idBoleto);
        ArrayList<BoletoTitulo> aux = new ArrayList<BoletoTitulo>();
        aux.add(boleto);
        List<DataOutputBI> arqBoletos = this.serviceBoletoTituloImpl.gerarBoletoTitulo(aux, user, grupoUsuario, emp, (short)1);
        return arqBoletos.get(0).getFile();
    }

    public void enviarEmail(DTOEnvioEmailBoleto input, Long idUsuario, Empresa emp, Usuario user, Grupo grupoUsuario, OpcoesRelacionamento opRelacionamento) throws ExceptionIO, ExceptionBuildBI, MalformedURLException, ExceptionGeracaoTitulos, ExceptionEmail {
        File f = this.getBoletoPDF(input.getIdBoleto(), idUsuario, emp, user, grupoUsuario);
        ArrayList<String> listDestinatario = new ArrayList<String>();
        listDestinatario.add(input.getEmail1());
        if (!this.isNull(input.getEmail2()).booleanValue() && !input.getEmail2().isEmpty()) {
            listDestinatario.add(input.getEmail2());
        }
        if (!this.isNull(input.getEmail3()).booleanValue() && !input.getEmail3().isEmpty()) {
            listDestinatario.add(input.getEmail3());
        }
        ArrayList<File> listAnexo = new ArrayList<File>();
        listAnexo.add(f);
        Email e = new Email();
        ModeloEmail me = opRelacionamento.getModeloEnvioBoleto();
        e.addAnexos(listAnexo);
        e.setAssunto(me.getTituloEmail());
        e.setCorpoMensagem(me.getDescricao());
        e.setDescricao(me.getDescricao());
        e.setRemetente(emp.getPessoa().getNome());
        e.setDestinatarios(new HashSet(listDestinatario));
        ServidorEmail s = opRelacionamento.getServidorEnvioBoleto();
        Email.ServidorEmail ser = new Email.ServidorEmail();
        ser.setEmail(s.getEmail());
        ser.setLogin(s.getLogin());
        ser.setPortaEmail(s.getPortaEmail());
        ser.setNaoAutenticarEmail(s.getNaoAutenticarEmail());
        ser.setSenha(s.getSenha());
        ser.setServidor(s.getServidor());
        ser.setServidorImap(s.getServidorImap());
        ser.setServidorPop(s.getServidorPop());
        e.setServidor(ser);
        ToolSendEmail.sendEmailWithException((Email)e);
    }

    void setStatusVencido(DTOBoletoCentralCobranca b) {
        Date dataTit;
        Date hoje = TDate.dataSemHora((Date)new Date());
        if (TDate.difBetweenDatesInDays((Date)hoje, (Date)(dataTit = b.getDataVencimento())) < 0L) {
            b.setSituacao("VENCIDO");
        } else {
            b.setSituacao("NORMAL");
        }
    }
}

