/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.centralreinf;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.capsules.impl.CapsUsuario;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.constants.enums.centralreinf.EnumConstTipoEmpreitada;
import com.touchcomp.basementor.constants.enums.reinf.EnumConstAmbienteReinf;
import com.touchcomp.basementor.constants.enums.reinf.EnumConstStatusEnvio;
import com.touchcomp.basementor.constants.enums.reinf.EnumConstStatusEventoReinf;
import com.touchcomp.basementor.constants.enums.reinf.EnumConstTipoEventoReinf;
import com.touchcomp.basementor.constants.enums.reinf.EnumReinfIndicativoAutoriaProcesso;
import com.touchcomp.basementor.constants.enums.reinf.EnumReinfTipoProcesso;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemReinf2010;
import com.touchcomp.basementor.model.vo.ItemReinf2020;
import com.touchcomp.basementor.model.vo.ItemReinf4010;
import com.touchcomp.basementor.model.vo.ItemReinf4020;
import com.touchcomp.basementor.model.vo.ItemReinf4020NaoIdentificado;
import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfIdentificacaoAmbiente;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementor.model.vo.ReinfR2060;
import com.touchcomp.basementor.model.vo.ReinfR2099;
import com.touchcomp.basementor.model.vo.TipoEventoReinf;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.itemreinf2010.ServiceItemReinf2010Impl;
import com.touchcomp.basementorservice.service.impl.itemreinf2020.ServiceItemReinf2020Impl;
import com.touchcomp.basementorservice.service.impl.itemreinf4010.ServiceItemReinf4010Impl;
import com.touchcomp.basementorservice.service.impl.itemreinf4020.ServiceItemReinf4020Impl;
import com.touchcomp.basementorservice.service.impl.itemreinf4020naoidentificado.ServiceItemReinf4020NaoIdentificadoImpl;
import com.touchcomp.basementorservice.service.impl.r1000.ServiceR1000Impl;
import com.touchcomp.basementorservice.service.impl.reinfevento.ServiceReinfEventoImpl;
import com.touchcomp.basementorservice.service.impl.reinfidentificacaoambiente.ServiceReinfIdentificacaoAmbienteImpl;
import com.touchcomp.basementorservice.service.impl.reinfpreevento.ServiceReinfPreEventoImpl;
import com.touchcomp.basementorservice.service.impl.reinfr2060.ServiceReinfR2060Impl;
import com.touchcomp.basementorservice.service.impl.reinfr2099.ServiceReinfR2099Impl;
import com.touchcomp.basementorservice.service.impl.tipoeventoreinf.ServiceTipoEventoReinfImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchvomodel.vo.centralreinf.DTOCentralReinf;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ServiceCentralReinfImpl
extends ServiceGenericImpl {
    @Autowired
    ServiceEmpresaImpl serviceEmpresaImpl;
    @Autowired
    ServiceTipoEventoReinfImpl serviceTipoEventoReinfImpl;
    @Autowired
    ServiceReinfPreEventoImpl serviceReinfPreEventoImpl;
    @Autowired
    ServiceReinfEventoImpl serviceReinfEventoImpl;
    @Autowired
    ServiceReinfIdentificacaoAmbienteImpl serviceReinfIdentificacaoAmbienteImpl;
    @Autowired
    ServiceUsuarioImpl serviceUsuarioImpl;
    @Autowired
    ServiceItemReinf2010Impl serviceItemReinf2010Impl;
    @Autowired
    ServiceItemReinf2020Impl serviceItemReinf2020Impl;
    @Autowired
    ServiceItemReinf4010Impl serviceItemReinf4010Impl;
    @Autowired
    ServiceItemReinf4020Impl serviceItemReinf4020Impl;
    @Autowired
    ServiceItemReinf4020NaoIdentificadoImpl serviceItemReinf4020NaoIdentificadoImpl;
    @Autowired
    ServiceR1000Impl serviceR1000Impl;
    @Autowired
    ServiceReinfR2060Impl serviceReinfR2060Impl;
    @Autowired
    ServiceReinfR2099Impl serviceReinfR2099Impl;

    public DTOCentralReinf carregarDadosReinf(CapsEmpresa capsEmpresa, Long dataPeriodo, Long tipoEvento, EnumConstAmbienteReinf status, Pageable page) throws ExceptionObjNotFound {
        Empresa empresa = (Empresa)this.serviceEmpresaImpl.getOrThrow(capsEmpresa.get());
        TipoEventoReinf tipoEventoReinf = (TipoEventoReinf)this.serviceTipoEventoReinfImpl.getOrThrow(tipoEvento);
        ReinfIdentificacaoAmbiente reinfIdentificacaoAmbiente = this.serviceReinfIdentificacaoAmbienteImpl.findByCodigo(status.getEnumId());
        Date periodo = ToolDate.getDateFirstMonthDay((Date)new Date(dataPeriodo));
        List<Object> listReinfPreEvento = this.isEquals(status.getEnumId(), EnumConstStatusEventoReinf.NAO_ENVIADO.getEnumId()) ? this.serviceReinfPreEventoImpl.getPreEventosNaoEnviados(empresa, reinfIdentificacaoAmbiente, tipoEventoReinf, periodo, page) : this.serviceReinfPreEventoImpl.findEventosGeradosEnviados(empresa, reinfIdentificacaoAmbiente, tipoEventoReinf, periodo, page).stream().map(i -> i.getPreEvento()).collect(Collectors.toList());
        if (!ServiceCentralReinfImpl.isWithData(listReinfPreEvento)) {
            return null;
        }
        DTOCentralReinf dto = new DTOCentralReinf();
        EnumConstTipoEventoReinf enumTipo = EnumConstTipoEventoReinf.get((Object)tipoEventoReinf.getCodigo());
        switch (enumTipo) {
            case R2010: {
                List r2010 = listReinfPreEvento.stream().map(i -> {
                    ItemReinf2010 itemReinf = i.getItemReinf2010();
                    return this.buildDTOR20Res((ReinfPreEvento)i, itemReinf.getIdentificador(), itemReinf.getPessoa().getIdentificador(), itemReinf.getPessoa().getNome(), itemReinf.getPessoa().getComplemento().getCnpj(), EnumConstantsMentorSimNao.get((Object)itemReinf.getIndicadorObra()).getEnumDesc(), this.isNotNull(itemReinf.getCno()) != false ? itemReinf.getCno().toString() : "", this.isEquals(itemReinf.getIndicadorObra(), EnumConstantsMentorSimNao.SIM.getEnumId()) ? EnumConstTipoEmpreitada.get((Object)itemReinf.getIndicadorEmpreitada()).getEnumDesc() : "", empresa.toString());
                }).collect(Collectors.toList());
                dto.setR2010(r2010);
                break;
            }
            case R2020: {
                List r2020 = listReinfPreEvento.stream().map(i -> {
                    ItemReinf2020 itemReinf = i.getItemReinf2020();
                    return this.buildDTOR20Res((ReinfPreEvento)i, itemReinf.getIdentificador(), itemReinf.getPessoa().getIdentificador(), itemReinf.getPessoa().getNome(), itemReinf.getPessoa().getComplemento().getCnpj(), EnumConstantsMentorSimNao.get((Object)itemReinf.getIndicadorObra()).getEnumDesc(), this.isNotNull(itemReinf.getCno()) != false ? itemReinf.getCno().toString() : "", this.isEquals(itemReinf.getIndicadorObra(), EnumConstantsMentorSimNao.SIM.getEnumId()) ? EnumConstTipoEmpreitada.get((Object)itemReinf.getIndicadorEmpreitada()).getEnumDesc() : "", empresa.toString());
                }).collect(Collectors.toList());
                dto.setR2020(r2020);
                break;
            }
            case R4010: {
                List r4010 = listReinfPreEvento.stream().map(i -> {
                    ItemReinf4010 itemReinf = i.getItemReinf4010();
                    return this.buildDTOR40Res((ReinfPreEvento)i, itemReinf.getIdentificador(), itemReinf.getPessoa().getIdentificador(), itemReinf.getPessoa().getNome(), itemReinf.getPessoa().getComplemento().getCnpj(), empresa.toString());
                }).collect(Collectors.toList());
                dto.setR4010(r4010);
                break;
            }
            case R4020: {
                List r4020 = listReinfPreEvento.stream().filter(i -> this.isNull(i.getItemReinfNaoId())).map(i -> {
                    ItemReinf4020 itemReinf = i.getItemReinf4020();
                    return this.buildDTOR40Res((ReinfPreEvento)i, itemReinf.getIdentificador(), itemReinf.getPessoa().getIdentificador(), itemReinf.getPessoa().getNome(), itemReinf.getPessoa().getComplemento().getCnpj(), empresa.toString());
                }).collect(Collectors.toList());
                dto.setR4020(r4020);
                List r4020Ni = listReinfPreEvento.stream().filter(i -> this.isNull(i.getItemReinf4020())).map(i -> {
                    DTOCentralReinf.DTOR4020NaoIdentificado dtoR4020Ni = new DTOCentralReinf.DTOR4020NaoIdentificado();
                    dtoR4020Ni.setIdentificador(i.getItemReinfNaoId().getIdentificador());
                    dtoR4020Ni.setEmpresa(i.getItemReinfNaoId().getEmpresa().toString());
                    dtoR4020Ni.setCnpj(i.getItemReinfNaoId().getCpf());
                    dtoR4020Ni.setValorBruto(i.getItemReinfNaoId().getValorBruto());
                    dtoR4020Ni.setBaseIrrf(i.getItemReinfNaoId().getBaseIrrf());
                    dtoR4020Ni.setValorIrrf(i.getItemReinfNaoId().getValorIrrf());
                    dtoR4020Ni.setBaseAgreg(i.getItemReinfNaoId().getBaseAgregado());
                    dtoR4020Ni.setValorAgreg(i.getItemReinfNaoId().getValorAgregado());
                    dtoR4020Ni.setBasePis(i.getItemReinfNaoId().getBasePis());
                    dtoR4020Ni.setValorPis(i.getItemReinfNaoId().getValorPis());
                    dtoR4020Ni.setBaseCofins(i.getItemReinfNaoId().getBaseCofins());
                    dtoR4020Ni.setDataPag(i.getItemReinfNaoId().getDataPagamento());
                    if (this.isNotNull(i.getItemReinfNaoId()).booleanValue() && this.isNotNull(i.getItemReinfNaoId().getNaturezaRendimento()).booleanValue() && this.isStrWithData(i.getItemReinfNaoId().getNaturezaRendimento().getDescricao())) {
                        dtoR4020Ni.setNatRend(i.getItemReinfNaoId().getNaturezaRendimento().getDescricao());
                    } else {
                        dtoR4020Ni.setNatRend("");
                    }
                    dtoR4020Ni.setEventosReinf(this.getReinfPreEvento((ReinfPreEvento)i));
                    return dtoR4020Ni;
                }).collect(Collectors.toList());
                dto.setR4020NaoIdentificado(r4020Ni);
                break;
            }
            case R4040: {
                List r4040 = listReinfPreEvento.stream().map(i -> {
                    DTOCentralReinf.DTOR4040 dtoR4040 = new DTOCentralReinf.DTOR4040();
                    dtoR4040.setIdentificador(i.getItemReinf4040().getIdentificador());
                    dtoR4040.setEmpresa(i.getItemReinf4040().getEmpresa().toString());
                    dtoR4040.setDataPag(i.getItemReinf4040().getDataPagamento());
                    dtoR4040.setBaseIrrf(i.getItemReinf4040().getBaseIrrf());
                    dtoR4040.setValorIrff(i.getItemReinf4040().getVlrIrrf());
                    dtoR4040.setValorBruto(i.getItemReinf4040().getLiquido());
                    if (this.isNotNull(i.getItemReinfNaoId()).booleanValue() && this.isNotNull(i.getItemReinfNaoId().getNaturezaRendimento()).booleanValue() && this.isStrWithData(i.getItemReinfNaoId().getNaturezaRendimento().getDescricao())) {
                        dtoR4040.setNatRendimento(i.getItemReinfNaoId().getNaturezaRendimento().getDescricao());
                    } else {
                        dtoR4040.setNatRendimento("");
                    }
                    dtoR4040.setCpf(i.getItemReinf4040().getCpf());
                    dtoR4040.setEventosReinf(this.getReinfPreEvento((ReinfPreEvento)i));
                    return dtoR4040;
                }).collect(Collectors.toList());
                dto.setR4040(r4040);
                break;
            }
            case R1000: {
                List r1000 = listReinfPreEvento.stream().map(i -> {
                    DTOCentralReinf.DTOR1000 dtoR1000 = new DTOCentralReinf.DTOR1000();
                    dtoR1000.setIdentificador(i.getR1000().getIdentificador());
                    dtoR1000.setEmpresa(i.getR1000().getEmpresa().toString());
                    dtoR1000.setClassTrib(i.getR1000().getClassificacaoTributaria().getDescricao());
                    dtoR1000.setSitPess(i.getR1000().getSituacaoPessoaJuridica().getDescricao());
                    dtoR1000.setConfigCert(i.getR1000().getConfiguracaoCertificado().getDescricao());
                    dtoR1000.setDesenvSof(i.getR1000().getPessoaSoftwareHouse().getNome());
                    dtoR1000.setContatoEmp(i.getR1000().getPessoaContato().getNome());
                    dtoR1000.setEventosReinf(this.getReinfPreEvento((ReinfPreEvento)i));
                    return dtoR1000;
                }).collect(Collectors.toList());
                dto.setR1000(r1000);
                break;
            }
            case R1070: {
                List r1070 = listReinfPreEvento.stream().map(i -> {
                    DTOCentralReinf.DTOR1070 dtoR1070 = new DTOCentralReinf.DTOR1070();
                    dtoR1070.setIdentificador(i.getR1070().getIdentificador());
                    dtoR1070.setInVal(i.getR1070().getInicioValidade());
                    dtoR1070.setFimVal(i.getR1070().getFimValidade());
                    dtoR1070.setNumeroProcessoJudicial(i.getR1070().getNumeroProcessoJudicial());
                    dtoR1070.setTipoProc(EnumReinfTipoProcesso.get((Object)i.getR1070().getTipoProcesso()).getEnumDesc());
                    dtoR1070.setIndAutProc(EnumReinfIndicativoAutoriaProcesso.get((Object)i.getR1070().getAutoriaProcesso()).getEnumDesc());
                    dtoR1070.setDataDecisao(i.getR1070().getDataDecisao());
                    dtoR1070.setCodSusp(i.getR1070().getCodigoSuspensaoProcesso());
                    dtoR1070.setIndSusp(i.getR1070().getIndSuspensaoProcesso().toString());
                    dtoR1070.setEventosReinf(this.getReinfPreEvento((ReinfPreEvento)i));
                    return dtoR1070;
                }).collect(Collectors.toList());
                dto.setR1070(r1070);
                break;
            }
            case R2060: {
                List r2060 = listReinfPreEvento.stream().map(i -> {
                    DTOCentralReinf.DTOR2060 dtoR2060 = new DTOCentralReinf.DTOR2060();
                    dtoR2060.setIdentificador(i.getR2060().getIdentificador());
                    dtoR2060.setPeriodo(i.getR2060().getPeriodo());
                    dtoR2060.setRecBruta(i.getR2060().getValorReceitaBrutaTotal());
                    dtoR2060.setVlrContPrev(i.getR2060().getValorContribPrevTotal());
                    dtoR2060.setEventosReinf(this.getReinfPreEvento((ReinfPreEvento)i));
                    return dtoR2060;
                }).collect(Collectors.toList());
                dto.setR2060(r2060);
                break;
            }
            case R2099: {
                List r2099 = listReinfPreEvento.stream().map(i -> {
                    DTOCentralReinf.DTOR2099 dtoR2099 = new DTOCentralReinf.DTOR2099();
                    dtoR2099.setIdentificador(i.getR2099().getIdentificador());
                    dtoR2099.setPeriodo(i.getR2099().getPeriodo());
                    dtoR2099.setEmpresa(i.getR2099().getEmpresa().toString());
                    dtoR2099.setPessoa(i.getR2099().getPessoaRespInf().getNome());
                    dtoR2099.setEventosReinf(this.getReinfPreEvento((ReinfPreEvento)i));
                    return dtoR2099;
                }).collect(Collectors.toList());
                dto.setR2099(r2099);
                break;
            }
            case R9000: {
                List r9000 = listReinfPreEvento.stream().map(i -> this.buildDTOReinfRes(i.getReinfEvento())).collect(Collectors.toList());
                dto.setR9000(r9000);
                break;
            }
            case R2098: {
                List r2098 = listReinfPreEvento.stream().map(i -> this.buildDTOReinfRes(i.getReinfEvento())).collect(Collectors.toList());
                dto.setR2098(r2098);
                break;
            }
            case R4099: {
                List r4099 = listReinfPreEvento.stream().map(i -> this.buildDTOReinfRes(i.getReinfEvento())).collect(Collectors.toList());
                dto.setR4099(r4099);
                break;
            }
            default: {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.2007.001"));
            }
        }
        return dto;
    }

    private DTOCentralReinf.DTOEventosReinf getReinfPreEvento(ReinfPreEvento reinfPreEvento) {
        DTOCentralReinf.DTOEventosReinf dto = new DTOCentralReinf.DTOEventosReinf();
        dto.setIdentificador(reinfPreEvento.getIdentificador());
        dto.setUsuario(reinfPreEvento.getUsuario().getUsuarioBasico().getPessoa().getNome());
        dto.setRegistro(reinfPreEvento.getTipoEventoReinf().getCodigo());
        dto.setTipo(this.isNotNull(reinfPreEvento.getTipoEvento()) != false ? EnumEsocialTipoEvento.get((Object)reinfPreEvento.getTipoEvento()).getEnumDesc() : "INDEFINIDO");
        dto.setIdLote(this.isNotNull(reinfPreEvento.getReinfEvento()) != false && this.isNotNull(reinfPreEvento.getReinfEvento().getReinfLoteEventos()) != false ? reinfPreEvento.getReinfEvento().getReinfLoteEventos().getIdentificador() : null);
        dto.setInVal(reinfPreEvento.getDataInicioValidade());
        dto.setStatus(this.isNotNull(reinfPreEvento.getReinfEvento()) != false && this.isNotNull(reinfPreEvento.getReinfEvento().getStatus()) != false ? EnumConstStatusEnvio.get((Object)reinfPreEvento.getReinfEvento().getStatus()).getEnumDesc() : EnumConstStatusEnvio.NAO_ENVIADO.getEnumDesc());
        dto.setRecibo(this.isNotNull(reinfPreEvento.getReinfEvento()) != false && this.isNotNull(reinfPreEvento.getReinfEvento().getNrRecibo()) != false ? reinfPreEvento.getReinfEvento().getNrRecibo() : "");
        return dto;
    }

    private DTOCentralReinf.DTOR20Res buildDTOR20Res(ReinfPreEvento pre, Long r20ResIdentificador, Long idPessoa, String nomePessoa, String cnpj, String indicadorObra, String cno, String tipoEmpreitada, String empresa) {
        DTOCentralReinf.DTOR20Res dto = new DTOCentralReinf.DTOR20Res();
        dto.setIdentificador(r20ResIdentificador);
        dto.setIdPessoa(idPessoa);
        dto.setNomePessoa(nomePessoa);
        dto.setCnpj(cnpj);
        dto.setIndicadorObra(indicadorObra);
        dto.setCno(cno);
        dto.setTipoEmpreitada(tipoEmpreitada);
        dto.setEmpresa(empresa);
        dto.setEventosReinf(this.getReinfPreEvento(pre));
        return dto;
    }

    private DTOCentralReinf.DTOR40Res buildDTOR40Res(ReinfPreEvento pre, Long r40ResIdentificador, Long idPessoa, String nomePessoa, String cnpj, String empresa) {
        DTOCentralReinf.DTOR40Res dto = new DTOCentralReinf.DTOR40Res();
        dto.setR40ResIdentificador(r40ResIdentificador);
        dto.setIdPessoa(idPessoa);
        dto.setNomePessoa(nomePessoa);
        dto.setCnpj(cnpj);
        dto.setEmpresa(empresa);
        dto.setEventosReinf(this.getReinfPreEvento(pre));
        return dto;
    }

    private DTOCentralReinf.DTOReinfRes buildDTOReinfRes(ReinfEvento reinfEvento) {
        DTOCentralReinf.DTOReinfRes dto = new DTOCentralReinf.DTOReinfRes();
        dto.setIdEvento(reinfEvento.getIdentificador());
        dto.setIdPreEvento(reinfEvento.getPreEvento().getIdentificador());
        if (this.isNull(reinfEvento.getPreEvento().getAquisicaoCliente()).booleanValue() && this.isNull(reinfEvento.getPreEvento().getAquisicaoFornecedor()).booleanValue()) {
            dto.setUsuario("");
        } else if (this.isNotNull(reinfEvento.getPreEvento().getAquisicaoCliente()).booleanValue()) {
            dto.setUsuario(reinfEvento.getPreEvento().getAquisicaoCliente().getCliente().getPessoa().getNome());
        } else {
            dto.setUsuario(reinfEvento.getPreEvento().getAquisicaoFornecedor().getFornecedor().getPessoa().getNome());
        }
        dto.setRegistro(reinfEvento.getPreEvento().getTipoEventoReinf().getCodigo());
        dto.setTipo(this.isNotNull(reinfEvento.getPreEvento().getTipoEvento()) != false ? EnumEsocialTipoEvento.get((Object)reinfEvento.getPreEvento().getTipoEvento()).getEnumDesc() : "INDEFINIDO");
        dto.setInVal(reinfEvento.getPreEvento().getDataInicioValidade());
        dto.setTermVal(reinfEvento.getPreEvento().getDataFimVal());
        dto.setStatus(this.isNotNull(reinfEvento.getStatus()) != false ? EnumConstStatusEnvio.get((Object)reinfEvento.getStatus()).getEnumDesc() : EnumConstStatusEnvio.NAO_ENVIADO.getEnumDesc());
        dto.setRecibo(this.isNotNull(reinfEvento.getNrRecibo()) != false ? reinfEvento.getNrRecibo() : "");
        dto.setEventosReinf(this.getReinfPreEvento(reinfEvento.getPreEvento()));
        return dto;
    }

    public void getCriarEventoExclusao(Long idEvento, Long tipoEvento, CapsUsuario capsUsuario) throws ExceptionObjNotFound {
        TipoEventoReinf tipoEventoReinf = (TipoEventoReinf)this.serviceTipoEventoReinfImpl.getOrThrow(tipoEvento);
        Usuario usuario = (Usuario)this.serviceUsuarioImpl.getOrThrow(capsUsuario.get());
        EnumConstTipoEventoReinf enumTipo = EnumConstTipoEventoReinf.get((Object)tipoEventoReinf.getCodigo());
        String ambiente = "1";
        Date dataInicialFinal = new Date();
        switch (enumTipo) {
            case R2010: {
                ItemReinf2010 itemReinf2010 = (ItemReinf2010)this.serviceItemReinf2010Impl.getOrThrow(idEvento);
                this.serviceReinfPreEventoImpl.criarPreEventosExclusao(itemReinf2010, usuario, ambiente, dataInicialFinal, dataInicialFinal);
                break;
            }
            case R2020: {
                ItemReinf2020 itemReinf2020 = (ItemReinf2020)this.serviceItemReinf2020Impl.getOrThrow(idEvento);
                this.serviceReinfPreEventoImpl.criarPreEventosExclusao(itemReinf2020, usuario, ambiente, dataInicialFinal, dataInicialFinal);
                break;
            }
            case R4010: {
                ItemReinf4010 itemReinf4010 = (ItemReinf4010)this.serviceItemReinf4010Impl.getOrThrow(idEvento);
                this.serviceReinfPreEventoImpl.criarPreEventosExclusao(itemReinf4010, usuario, ambiente, dataInicialFinal, dataInicialFinal);
                break;
            }
            case R4020: {
                ItemReinf4020 itemReinf4020 = (ItemReinf4020)this.serviceItemReinf4020Impl.getOrThrow(idEvento);
                this.serviceReinfPreEventoImpl.criarPreEventosExclusao(itemReinf4020, usuario, ambiente, dataInicialFinal, dataInicialFinal);
                break;
            }
            case R1000: {
                R1000 r1000 = (R1000)this.serviceR1000Impl.getOrThrow(idEvento);
                this.serviceReinfPreEventoImpl.criarPreEventosExclusao(r1000, usuario, ambiente, dataInicialFinal, dataInicialFinal);
                break;
            }
            case R2060: {
                ReinfR2060 r2060 = (ReinfR2060)this.serviceReinfR2060Impl.getOrThrow(idEvento);
                this.serviceReinfPreEventoImpl.criarPreEventosExclusao(r2060, usuario, ambiente, dataInicialFinal, dataInicialFinal);
                break;
            }
            case R2099: {
                ReinfR2099 r2099 = (ReinfR2099)this.serviceReinfR2099Impl.getOrThrow(idEvento);
                this.serviceReinfPreEventoImpl.criarPreEventosExclusao(r2099, usuario, ambiente, dataInicialFinal, dataInicialFinal);
                break;
            }
            default: {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.2007.001"));
            }
        }
    }

    public void getCriarEventoExclusao4020naoIdentificado(Long idEvento, CapsUsuario capsUsuario) throws ExceptionObjNotFound {
        Usuario usuario = (Usuario)this.serviceUsuarioImpl.getOrThrow(capsUsuario.get());
        String ambiente = "1";
        Date dataInicialFinal = new Date();
        ItemReinf4020NaoIdentificado itemReinf4020NI = (ItemReinf4020NaoIdentificado)this.serviceItemReinf4020NaoIdentificadoImpl.getOrThrow(idEvento);
        this.serviceReinfPreEventoImpl.criarPreEventosExclusao(itemReinf4020NI, usuario, ambiente, dataInicialFinal, dataInicialFinal);
    }

    public void getRetificarEvento(Long idEvento, Long tipoEvento, CapsUsuario capsUsuario) throws ExceptionObjNotFound {
        TipoEventoReinf tipoEventoReinf = (TipoEventoReinf)this.serviceTipoEventoReinfImpl.getOrThrow(tipoEvento);
        Usuario usuario = (Usuario)this.serviceUsuarioImpl.getOrThrow(capsUsuario.get());
        EnumConstTipoEventoReinf enumTipo = EnumConstTipoEventoReinf.get((Object)tipoEventoReinf.getCodigo());
        String ambiente = "1";
        Date dataInicialFinal = new Date();
        switch (enumTipo) {
            case R2010: {
                ItemReinf2010 itemReinf2010 = (ItemReinf2010)this.serviceItemReinf2010Impl.getOrThrow(idEvento);
                this.serviceReinfPreEventoImpl.criarPreEventosAlteracaoRetificacao(itemReinf2010, usuario, ambiente, dataInicialFinal, dataInicialFinal);
                break;
            }
            case R2020: {
                ItemReinf2020 itemReinf2020 = (ItemReinf2020)this.serviceItemReinf2020Impl.getOrThrow(idEvento);
                this.serviceReinfPreEventoImpl.criarPreEventosAlteracaoRetificacao(itemReinf2020, usuario, ambiente, dataInicialFinal, dataInicialFinal);
                break;
            }
            case R4010: {
                ItemReinf4010 itemReinf4010 = (ItemReinf4010)this.serviceItemReinf4010Impl.getOrThrow(idEvento);
                this.serviceReinfPreEventoImpl.criarPreEventosAlteracaoRetificacao(itemReinf4010, usuario, ambiente, dataInicialFinal, dataInicialFinal);
                break;
            }
            case R4020: {
                ItemReinf4020 itemReinf4020 = (ItemReinf4020)this.serviceItemReinf4020Impl.getOrThrow(idEvento);
                this.serviceReinfPreEventoImpl.criarPreEventosAlteracaoRetificacao(itemReinf4020, usuario, ambiente, dataInicialFinal, dataInicialFinal);
                break;
            }
            case R1000: {
                R1000 r1000 = (R1000)this.serviceR1000Impl.getOrThrow(idEvento);
                this.serviceReinfPreEventoImpl.criarPreEventosAlteracaoRetificacao(r1000, usuario, ambiente, dataInicialFinal, dataInicialFinal);
                break;
            }
            case R2060: {
                ReinfR2060 r2060 = (ReinfR2060)this.serviceReinfR2060Impl.getOrThrow(idEvento);
                this.serviceReinfPreEventoImpl.criarPreEventosAlteracaoRetificacao(r2060, usuario, ambiente, dataInicialFinal, dataInicialFinal);
                break;
            }
            case R2099: {
                ReinfR2099 r2099 = (ReinfR2099)this.serviceReinfR2099Impl.getOrThrow(idEvento);
                this.serviceReinfPreEventoImpl.criarPreEventosAlteracaoRetificacao(r2099, usuario, ambiente, dataInicialFinal, dataInicialFinal);
                break;
            }
            default: {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.2007.001"));
            }
        }
    }

    public void getRetificarEvento4020naoIdentificado(Long idEvento, CapsUsuario capsUsuario) throws ExceptionObjNotFound {
        Usuario usuario = (Usuario)this.serviceUsuarioImpl.getOrThrow(capsUsuario.get());
        String ambiente = "1";
        Date dataInicialFinal = new Date();
        ItemReinf4020NaoIdentificado itemReinf4020NI = (ItemReinf4020NaoIdentificado)this.serviceItemReinf4020NaoIdentificadoImpl.getOrThrow(idEvento);
        this.serviceReinfPreEventoImpl.criarPreEventosAlteracaoRetificacao(itemReinf4020NI, usuario, ambiente, dataInicialFinal, dataInicialFinal);
    }
}

