/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.centrocusto;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroCustoEmpresa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorclientwebservices.ponto.model.departamento.DTOPontoDepartamento;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoCentroCustoImpl;
import com.touchcomp.basementorservice.helpers.impl.centrocusto.HelperCentroCusto;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementortools.tools.cleardata.ToolClearData;
import com.touchcomp.touchvomodel.vo.centrocusto.DTOCentroCustoRes;
import com.touchcomp.touchvomodel.vo.centrocusto.web.DTOCentroCusto;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceCentroCustoImpl
extends ServiceGenericEntityImpl<CentroCusto, Long, DaoCentroCustoImpl> {
    ServiceEmpresaImpl serviceEmpresaImpl;
    HelperCentroCusto helperCentroCusto;

    @Autowired
    public ServiceCentroCustoImpl(DaoCentroCustoImpl genericDao, ServiceEmpresaImpl serviceEmpresaImp, HelperCentroCusto helperCentroCusto) {
        super(genericDao);
        this.serviceEmpresaImpl = serviceEmpresaImp;
        this.helperCentroCusto = helperCentroCusto;
    }

    public CentroCusto findByCodigo(String codigo) {
        return ((DaoCentroCustoImpl)this.getGenericDao()).findByCodigo(codigo);
    }

    public List<CentroCusto> findCentroCustoColaborador() {
        return ((DaoCentroCustoImpl)this.getDao()).findCentroCustoColaborador();
    }

    public List<DTOCentroCustoRes> findDTOCentroCustoColaborador() {
        return this.buildToDTO(this.findCentroCustoColaborador(), DTOCentroCustoRes.class);
    }

    public DTOCentroCusto.DTOCentroCustoEmpresa getCentroCustoEmpresa(Long idEmpresa) {
        Empresa empresa = (Empresa)this.serviceEmpresaImpl.get(idEmpresa);
        if (this.isNull(empresa).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0049.001", new Object[]{idEmpresa}));
        }
        CentroCustoEmpresa centroCustoEmpresa = new CentroCustoEmpresa();
        centroCustoEmpresa.setEmpresa(empresa);
        return this.buildToDTOGeneric(centroCustoEmpresa, DTOCentroCusto.DTOCentroCustoEmpresa.class);
    }

    private CentroCusto verificaCodigo(CentroCusto aux) {
        Integer nivelCentroCusto = this.helperCentroCusto.getNivelCentroCusto(aux.getCodigo());
        aux.setCodigo(ToolClearData.clearPontoNumeros((String)aux.getCodigo()));
        if (aux.getCodigo().substring(3, 9).equals("000000")) {
            aux.setMarca(Short.valueOf(EnumConstSinteticoAnalitico.SINTETICO.getValue()));
            return aux;
        }
        if (this.isEquals(nivelCentroCusto, 1) ? this.isNull(this.findByCodigo(aux.getCodigo().substring(0, 3) + "000000")) != false : (this.isEquals(nivelCentroCusto, 2) || this.isEquals(nivelCentroCusto, 3)) && this.isNull(this.findByCodigo(aux.getCodigo().substring(0, 6) + "000")) != false && !this.isEquals(aux.getCodigo().substring(0, 6) + "000", aux.getCodigo())) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0097.002", new String[]{aux.getCodigo()}));
        }
        if (aux.getCodigo().endsWith("000")) {
            aux.setMarca(Short.valueOf(EnumConstSinteticoAnalitico.SINTETICO.getValue()));
        } else {
            aux.setMarca(Short.valueOf(EnumConstSinteticoAnalitico.ANALITICO.getValue()));
        }
        return aux;
    }

    public List<DTOPontoDepartamento> findDepartamentosPonto(Date dataBaseSincDados, Date dataUltimaSincronizacao) {
        return ((DaoCentroCustoImpl)this.getGenericDao()).findDepartamentosPonto(dataBaseSincDados, dataUltimaSincronizacao);
    }

    @Override
    public CentroCusto beforeSave(CentroCusto aux) {
        aux.getCentroCustoEmpresa().forEach(i -> i.setCentroCusto(aux));
        this.verificaCodigo(aux);
        return aux;
    }
}

