/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.centroestoque;

import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorservice.dao.impl.DaoCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceCentroEstoque;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceCentroEstoqueImpl
extends ServiceGenericEntityImpl<CentroEstoque, Long, DaoCentroEstoqueImpl>
implements ServiceCentroEstoque {
    @Autowired
    public ServiceCentroEstoqueImpl(DaoCentroEstoqueImpl genericDao) {
        super(genericDao);
    }

    @Override
    public CentroEstoque beforeSave(CentroEstoque vo) {
        if (vo.getUsuarios() != null) {
            vo.getUsuarios().forEach(i -> i.setCentroEstoque(vo));
        }
        return vo;
    }

    @Override
    public CentroEstoque findCentroEstoquePadraoEmp(Empresa empresa) {
        return ((DaoCentroEstoqueImpl)this.getGenericDao()).findCentroEstoquePadraoEmp(empresa);
    }

    @Override
    public CentroEstoque findCentroEstoquePorLocalizacaoProdutos(Empresa empresa, Produto produto) {
        return ((DaoCentroEstoqueImpl)this.getGenericDao()).findCentroEstoquePorLocalizacaoProdutos(empresa, produto);
    }

    public CentroEstoque getPorEmpresaParceiro(Empresa empresa, Pessoa parceiro) {
        return ((DaoCentroEstoqueImpl)this.getGenericDao()).getPorEmpresaParceiro(empresa, parceiro);
    }

    public CentroEstoque getByCodigoSincronizacao(String codigoSincronizacao) {
        return ((DaoCentroEstoqueImpl)this.getGenericDao()).getByCodigoSincronizacao(codigoSincronizacao);
    }

    public CentroEstoque getCentroEstoqueNome(String centroEstoque) {
        return ((DaoCentroEstoqueImpl)this.getGenericDao()).getCentroEstoqueNome(centroEstoque);
    }

    public List<CentroEstoque> getCentrosEstoqueEmpresa(Empresa logedEmpresa) {
        return ((DaoCentroEstoqueImpl)this.getDao()).getCentrosEstoqueEmpresa(logedEmpresa);
    }
}

