/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.checkinoutvisita;

import com.touchcomp.basementor.model.vo.CheckInOutVisita;
import com.touchcomp.basementor.model.vo.LocalCheckinout;
import com.touchcomp.basementor.model.vo.TipoCheckInOutVisita;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorbinary.model.ArqFotosCheckinoutVisita;
import com.touchcomp.basementorbinary.service.impl.arqfotoscheckinoutvisita.ServiceBinaryArqFotosCheckinoutVisitaImpl;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.checkinoutvisita.ServiceCheckInOutVisitaImpl;
import com.touchcomp.basementorservice.service.impl.localcheckinout.ServiceLocalCheckinoutImpl;
import com.touchcomp.basementorservice.service.impl.tipocheckinoutvisita.ServiceTipoCheckInOutVisitaImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.checkinout.mobile.DTOMobileCheckInOut;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceBuildCheckInOutMobile
extends ServiceGenericImpl {
    @Autowired
    ServiceBinaryArqFotosCheckinoutVisitaImpl serviceArq;
    @Autowired
    ServiceCheckInOutVisitaImpl serviceCheckInOut;
    @Autowired
    ServiceLocalCheckinoutImpl serviceLocalCheckInOut;
    @Autowired
    ServiceUsuarioImpl serviceUsuarioImpl;
    @Autowired
    ServiceTipoCheckInOutVisitaImpl serviceTipoCheckInOut;

    public List<CheckInOutVisita> saveAndProcessIt(String content) throws ExceptionIO {
        List data = ToolJson.readJsonList((String)content, DTOMobileCheckInOut.class);
        LinkedList<CheckInOutVisita> ret = new LinkedList<CheckInOutVisita>();
        for (DTOMobileCheckInOut dto : data) {
            CheckInOutVisita inout = this.serviceCheckInOut.getCheckInOutVisitaMobile(dto.getUsuarioIdentificador(), dto.getIdMobile());
            if (inout == null) {
                inout = new CheckInOutVisita();
            }
            inout.setDataCheckin(dto.getDataCheckin());
            inout.setDataSaida(dto.getDataSaida());
            inout.setLatitude(dto.getLatitude());
            inout.setLongitude(dto.getLongitude());
            inout.setDistanciaLocal(dto.getDistanciaLocal());
            inout.setTempoVisita(dto.getTempoVisita());
            if (ToolMethods.isWithData((Number)dto.getTipoCheckInVisitaIdentificador())) {
                inout.setTipoCheckInVisita((TipoCheckInOutVisita)this.serviceTipoCheckInOut.get(dto.getTipoCheckInVisitaIdentificador()));
            }
            if (ToolMethods.isWithData((Number)dto.getLocalCheckinoutIdentificador())) {
                inout.setLocalCheckinout((LocalCheckinout)this.serviceLocalCheckInOut.get(dto.getLocalCheckinoutIdentificador()));
            }
            if (ToolMethods.isWithData((Number)dto.getUsuarioIdentificador())) {
                inout.setUsuario((Usuario)this.serviceUsuarioImpl.get(dto.getUsuarioIdentificador()));
            }
            inout.setIdMobile(new BigInteger(dto.getIdentificador().toString()));
            inout = this.serviceCheckInOut.saveOrUpdate(inout, this.getFotos(inout, dto));
            ret.add(inout);
        }
        return ret;
    }

    private List<ArqFotosCheckinoutVisita> getFotos(CheckInOutVisita ch, DTOMobileCheckInOut dto) {
        LinkedList<ArqFotosCheckinoutVisita> ret = new LinkedList<ArqFotosCheckinoutVisita>();
        if (dto.getFotos() == null) {
            return ret;
        }
        for (DTOMobileCheckInOut.DTOFotos foto : dto.getFotos()) {
            ArqFotosCheckinoutVisita a = this.serviceArq.getArqFotosCheckinoutVisita(ch.getIdentificador(), dto.getIdMobile());
            if (a == null) {
                a = new ArqFotosCheckinoutVisita();
            }
            a.setConteudoArquivo(foto.getFoto());
            a.setIdCheckinoutVisita(ch.getIdentificador());
            a.setIdMobile(foto.getIdMobile());
            ret.add(a);
        }
        return ret;
    }
}

