/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.checklist;

import com.touchcomp.basementor.model.vo.CheckInOutVisita;
import com.touchcomp.basementor.model.vo.CheckList;
import com.touchcomp.basementor.model.vo.CheckListAssinatura;
import com.touchcomp.basementor.model.vo.CheckListItem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloCheckList;
import com.touchcomp.basementor.model.vo.ModeloCheckListItem;
import com.touchcomp.basementor.model.vo.ModeloCheckListItemOpcao;
import com.touchcomp.basementor.model.vo.OrigemCheckList;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorbinary.model.ArqCheckListAssinaturas;
import com.touchcomp.basementorbinary.model.ArqFotosItemCheckList;
import com.touchcomp.basementorbinary.service.impl.arqfotositemchecklist.ServiceBinaryArqFotosItemCheckListImpl;
import com.touchcomp.basementorbinary.service.impl.checklistassinatura.ServiceBinaryArqCheckListAssinaturaImpl;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.checkinoutvisita.ServiceCheckInOutVisitaImpl;
import com.touchcomp.basementorservice.service.impl.checklist.ServiceCheckListImpl;
import com.touchcomp.basementorservice.service.impl.checklistassinatura.ServiceCheckListAssinaturaImpl;
import com.touchcomp.basementorservice.service.impl.checklistitem.ServiceCheckListItemImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.modelochecklist.ServiceModeloCheckListImpl;
import com.touchcomp.basementorservice.service.impl.modelochecklistitem.ServiceModeloCheckListItemImpl;
import com.touchcomp.basementorservice.service.impl.modelochecklistitemopcao.ServiceModeloCheckListItemOpcaoImpl;
import com.touchcomp.basementorservice.service.impl.origemchecklist.ServiceOrigemCheckListImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.checklist.mobile.DTOMobileCheckList;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Deprecated
@Service
public class ServiceBuildCheckListMobile
extends ServiceGenericImpl {
    @Autowired
    ServiceCheckListImpl serviceCheckList;
    @Autowired
    ServiceUsuarioImpl serviceUsuarioImpl;
    @Autowired
    ServiceEmpresaImpl serviceEmpresaImpl;
    @Autowired
    ServiceModeloCheckListImpl serviceModeloCheckListImpl;
    @Autowired
    ServiceOrigemCheckListImpl serviceOrigemCheckListImpl;
    @Autowired
    ServiceCheckInOutVisitaImpl serviceCheckInOutVisitaImpl;
    @Autowired
    ServiceModeloCheckListItemImpl serviceModeloCheckListItemImpl;
    @Autowired
    ServiceModeloCheckListItemOpcaoImpl serviceModeloCheckListItemOpcaoImpl;
    @Autowired
    ServiceCheckListItemImpl serviceCheckListItem;
    @Autowired
    ServiceCheckListAssinaturaImpl serviceCheckListAssinatura;
    @Autowired
    ServiceBinaryArqFotosItemCheckListImpl serviceBinaryArqFotosItemCheckListImpl;
    @Autowired
    ServiceBinaryArqCheckListAssinaturaImpl serviceBinaryArqAssinaturasItemCheckListImpl;

    public List<CheckList> saveAndProcessIt(String content) throws ExceptionIO {
        List data = ToolJson.readJsonList((String)content, DTOMobileCheckList.class);
        LinkedList<CheckList> ret = new LinkedList<CheckList>();
        for (DTOMobileCheckList dto : data) {
            CheckList c = this.getCheckList(dto);
            HashMap<Integer, List<ArqFotosItemCheckList>> imagensItens = this.setItens(c, dto);
            HashMap<Integer, List<ArqCheckListAssinaturas>> imagensAssinaturas = this.setAssinaturas(c, dto);
            c = this.serviceCheckList.saveOrUpdate(c, imagensItens, imagensAssinaturas);
            ret.add(c);
        }
        return ret;
    }

    private CheckList getCheckList(DTOMobileCheckList ch) {
        Usuario user = (Usuario)this.serviceUsuarioImpl.get(ch.getUsuarioIdentificador());
        CheckList vo = this.serviceCheckList.getCheckList(user, new BigInteger(ch.getIdMobile().toString()));
        if (vo == null) {
            vo = new CheckList();
        }
        if (ch.getDataCadastro() != null && ch.getDataCadastro() > 0L) {
            vo.setDataCadastro(new Date(ch.getDataCadastro()));
        } else {
            vo.setDataCadastro(new Date());
        }
        vo.setDataHoraCheckList(new Date(ch.getDataHoraCheckList()));
        vo.setEmpresa((Empresa)this.serviceEmpresaImpl.get(ch.getEmpresaIdentificador()));
        vo.setIdMobile(new BigInteger(ch.getIdMobile().toString()));
        if (ToolMethods.isWithData((Number)ch.getModeloCheckListIdentificador())) {
            vo.setModeloCheckList((ModeloCheckList)this.serviceModeloCheckListImpl.get(ch.getModeloCheckListIdentificador()));
        }
        if (ToolMethods.isWithData((Number)ch.getOrigemCheckListIdentificador())) {
            vo.setOrigemCheckList((OrigemCheckList)this.serviceOrigemCheckListImpl.get(ch.getOrigemCheckListIdentificador()));
        }
        if (ToolMethods.isWithData((Number)ch.getCheckInOutVisitaIdentificador())) {
            vo.setCheckInOutVisita((CheckInOutVisita)this.serviceCheckInOutVisitaImpl.get(ch.getCheckInOutVisitaIdentificador()));
        }
        vo.setUsuario(user);
        vo.setObservacao(ch.getObservacao());
        return vo;
    }

    private HashMap<Integer, List<ArqFotosItemCheckList>> setItens(CheckList vo, DTOMobileCheckList ch) {
        List itens = vo.getItensCheckList();
        itens.clear();
        HashMap<Integer, List<ArqFotosItemCheckList>> imagens = new HashMap<Integer, List<ArqFotosItemCheckList>>();
        int i = 0;
        for (DTOMobileCheckList.CheckListItem chl : ch.getItensCheckList()) {
            CheckListItem item = new CheckListItem();
            item.setCheckList(vo);
            item.setInformadoFoto(chl.getInformadoFoto());
            if (ToolMethods.isWithData((Number)chl.getModeloCheckListItemIdentificador())) {
                item.setModeloCheckListItem((ModeloCheckListItem)this.serviceModeloCheckListItemImpl.get(chl.getModeloCheckListItemIdentificador()));
            }
            if (ToolMethods.isWithData((Number)chl.getModeloCheckListItOpcaoIdentificador())) {
                item.setModeloCheckListItOpcao((ModeloCheckListItemOpcao)this.serviceModeloCheckListItemOpcaoImpl.get(chl.getModeloCheckListItOpcaoIdentificador()));
            }
            item.setObservacao(chl.getObservacao());
            item.setIdMobile(new BigInteger(chl.getIdMobile().toString()));
            item.setIndice(Integer.valueOf(i));
            itens.add(item);
            imagens.put(item.getIndice(), this.getImagens(item, chl));
            ++i;
        }
        vo.setItensCheckList(itens);
        return imagens;
    }

    private HashMap<Integer, List<ArqCheckListAssinaturas>> setAssinaturas(CheckList vo, DTOMobileCheckList ch) {
        HashMap<Integer, List<ArqCheckListAssinaturas>> map = new HashMap<Integer, List<ArqCheckListAssinaturas>>();
        if (ch.getCheckListAssinaturas() == null) {
            return map;
        }
        int i = 0;
        for (DTOMobileCheckList.CheckListAssinatura ass : ch.getCheckListAssinaturas()) {
            CheckListAssinatura a = new CheckListAssinatura();
            a.setCheckList(vo);
            a.setIndice(Integer.valueOf(i));
            a.setDescricao(ass.getDescricao());
            a.setIdMobile(ass.getIdMobile());
            if (ass.getTipoAssinatura() != null) {
                a.setTipoAssinatura(Short.valueOf(ass.getTipoAssinatura().shortValue()));
            }
            vo.getCheckListAssinaturas().add(a);
            map.put(a.getIndice(), this.getAssinaturas(a, ch));
            ++i;
        }
        return map;
    }

    private List<ArqFotosItemCheckList> getImagens(CheckListItem item, DTOMobileCheckList.CheckListItem checkListItem) {
        LinkedList<ArqFotosItemCheckList> ret = new LinkedList<ArqFotosItemCheckList>();
        for (DTOMobileCheckList.DTOMobileCheckListItemFoto dto : checkListItem.getFotos()) {
            ArqFotosItemCheckList itemArq = this.serviceBinaryArqFotosItemCheckListImpl.getArqFotosItemCheckList(item.getIdentificador(), dto.getIdMobile());
            if (itemArq == null) {
                itemArq = new ArqFotosItemCheckList();
                itemArq.setIdMobile(new BigInteger(String.valueOf(dto.getIdMobile())));
                itemArq.setIdItemCheckList(item.getIdentificador());
            }
            itemArq.setConteudoArquivo(dto.getFoto());
            ret.add(itemArq);
        }
        return ret;
    }

    private List<ArqCheckListAssinaturas> getAssinaturas(CheckListAssinatura item, DTOMobileCheckList ch) {
        LinkedList<ArqCheckListAssinaturas> ret = new LinkedList<ArqCheckListAssinaturas>();
        for (DTOMobileCheckList.CheckListAssinatura dto : ch.getCheckListAssinaturas()) {
            ArqCheckListAssinaturas a = this.serviceBinaryArqAssinaturasItemCheckListImpl.getAssinaturasCheckList(item.getIdentificador(), dto.getIdMobile());
            if (a == null) {
                a = new ArqCheckListAssinaturas();
            }
            a.setConteudoArquivo(dto.getFoto());
            a.setIdMobile(new BigInteger(dto.getIdMobile().toString()));
            a.setIdCheckListAssinatura(item.getIdentificador());
            ret.add(a);
        }
        return ret;
    }
}

