/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.checklist;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CheckList;
import com.touchcomp.basementor.model.vo.CheckListAssinatura;
import com.touchcomp.basementor.model.vo.CheckListItem;
import com.touchcomp.basementor.model.vo.ModeloCheckList;
import com.touchcomp.basementor.model.vo.ModeloCheckListItem;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorbinary.model.ArqCheckListAssinaturas;
import com.touchcomp.basementorbinary.model.ArqFotosItemCheckList;
import com.touchcomp.basementorbinary.service.impl.arqfotositemchecklist.ServiceBinaryArqFotosItemCheckListImpl;
import com.touchcomp.basementorbinary.service.impl.checklistassinatura.ServiceBinaryArqCheckListAssinaturaImpl;
import com.touchcomp.basementorservice.dao.impl.DaoCheckListImpl;
import com.touchcomp.basementorservice.model.TempSaveObj;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.checklistassinatura.ServiceCheckListAssinaturaImpl;
import com.touchcomp.basementorservice.service.impl.checklistitem.ServiceCheckListItemImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceCheckList;
import com.touchcomp.basementorvalidator.entities.ValidGeneric;
import com.touchcomp.touchvomodel.vo.checklist.web.DTOCheckList;
import com.touchcomp.touchvomodel.web.WebDTOInputObject;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceCheckListImpl
extends ServiceGenericEntityImpl<CheckList, Long, DaoCheckListImpl>
implements ServiceCheckList {
    @Autowired
    ServiceBinaryArqFotosItemCheckListImpl serviceBinaryArqFotos;
    @Autowired
    ServiceBinaryArqCheckListAssinaturaImpl serviceBinaryArqAssinatura;
    @Autowired
    ServiceCheckListItemImpl serviceCheckListItem;
    @Autowired
    ServiceCheckListAssinaturaImpl serviceCheckListAssinatura;

    @Autowired
    public ServiceCheckListImpl(DaoCheckListImpl genericDao) {
        super(genericDao);
    }

    @Override
    public CheckList beforeSave(CheckList c) {
        c.getItensCheckList().forEach(i -> i.setCheckList(c));
        c.getCheckListAssinaturas().forEach(i -> i.setCheckList(c));
        c.getRelacionamentosGerados().forEach(i -> i.setCheckList(c));
        return c;
    }

    @Override
    public CheckList saveOrUpdateOnly(CheckList checkList) {
        checkList = ((DaoCheckListImpl)this.getDao()).saveOrUpdate(checkList);
        return checkList;
    }

    @Override
    public CheckList saveOrUpdate(CheckList checkList, HashMap<Integer, List<ArqFotosItemCheckList>> imagens, HashMap<Integer, List<ArqCheckListAssinaturas>> imagensAssinaturas) {
        checkList = this.saveOrUpdate(checkList);
        checkList = this.salvarCheckImages(checkList, imagens);
        checkList = this.salvarCheckAssinaturas(checkList, imagensAssinaturas);
        return checkList;
    }

    public TempSaveObj<CheckList> saveOrUpdate(WebDTOInputObject<DTOCheckList> entity, ValidGeneric<CheckList> validator) {
        HashMap<Integer, List<ArqFotosItemCheckList>> imagens = new HashMap<Integer, List<ArqFotosItemCheckList>>();
        TempSaveObj<CheckList> temp = new TempSaveObj<CheckList>();
        temp.setValidator(validator);
        CheckList toSave = (CheckList)this.buildToEntity((DTOCheckList)entity.getInput());
        validator.clearContainer();
        validator.isValidData((InterfaceVO)toSave);
        if (validator.hasErrors()) {
            temp.setStatus(EnumConstantsMentorStatus.ERRO);
            return temp;
        }
        this.salvarImagem(entity, imagens);
        this.beforeSave(toSave);
        toSave = this.saveOrUpdate(toSave, imagens, new HashMap<Integer, List<ArqCheckListAssinaturas>>());
        temp.setResult(toSave);
        return temp;
    }

    private List<ArqFotosItemCheckList> getImagens(DTOCheckList.DTOCheckListItem d) {
        LinkedList<ArqFotosItemCheckList> ret = new LinkedList<ArqFotosItemCheckList>();
        if (d.getFotos() != null) {
            for (DTOCheckList.DTOFoto dto : d.getFotos()) {
                if (!this.isStrWithData(dto.getFoto())) continue;
                ArqFotosItemCheckList itemArq = null;
                if (dto.getIdFoto() != null) {
                    itemArq = this.serviceBinaryArqFotos.getIdentificadorArqFotosItemCheckList(dto.getIdFoto());
                }
                if (itemArq == null) {
                    itemArq = new ArqFotosItemCheckList();
                    itemArq.setIdItemCheckList(d.getIdentificador());
                }
                itemArq.setConteudoArquivo(dto.getFoto());
                ret.add(itemArq);
            }
        }
        return ret;
    }

    private CheckList salvarCheckImages(CheckList ch, HashMap<Integer, List<ArqFotosItemCheckList>> imagens) {
        if (imagens == null) {
            imagens = new HashMap();
        }
        for (CheckListItem it : ch.getItensCheckList()) {
            ArrayList data = imagens.get(it.getIndice());
            data = data == null ? new ArrayList() : data;
            it = this.serviceCheckListItem.saveOrUpdate(it);
            for (ArqFotosItemCheckList d : data) {
                d.setIdItemCheckList(it.getIdentificador());
                this.serviceBinaryArqFotos.saveOrUpdate((Object)d);
            }
        }
        return ch;
    }

    public CheckList getCheckList(Usuario user, BigInteger idMobile) {
        return ((DaoCheckListImpl)this.getDao()).getCheckList(user, idMobile);
    }

    private CheckList salvarCheckAssinaturas(CheckList ch, HashMap<Integer, List<ArqCheckListAssinaturas>> imagens) {
        if (imagens == null) {
            imagens = new HashMap();
        }
        for (CheckListAssinatura it : ch.getCheckListAssinaturas()) {
            ArrayList data = imagens.get(it.getIndice());
            data = data == null ? new ArrayList() : data;
            it = this.serviceCheckListAssinatura.saveOrUpdate(it);
            for (ArqCheckListAssinaturas d : data) {
                d.setIdCheckListAssinatura(it.getIdentificador());
                this.serviceBinaryArqAssinatura.saveOrUpdate((Object)d);
            }
        }
        return ch;
    }

    public List<CheckListItem> newItemModeloCheckList(ModeloCheckList modeloCheckList) {
        ArrayList<CheckListItem> listCheckListItem = new ArrayList<CheckListItem>();
        for (ModeloCheckListItem modeloCheckListItem : modeloCheckList.getItensCheckList()) {
            CheckListItem c = new CheckListItem();
            c.setModeloCheckListItem(modeloCheckListItem);
            c.setIndice(modeloCheckListItem.getIndice());
            listCheckListItem.add(c);
        }
        return listCheckListItem;
    }

    private void salvarImagem(WebDTOInputObject<DTOCheckList> entity, HashMap<Integer, List<ArqFotosItemCheckList>> imagens) {
        int i = 1;
        for (DTOCheckList.DTOCheckListItem d : ((DTOCheckList)entity.getInput()).getItensCheckList()) {
            imagens.put(i, this.getImagens(d));
            ++i;
        }
    }
}

