/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.chequeterceiros;

import com.touchcomp.basementor.model.vo.BaixaChequeTerceiros;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.ChequeTerceiros;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorservice.dao.impl.DaoChequeTerceirosImpl;
import com.touchcomp.basementorservice.helpers.impl.chequeterceiros.HelperChequeTerceiros;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.baixachequeterceiros.ServiceBaixaChequeTerceirosImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceChequeTerceiros;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.chequeterceiros.web.DTOChequeTerceiros;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceChequeTerceirosImpl
extends ServiceGenericEntityImpl<ChequeTerceiros, Long, DaoChequeTerceirosImpl>
implements ServiceChequeTerceiros {
    ServiceBaixaChequeTerceirosImpl serviceBaixaChequeTerceiros;

    @Autowired
    public ServiceChequeTerceirosImpl(DaoChequeTerceirosImpl genericDao, ServiceBaixaChequeTerceirosImpl serviceBaixaChequeTerceiros) {
        super(genericDao);
        this.serviceBaixaChequeTerceiros = serviceBaixaChequeTerceiros;
    }

    @Override
    public ChequeTerceiros beforeSave(ChequeTerceiros entity) {
        List<ChequeTerceiros> chequesBanco;
        if (entity.getIdentificador() != null && (chequesBanco = this.verificarDadosCheque(entity)) != null && !chequesBanco.isEmpty()) {
            throw new ExceptionRuntimeBase("E.ERP.0330.001");
        }
        if (entity.getBaixaChequeTerceiros() != null) {
            entity.getBaixaChequeTerceiros().forEach(baixa -> baixa.setChequeTerceiros(entity));
        }
        if (entity.getMovimentosBancarios() != null) {
            entity.getMovimentosBancarios().forEach(baixa -> baixa.setChequeTerceiros(entity));
        }
        if (entity.getCnpjTitular() != null) {
            entity.setCnpjTitular(ToolString.refina((String)entity.getCnpjTitular()));
        }
        return entity;
    }

    @Override
    public Double valorChequesNaoCompensados(Long idPessoa) {
        return ((DaoChequeTerceirosImpl)this.getGenericDao()).valorChequesNaoCompensados(idPessoa);
    }

    @Override
    public Double valorChequesDevolvidos(Long idPessoa) {
        return ((DaoChequeTerceirosImpl)this.getGenericDao()).valorChequesDevolvidos(idPessoa);
    }

    @Override
    public Double valorChequesNaoCompensadosGrupoPessoa(Long idGrupoPessoa) {
        return ((DaoChequeTerceirosImpl)this.getGenericDao()).valorChequesNaoCompensadosGrupoPessoa(idGrupoPessoa);
    }

    @Override
    public Double valorChequesDevolvidosGrupoPessoas(Long idGrupoPessoa) {
        return ((DaoChequeTerceirosImpl)this.getGenericDao()).valorChequesDevolvidosGrupoPessoas(idGrupoPessoa);
    }

    public List<ChequeTerceiros> getChequesTerceirosByDataVencimento(Date dataVencInicial, Date dataVencFinal, GrupoEmpresa grupoEmpresa, Empresa empresa, Short visualizarDadosOutrasEmp) {
        return ((DaoChequeTerceirosImpl)this.getDao()).getChequesTerceirosByDataVencimento(dataVencInicial, dataVencFinal, grupoEmpresa, empresa, visualizarDadosOutrasEmp);
    }

    public ChequeTerceiros getUltChequeTerceirosSugestao(String banco, String agencia, String conta) {
        return ((DaoChequeTerceirosImpl)this.getDao()).getUltChequeTerceirosSugestao(banco, conta, agencia);
    }

    public List<ChequeTerceiros> verificarDadosCheque(ChequeTerceiros cheque) {
        return ((DaoChequeTerceirosImpl)this.getDao()).verificarDadosCheque(cheque);
    }

    public Boolean isAllowedEditCheque(Long id) {
        ChequeTerceiros cheque = (ChequeTerceiros)this.get(id);
        if (cheque != null) {
            List<BaixaChequeTerceiros> listBaixa = this.serviceBaixaChequeTerceiros.pesquisarBaixaChequeTerceirosPorChequeTerceiros(cheque);
            if (listBaixa == null || listBaixa.isEmpty()) {
                return true;
            }
            return false;
        }
        return true;
    }

    public DTOChequeTerceiros getByIdentificadorAndEmpresa(Long id, Empresa empresa) {
        ChequeTerceiros vo = ((DaoChequeTerceirosImpl)this.getDao()).getByIdentificadorAndEmpresa(id, empresa);
        if (vo != null) {
            return this.buildToDTO(vo, DTOChequeTerceiros.class);
        }
        return null;
    }

    public ChequeTerceiros getChequeTerceiros(String agencia, String banco, String conta, String numero) {
        return ((DaoChequeTerceirosImpl)this.getDao()).getChequeTerceiros(agencia, banco, conta, numero);
    }

    public DTOChequeTerceiros preencherDadosCheque(DTOChequeTerceiros cheque) {
        if (cheque == null || !ToolMethods.isStrWithData((String)cheque.getCodigoCMC())) {
            return cheque;
        }
        ChequeTerceiros vo = (ChequeTerceiros)this.buildToEntity(cheque);
        HelperChequeTerceiros helper = new HelperChequeTerceiros().build(vo);
        helper.preencherDadosCheque(cheque.getCodigoCMC());
        return this.buildToDTO(vo, DTOChequeTerceiros.class);
    }

    public List<ChequeTerceiros> findChequeTerceiros(Date dataEmissaoInicial, Date dataEmissaoFinal, Date dataVencimentoInicial, Date dataVencimentoFinal, CarteiraCobranca carteiraCobranca) {
        return ((DaoChequeTerceirosImpl)this.getDao()).findChequeTerceiros(dataEmissaoInicial, dataEmissaoFinal, dataVencimentoInicial, dataVencimentoFinal, carteiraCobranca);
    }

    public ChequeTerceiros getChequeTerceirosNaoCompensados(Long cheque, Empresa empresa, Short filtrarEmpresa) {
        return ((DaoChequeTerceirosImpl)this.getGenericDao()).getChequeTerceirosNaoCompensados(cheque, empresa, filtrarEmpresa);
    }

    public List<ChequeTerceiros> getChequeTerceirosPeloBorderoNaoCompensados(Long idBordero, Empresa empresa, Short filtrarEmpresa) {
        return ((DaoChequeTerceirosImpl)this.getGenericDao()).getChequeTerceirosPeloBorderoNaoCompensados(idBordero, empresa, filtrarEmpresa);
    }
}

