/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.cidade;

import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorservice.dao.impl.DaoCidadeImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.cidade.web.DTOCidade;
import java.util.LinkedList;
import java.util.List;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class ServiceCidadeImpl
extends ServiceGenericEntityImpl<Cidade, Long, DaoCidadeImpl> {
    public ServiceCidadeImpl(DaoCidadeImpl genericDao) {
        super(genericDao);
    }

    @Cacheable(cacheNames={"buscaDadosEnderecoCep"}, keyGenerator="customKeyGenerator")
    public Cidade getByCodigoIBGE(String ibge) {
        return ((DaoCidadeImpl)this.getGenericDao()).getByCodigoIBGE(ibge);
    }

    @Cacheable(cacheNames={"buscaDadosEnderecoCep"}, keyGenerator="customKeyGenerator")
    public Cidade getByCodigoIBGECompleto(String ibge) {
        if (!ToolMethods.isStrWithData((String)ibge)) {
            return null;
        }
        return ((DaoCidadeImpl)this.getGenericDao()).getByCodigoIBGECompleto(ibge);
    }

    @Cacheable(cacheNames={"buscaDadosEnderecoCep"}, keyGenerator="customKeyGenerator")
    public Cidade getByCep(String cep) {
        return ((DaoCidadeImpl)this.getGenericDao()).getByCep(cep);
    }

    public List<Cidade> getCidadeByUnidadeFederativa(Long idUnidadeFederativa) {
        return ((DaoCidadeImpl)this.getGenericDao()).getCidadeByUnidadeFederativa(idUnidadeFederativa);
    }

    public List<DTOCidade> getCidadeByUnidadeFederativaDTO(Long idUnidadeFederativa) {
        return this.buildToDTOGeneric(((DaoCidadeImpl)this.getGenericDao()).getCidadeByUnidadeFederativa(idUnidadeFederativa), DTOCidade.class);
    }

    @Cacheable(cacheNames={"buscaDadosEnderecoCep"}, keyGenerator="customKeyGenerator")
    public Cidade getCidade(String cep, String codIbge) {
        Cidade cid = null;
        if (TMethods.isStrWithData((String)codIbge)) {
            cid = this.getByCodigoIBGECompleto(codIbge);
        }
        if (cid == null) {
            cid = this.getByCep(cep);
        }
        return cid;
    }

    public List getCidadeByUnidadeFederativa(UnidadeFederativa p) {
        if (p == null) {
            return new LinkedList();
        }
        return this.getCidadeByUnidadeFederativa(p.getIdentificador());
    }
}

