/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.classificacaoprodutos;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.vo.ClassificacaoProdutos;
import com.touchcomp.basementorservice.dao.impl.DaoClassificacaoProdutos;
import com.touchcomp.basementorservice.helpers.impl.classificacaoprodutos.HelperClassificacaoProdutos;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementortools.tools.string.ToolString;
import org.springframework.stereotype.Service;

@Service
public class ServiceClassificacaoProdutosImpl
extends ServiceGenericEntityImpl<ClassificacaoProdutos, Long, DaoClassificacaoProdutos> {
    HelperClassificacaoProdutos helper;

    public ServiceClassificacaoProdutosImpl(DaoClassificacaoProdutos genericDao, HelperClassificacaoProdutos helper) {
        super(genericDao);
        this.helper = helper;
    }

    @Override
    public DaoClassificacaoProdutos getGenericDao() {
        return (DaoClassificacaoProdutos)super.getGenericDao();
    }

    @Override
    public ClassificacaoProdutos beforeSaveEntity(ClassificacaoProdutos aux) {
        String codigo = this.helper.getCodigoPai(aux.getCodigo());
        ClassificacaoProdutos pai = this.getByCodigo(codigo);
        aux.setClassificacaoPai(pai);
        String gerencial = ToolString.refina((String)aux.getCodigo());
        aux.setCodigo(gerencial);
        if (gerencial.endsWith("000")) {
            aux.setMarca(Short.valueOf(EnumConstSinteticoAnalitico.SINTETICO.getValue()));
        } else {
            aux.setMarca(Short.valueOf(EnumConstSinteticoAnalitico.ANALITICO.getValue()));
        }
        return aux;
    }

    private ClassificacaoProdutos getByCodigo(String codigo) {
        return ((DaoClassificacaoProdutos)this.getDao()).getByCodigo(codigo);
    }
}

