/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.cliente;

import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.ClienteFichaFinanceiraAutorizados;
import com.touchcomp.basementor.model.vo.ClienteNFCe;
import com.touchcomp.basementor.model.vo.ClienteNFCeMeioPagamento;
import com.touchcomp.basementor.model.vo.ClienteVeiculo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LogCliente;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TipoPagamentoNFe;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.Veiculo;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.categoriapessoa.ServiceCategoriaPessoaImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.logcliente.ServiceLogClienteImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementorservice.service.impl.tipopagamentonfe.ServiceTipoPagamentoNFeImpl;
import com.touchcomp.basementorservice.service.impl.veiculo.ServiceVeiculoImpl;
import com.touchcomp.touchvomodel.vo.cliente.web.DTOCliente;
import com.touchcomp.touchvomodel.vo.logcliente.web.DTOLogCliente;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class SCompCliente
extends ServiceGenericImpl {
    private final ServiceEmpresaImpl serviceEmpresa;
    private final ServiceTipoPagamentoNFeImpl serviceTipoPagamentoNFe;
    private final ServicePessoaImpl servicePessoa;
    private final ServiceCategoriaPessoaImpl serviceCategoriaPessoa;
    private final ServiceLogClienteImpl serviceLogCliente;
    private final ServiceVeiculoImpl serviceVeiculo;

    public List<DTOCliente.DTOClienteNFCe> getTipoNotaNFCe(Long[] identificadores) throws ExceptionObjNotFound {
        List empresas = this.serviceEmpresa.gets(identificadores);
        LinkedList<DTOCliente.DTOClienteNFCe> result = new LinkedList<DTOCliente.DTOClienteNFCe>();
        if (this.isNotNull(empresas).booleanValue()) {
            for (Empresa empresa : empresas) {
                ClienteNFCe vo = new ClienteNFCe();
                vo.setEmpresa(empresa);
                vo.setAtivo(Short.valueOf(EnumConstStatusObjeto.ATIVO.getValue()));
                result.add(this.buildToDTOGeneric(vo, DTOCliente.DTOClienteNFCe.class));
            }
        }
        return result;
    }

    public List<DTOCliente.DTOClienteNFCeMeioPagamento> getMeioPagamentoNFCe(Long[] identificadores) throws ExceptionObjNotFound {
        List tiposPagNFe = this.serviceTipoPagamentoNFe.gets(identificadores);
        LinkedList<DTOCliente.DTOClienteNFCeMeioPagamento> result = new LinkedList<DTOCliente.DTOClienteNFCeMeioPagamento>();
        if (this.isNotNull(tiposPagNFe).booleanValue()) {
            for (TipoPagamentoNFe tipoPagNFe : tiposPagNFe) {
                ClienteNFCeMeioPagamento vo = new ClienteNFCeMeioPagamento();
                vo.setTipoPagamentoNFe(tipoPagNFe);
                vo.setAtivo(Short.valueOf(EnumConstStatusObjeto.ATIVO.getValue()));
                result.add(this.buildToDTOGeneric(vo, DTOCliente.DTOClienteNFCeMeioPagamento.class));
            }
        }
        return result;
    }

    public List<DTOCliente.DTOClienteFichaFinanceiraAutorizados> getPessoaAutorizada(Long[] identificadores) throws ExceptionObjNotFound {
        List pessoas = this.servicePessoa.gets(identificadores);
        LinkedList<DTOCliente.DTOClienteFichaFinanceiraAutorizados> result = new LinkedList<DTOCliente.DTOClienteFichaFinanceiraAutorizados>();
        if (this.isNotNull(pessoas).booleanValue()) {
            for (Pessoa pessoa : pessoas) {
                ClienteFichaFinanceiraAutorizados vo = new ClienteFichaFinanceiraAutorizados();
                vo.setPessoa(pessoa);
                vo.setAtivo(Short.valueOf(EnumConstStatusObjeto.ATIVO.getValue()));
                result.add(this.buildToDTOGeneric(vo, DTOCliente.DTOClienteFichaFinanceiraAutorizados.class));
            }
        }
        return result;
    }

    public List<DTOCliente.DTOUnidadeFatCliente> getUnidadeFaturamento(Long[] identificadores, Long idCategoriaPessoa) throws ExceptionObjNotFound {
        List pessoas = this.servicePessoa.gets(identificadores);
        CategoriaPessoa categoriaPes = (CategoriaPessoa)this.serviceCategoriaPessoa.get(idCategoriaPessoa);
        LinkedList<DTOCliente.DTOUnidadeFatCliente> result = new LinkedList<DTOCliente.DTOUnidadeFatCliente>();
        if (this.isNotNull(pessoas).booleanValue()) {
            for (Pessoa pessoa : pessoas) {
                UnidadeFatCliente vo = new UnidadeFatCliente();
                vo.setPessoa(pessoa);
                vo.setCategoriaPessoa(categoriaPes);
                result.add(this.buildToDTOGeneric(vo, DTOCliente.DTOUnidadeFatCliente.class));
            }
        }
        return result;
    }

    public List<DTOCliente.DTOClienteVeiculo> getVeiculo(Long[] identificadores) throws ExceptionObjNotFound {
        List veiculos = this.serviceVeiculo.gets(identificadores);
        LinkedList<DTOCliente.DTOClienteVeiculo> result = new LinkedList<DTOCliente.DTOClienteVeiculo>();
        if (this.isNotNull(veiculos).booleanValue()) {
            for (Veiculo veiculo : veiculos) {
                ClienteVeiculo vo = new ClienteVeiculo();
                vo.setVeiculo(veiculo);
                result.add(this.buildToDTOGeneric(vo, DTOCliente.DTOClienteVeiculo.class));
            }
        }
        return result;
    }

    public DTOLogCliente buscarUltimoLogCliente(Cliente cliente) {
        LogCliente log = this.serviceLogCliente.getLastLogCliente(cliente);
        if (this.isNotNull(log).booleanValue()) {
            return this.buildToDTOGeneric(log, DTOLogCliente.class);
        }
        return null;
    }

    @Generated
    public SCompCliente(ServiceEmpresaImpl serviceEmpresa, ServiceTipoPagamentoNFeImpl serviceTipoPagamentoNFe, ServicePessoaImpl servicePessoa, ServiceCategoriaPessoaImpl serviceCategoriaPessoa, ServiceLogClienteImpl serviceLogCliente, ServiceVeiculoImpl serviceVeiculo) {
        this.serviceEmpresa = serviceEmpresa;
        this.serviceTipoPagamentoNFe = serviceTipoPagamentoNFe;
        this.servicePessoa = servicePessoa;
        this.serviceCategoriaPessoa = serviceCategoriaPessoa;
        this.serviceLogCliente = serviceLogCliente;
        this.serviceVeiculo = serviceVeiculo;
    }
}

