/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.cliente;

import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.ClienteFaturamento;
import com.touchcomp.basementor.model.vo.ClienteFichaFinanceira;
import com.touchcomp.basementor.model.vo.ClienteFinanceiro;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.GeracaoContaPessoa;
import com.touchcomp.basementor.model.vo.OpcoesMobile;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorservice.helpers.impl.cliente.HelperCliente;
import com.touchcomp.basementorservice.helpers.impl.pessoa.HelperPessoa;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.cidade.ServiceCidadeImpl;
import com.touchcomp.basementorservice.service.impl.cliente.ServiceClienteImpl;
import com.touchcomp.basementorservice.service.impl.condicoespagamento.ServiceCondicoesPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.representante.ServiceRepresentanteImpl;
import com.touchcomp.basementorservice.service.impl.tipofrete.ServiceTipoFreteImpl;
import com.touchcomp.basementorservice.service.interfaces.ServicePessoa;
import com.touchcomp.basementorservice.service.interfaces.ServicePlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.cliente.mobile.rec.DTOMobileClienteRec;
import com.touchcomp.touchvomodel.webservices.PackObjectsSinc;
import com.touchcomp.touchvomodel.webservices.PackObjectsSincChild;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceBuildClienteMobile
extends ServiceGenericImpl {
    @Autowired
    private ServiceClienteImpl serviceCliente;
    @Autowired
    private ServicePessoa servicePessoa;
    @Autowired
    private ServicePlanoConta servicePlanoConta;
    @Autowired
    private ServiceCondicoesPagamentoImpl serviceCondicoesPagamento;
    @Autowired
    private ServiceTipoFreteImpl serviceTipoFrete;
    @Autowired
    private ServiceRepresentanteImpl serviceRepresentante;
    @Autowired
    private ServiceCidadeImpl serviceCidade;
    @Autowired
    private HelperPessoa helperPessoa;

    public List<PackObjectsSinc> saveClientes(String content) throws ExceptionIO, ExceptionObjectNotFound, ExceptionInvalidData {
        List liberacoes = ToolJson.readJsonList((String)content, DTOMobileClienteRec.class);
        List<PackObjectsSinc> data = this.sincronizaClientes(liberacoes);
        return data;
    }

    private List<PackObjectsSinc> sincronizaClientes(List<DTOMobileClienteRec> pack) throws ExceptionObjectNotFound, ExceptionInvalidData {
        ArrayList<PackObjectsSinc> ret = new ArrayList<PackObjectsSinc>();
        for (DTOMobileClienteRec clienteMob : pack) {
            PackObjectsSinc pa = new PackObjectsSinc();
            Cliente clienteERP = this.getClienteCnpj(clienteMob.getCnpj());
            Empresa emp = this.getSharedData().getEmpresa(clienteMob.getIdEmpresa());
            if (clienteERP == null) {
                clienteERP = new Cliente();
            }
            if (clienteERP.getPessoa() == null) {
                clienteERP.setPessoa(this.getPessoa(clienteMob.getCnpj()));
            }
            if (clienteERP.getPessoa() == null) {
                Pessoa pes = new Pessoa();
                pes.setDataCadastro(new Date());
                clienteERP.setPessoa(pes);
            }
            clienteERP.getPessoa().setNome(this.checkAndCutText(clienteMob.getNome(), 60));
            clienteERP.getPessoa().setNomeFantasia(this.checkAndCutText(clienteMob.getNomeFantasia(), 60));
            clienteERP.getPessoa().setObservacao(clienteMob.getObservacao());
            clienteERP.getPessoa().setAtivo(Short.valueOf((short)0));
            this.atualizaPessoa(clienteERP.getPessoa(), clienteMob);
            this.atualizaCliente(clienteERP, clienteMob, emp, pa);
            this.atualizaClienteUnidadeFat(clienteERP);
            clienteERP = this.serviceCliente.saveOrUpdate(clienteERP);
            pa.setIdObjectMentor(clienteERP.getIdentificador());
            pa.setIdObjectMobile(clienteMob.getIdentificador());
            pa.setStatus(clienteMob.getStatusCliente());
            this.addIdCnpjInsc(pa, clienteERP, clienteMob);
            if (clienteERP.getPessoa().getContasPessoa() == null) {
                clienteERP.getPessoa().setContasPessoa(new GeracaoContaPessoa());
            }
            ret.add(pa);
        }
        return ret;
    }

    private void addIdCnpjInsc(PackObjectsSinc pa, Cliente cl, DTOMobileClienteRec c) {
        block0: for (DTOMobileClienteRec.UnidadeFatClienteReceiveLocal u : c.getUnidadeFatCliente()) {
            for (UnidadeFatCliente uc : cl.getUnidadeFatClientes()) {
                if (!this.assertEquals(cl, c, u, uc, pa)) continue;
                PackObjectsSincChild ch = new PackObjectsSincChild();
                ch.setChave("unidade.fat.cliente");
                ch.setIdObjectMentor(uc.getIdentificador());
                ch.setIdObjectMobile(u.getIdentificador());
                pa.getChildren().add(ch);
                continue block0;
            }
        }
    }

    private boolean assertEquals(Cliente cl, DTOMobileClienteRec c, DTOMobileClienteRec.UnidadeFatClienteReceiveLocal u, UnidadeFatCliente uc, PackObjectsSinc pa) {
        if (cl.getUnidadeFatClientes().size() == 1) {
            return true;
        }
        if (!c.getCnpj().equalsIgnoreCase(uc.getCliente().getPessoa().getComplemento().getCnpj())) {
            return false;
        }
        if (u.getInscEstadual() == null && uc.getPessoa().getComplemento().getInscEst() != null) {
            return false;
        }
        return u.getInscEstadual().equalsIgnoreCase(uc.getPessoa().getComplemento().getInscEst());
    }

    private void atualizaClienteUnidadeFat(Cliente c) {
        for (UnidadeFatCliente unif : c.getUnidadeFatClientes()) {
            unif.setCliente(c);
        }
    }

    private void atualizaCliente(Cliente cl, DTOMobileClienteRec c, Empresa emp, PackObjectsSinc pa) throws ExceptionObjectNotFound {
        OpcoesMobile op = this.getSharedData().getOpcoesMobile(emp);
        cl.setAtivo(Short.valueOf((short)0));
        if (cl.getClassificacaoClientes() == null) {
            cl.setClassificacaoClientes(op.getClassificacaoClientes());
        }
        if (cl.getDataCadastro() == null) {
            cl.setDataCadastro(new Date());
        }
        cl.setEmpresa(emp);
        if (cl.getRegiao() == null) {
            cl.setRegiao(op.getRegiao());
        }
        this.verificaClienteFinanceiro(cl, c, op, emp);
        this.verificaClienteFaturamento(cl, c, op, emp);
        this.verificaFichaFinanceira(cl, c, op, emp);
        this.verificaUnidadeFatCliente(cl, c, pa);
    }

    private void verificaFichaFinanceira(Cliente cl, DTOMobileClienteRec c, OpcoesMobile op, Empresa emp) {
        ClienteFichaFinanceira fat = cl.getFichaFinanceira();
        if (fat == null) {
            fat = new ClienteFichaFinanceira();
            cl.setFichaFinanceira(fat);
            fat.setCliente(cl);
        }
    }

    private void verificaClienteFaturamento(Cliente cl, DTOMobileClienteRec c, OpcoesMobile op, Empresa emp) {
        ClienteFaturamento fat = cl.getFaturamento();
        if (fat == null) {
            fat = new ClienteFaturamento();
            cl.setFaturamento(fat);
            fat.setCliente(cl);
        }
        if (fat.getCategoriaPessoa() == null) {
            fat.setCategoriaPessoa(op.getCategoriaPessoa());
        }
        if (fat.getCondicaoPagamento() == null) {
            fat.setCondicaoPagamento(op.getCondicoesPagamento());
        }
        fat.setObservacaoPedido(c.getObservacao());
        if (op.getRamoAtividade() == null) {
            fat.setRamoAtividade(op.getRamoAtividade());
        }
        fat.setCondicaoPagamento(this.getCondicoesPagamento(fat, c, op));
        fat.setTipoFrete(this.getTipoFrete(fat, c, op));
        this.calcularDistancia(cl.getPessoa(), c, op, emp);
        this.calcularPontosCardeais(cl.getPessoa(), c, op, emp);
        fat.setRepresentante(this.getRepresentanteByIdPessoa(fat, c.getIdPessoaRepresentante(), op));
        if (op.getTipoFrete() == null) {
            fat.setTipoFrete(op.getTipoFrete());
        }
        if (fat.getTransportadora() == null) {
            fat.setTransportadora(op.getTransportador());
        }
    }

    private TipoFrete getTipoFrete(ClienteFaturamento fat, DTOMobileClienteRec c, OpcoesMobile op) {
        TipoFrete cond = fat.getTipoFrete();
        if (cond == null && c.getIdTipoFrete() != null) {
            cond = (TipoFrete)this.serviceTipoFrete.get(c.getIdTipoFrete());
        }
        if (cond == null) {
            cond = op.getTipoFrete();
        }
        return cond;
    }

    private CondicoesPagamento getCondicoesPagamento(ClienteFaturamento fat, DTOMobileClienteRec c, OpcoesMobile op) {
        CondicoesPagamento cond = fat.getCondicaoPagamento();
        if (cond == null && c.getIdTipoFrete() != null) {
            cond = (CondicoesPagamento)this.serviceCondicoesPagamento.get(c.getIdCondPagamento());
        }
        if (cond == null) {
            cond = op.getCondicoesPagamento();
        }
        return cond;
    }

    private void calcularDistancia(Pessoa pes, DTOMobileClienteRec c, OpcoesMobile op, Empresa emp) {
        try {
            this.helperPessoa.build(pes).calcularDistancia(emp);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private void calcularPontosCardeais(Pessoa pes, DTOMobileClienteRec c, OpcoesMobile op, Empresa emp) {
        try {
            this.helperPessoa.build(pes).calcularPontosGeograficos(emp);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private Representante getRepresentanteByIdPessoa(ClienteFaturamento fat, Long idPessoaRepresentante, OpcoesMobile op) {
        Representante r = fat.getRepresentante();
        if (r == null) {
            r = this.serviceRepresentante.findByIdPessoa(idPessoaRepresentante);
        }
        if (r == null) {
            r = op.getRepresentantePadrao();
        }
        return r;
    }

    private void verificaClienteFinanceiro(Cliente cl, DTOMobileClienteRec c, OpcoesMobile op, Empresa emp) {
        ClienteFinanceiro fin = cl.getFinanceiro();
        if (fin == null) {
            fin = new ClienteFinanceiro();
            cl.setFinanceiro(fin);
            fin.setCliente(cl);
            fin.setDataLiberacaoCredito(new Date());
            fin.setHabilParaCompra(op.getHabilitarClientesCompras());
            fin.setLimiteCredito(op.getValorLimite());
            fin.setNaoAvaliarFinanceiro(op.getNaoAvaliarFinanceiro());
            fin.setDiasVigorLimiteCred(op.getDiasAvaliacaoLimiteFin());
        }
        fin.setCliente(cl);
        fin.setObservacao(this.checkAndCutText(c.getObservacao(), 500));
    }

    private void verificaUnidadeFatCliente(Cliente cl, DTOMobileClienteRec c, PackObjectsSinc pa) {
        if (cl.getUnidadeFatClientes() != null && cl.getUnidadeFatClientes().size() > 0) {
            return;
        }
        for (DTOMobileClienteRec.UnidadeFatClienteReceiveLocal aux : c.getUnidadeFatCliente()) {
            HelperCliente comp = (HelperCliente)ConfApplicationContext.getBean(HelperCliente.class);
            UnidadeFatCliente unid = comp.criarUnidadeFatPadrao(cl);
            unid.setCliente(cl);
            ArrayList<UnidadeFatCliente> ret = new ArrayList<UnidadeFatCliente>();
            ret.add(unid);
            cl.setUnidadeFatClientes(ret);
            PackObjectsSincChild child = new PackObjectsSincChild();
            child.setChave("unidade_fat_cliente");
            child.setIdObjectMentor(unid.getIdentificador());
            child.setIdObjectMobile(aux.getIdentificador());
            pa.getChildren().add(child);
        }
    }

    private void atualizaPessoa(Pessoa pessoa, DTOMobileClienteRec c) {
        if (pessoa.getEndereco() == null) {
            pessoa.setEndereco(new Endereco());
        }
        if (pessoa.getComplemento() == null) {
            pessoa.setComplemento(new Complemento());
            EmailPessoa e = new EmailPessoa();
            e.setAtivo(Short.valueOf((short)1));
            e.setDescricao(this.checkAndCutText(c.getEmail(), 300));
            e.setEmail(this.checkAndCutText(c.getEmail(), 300));
            e.setComplemento(pessoa.getComplemento());
            pessoa.getComplemento().getEmails().add(e);
        }
        this.normalizeEndereco(pessoa.getEndereco(), c);
        Complemento comp = pessoa.getComplemento();
        comp.setAtivo(pessoa.getAtivo());
        comp.setCel1(this.checkAndCutText(c.getCelular(), 14));
        comp.setCnpj(ToolString.refina((String)this.checkAndCutText(c.getCnpj(), 18)));
        comp.setEmailPrincipal(this.checkAndCutText(c.getEmail(), 300));
        comp.setFone1(ToolString.refina((String)this.checkAndCutText(c.getTelefone(), 14)));
        comp.setInscEst(ToolString.refina((String)this.checkAndCutText(c.getInscEstadual(), 18)));
        comp.setPessoa(pessoa);
        if (pessoa.getComplemento().getEmails() != null && pessoa.getComplemento().getEmails().size() == 1) {
            ((EmailPessoa)pessoa.getComplemento().getEmails().get(0)).setEmail(comp.getEmailPrincipal());
        }
    }

    private void normalizeEndereco(Endereco end, DTOMobileClienteRec c) {
        end.setBairro(this.checkAndCutText(c.getBairro(), 60));
        end.setCep(ToolString.refina((String)this.checkAndCutText(c.getCep(), 9)));
        end.setCidade(this.findCidade(c.getIdCidade()));
        end.setComplemento(this.checkAndCutText(c.getComplemento(), 60));
        end.setLogradouro(this.checkAndCutText(c.getEndereco(), 60));
        end.setNumero(this.checkAndCutText(c.getNumero(), 10));
    }

    private Cidade findCidade(Long idCidade) {
        return (Cidade)this.serviceCidade.get(idCidade);
    }

    private Pessoa getPessoa(String cnpj) {
        Pessoa pes = this.servicePessoa.getByCPFCNPJAtiva(cnpj);
        if (pes == null) {
            pes = this.servicePessoa.getByCPFCNPJInativa(cnpj);
        }
        return pes;
    }

    private Cliente getClienteCnpj(String cnpj) {
        return this.serviceCliente.getClienteCpfCpnj(cnpj);
    }

    private String checkAndCutText(String str, int size) {
        if (str == null) {
            return str;
        }
        if (str.length() > size) {
            return str.substring(0, size);
        }
        return str;
    }
}

