/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.cliente;

import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPagRec;
import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPessoaGrupoPessoa;
import com.touchcomp.basementor.model.impl.DadosEstatisticosFaturamento;
import com.touchcomp.basementor.model.impl.TempVOInfoProdCliente;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoClienteImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.chequeterceiros.ServiceChequeTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.clientefichafinanceira.ServiceClienteFichaFinanceiraImpl;
import com.touchcomp.basementorservice.service.impl.clientefinanceiro.ServiceClienteFinanceiroImpl;
import com.touchcomp.basementorservice.service.impl.condicoespagamento.ServiceCondicoesPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.saldotitulo.ServiceSaldoTituloImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatcliente.ServiceUnidadeFatClienteImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceCliente;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.cliente.web.DTOCliente;
import com.touchcomp.touchvomodel.vo.cliente.web.DTOEstatisticasCliente;
import com.touchcomp.touchvomodel.vo.cliente.web.DTOUnidadeFatCliente;
import com.touchcomp.touchvomodel.vo.condicoespagamento.web.DTOCondicoesPagamento;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceClienteImpl
extends ServiceGenericEntityImpl<Cliente, Long, DaoClienteImpl>
implements ServiceCliente {
    ServiceCondicoesPagamentoImpl serviceCondicoesPagamentoImpl;
    ServiceUnidadeFatClienteImpl serviceUnidadeFatCliente;
    ServiceClienteFichaFinanceiraImpl serviceFichaFinanceira;
    ServiceClienteFinanceiroImpl serviceClienteFinanceiro;
    ServiceSaldoTituloImpl serviceSaldoTitulo;
    ServiceChequeTerceirosImpl serviceChequeTerceiros;

    @Autowired
    public ServiceClienteImpl(DaoClienteImpl genericDao, ServiceCondicoesPagamentoImpl serviceCondicoesPagamentoImpl, ServiceUnidadeFatClienteImpl serviceUnidadeFatCliente, ServiceClienteFichaFinanceiraImpl serviceFichaFinanceira, ServiceClienteFinanceiroImpl serviceClienteFinanceiro, ServiceSaldoTituloImpl serviceSaldoTitulo, ServiceChequeTerceirosImpl serviceChequeTerceiros) {
        super(genericDao);
        this.serviceCondicoesPagamentoImpl = serviceCondicoesPagamentoImpl;
        this.serviceUnidadeFatCliente = serviceUnidadeFatCliente;
        this.serviceFichaFinanceira = serviceFichaFinanceira;
        this.serviceClienteFinanceiro = serviceClienteFinanceiro;
        this.serviceSaldoTitulo = serviceSaldoTitulo;
        this.serviceChequeTerceiros = serviceChequeTerceiros;
    }

    @Override
    public Cliente beforeSave(Cliente vo) {
        Cliente aux;
        if (this.isNull(vo.getIdentificador()).booleanValue() && this.isNotNull(vo.getPessoa()).booleanValue() && this.isNotNull(vo.getPessoa().getIdentificador()).booleanValue() && this.isNotNull(aux = this.findClienteByPessoa(vo.getPessoa())).booleanValue()) {
            throw new ExceptionRuntimeBase("E.ERP.0076.006");
        }
        this.serviceUnidadeFatCliente.beforeSave(vo.getUnidadeFatClientes());
        this.serviceFichaFinanceira.beforeSave(vo.getFichaFinanceira());
        this.serviceClienteFinanceiro.beforeSave(vo.getFinanceiro());
        if (ServiceClienteImpl.isWithData(vo.getUnidadeFatClientes())) {
            vo.getUnidadeFatClientes().forEach(i -> i.setCliente(vo));
        }
        if (ServiceClienteImpl.isWithData(vo.getGrupoClientes())) {
            vo.getGrupoClientes().forEach(i -> i.setCliente(vo));
        }
        if (ServiceClienteImpl.isWithData(vo.getClienteNFCe())) {
            vo.getClienteNFCe().forEach(i -> i.setCliente(vo));
        }
        if (ServiceClienteImpl.isWithData(vo.getVeiculos())) {
            vo.getVeiculos().forEach(i -> i.setCliente(vo));
        }
        if (ServiceClienteImpl.isWithData(vo.getClienteNFCeMeioPagamento())) {
            vo.getClienteNFCeMeioPagamento().forEach(i -> i.setCliente(vo));
        }
        vo.setDataUltModificacao(new Date());
        return vo;
    }

    public List<Cliente> get(Pessoa pessoa, Short ativo) {
        return ((DaoClienteImpl)this.getGenericDao()).get(pessoa, ativo);
    }

    @Override
    public PlanoConta getPlanoContaClienteIdPessoa(Long idPessoa) {
        return ((DaoClienteImpl)this.getGenericDao()).getPlanoContaClienteIdPessoa(idPessoa);
    }

    @Override
    public Cliente findClienteByPessoa(Pessoa pessoa) {
        return ((DaoClienteImpl)this.getGenericDao()).findClienteByPessoa(pessoa);
    }

    public List<Cliente> findClienteByPessoa(Pessoa ... pessoa) {
        return ((DaoClienteImpl)this.getGenericDao()).findClienteByPessoa(pessoa);
    }

    public List<Cliente> findClienteByPessoa(Long ... idPessoa) {
        return ((DaoClienteImpl)this.getGenericDao()).findClienteByPessoa(idPessoa);
    }

    public Cliente findClienteByPessoa(Long idPessoa) {
        return ((DaoClienteImpl)this.getGenericDao()).findClienteByPessoa(idPessoa);
    }

    @Override
    public DadosEstatisticosFaturamento getPrimeiroFaturamentoNf(Cliente cliente) {
        return ((DaoClienteImpl)this.getGenericDao()).getPrimeiroFaturamentoNf(cliente);
    }

    @Override
    public DadosEstatisticosFaturamento getUltimoFaturamentoNf(Cliente cliente) {
        return ((DaoClienteImpl)this.getGenericDao()).getUltimoFaturamentoNf(cliente);
    }

    @Override
    public DadosEstatisticosFaturamento getMaiorFaturamentoNf(Cliente cliente) {
        return ((DaoClienteImpl)this.getGenericDao()).getMaiorFaturamentoNf(cliente);
    }

    @Override
    public List<TempVOInfoProdCliente> getProdutosNuncaCompradosCliente(Long idCliente, Long idEmpresa, Long idEspecie, Long idSubEspecie, Integer nrMaxRegistros) {
        return ((DaoClienteImpl)this.getGenericDao()).getProdutosNuncaCompradosCliente(idCliente, idEmpresa, idEspecie, idSubEspecie, nrMaxRegistros);
    }

    @Override
    public List<TempVOInfoProdCliente> getProdutosSemGiroCliente(Long idCliente, Long idEmpresa, Long idEspecie, Long idSubEspecie, Integer dias, Integer nrMaxRegistros) {
        return ((DaoClienteImpl)this.getGenericDao()).getProdutosSemGiroCliente(idCliente, idEmpresa, idEspecie, idSubEspecie, dias, nrMaxRegistros);
    }

    @Override
    public Cliente getClienteCpfCpnj(String cnpj) {
        return ((DaoClienteImpl)this.getGenericDao()).getClienteCpfCpnj(cnpj);
    }

    public Cliente getClienteCpfCpnjAtivo(String cnpj) {
        return ((DaoClienteImpl)this.getGenericDao()).getClienteCpfCpnjAtivo(cnpj);
    }

    public Double analiseFinanceiraCliente(Cliente cliente) {
        Double saldoDev = this.getSaldoDevedor(cliente.getPessoa().getIdentificador(), EnumConstSaldoTitPessoaGrupoPessoa.TIPO_PESSOA);
        Double chequesDev = this.getSaldoChequesDevolvidos(cliente.getPessoa());
        Double chequesNaoComp = this.getSaldoDevedorChequesNaoComp(cliente.getPessoa());
        Double limiteDisp = cliente.getFinanceiro().getLimiteCredito() - saldoDev - chequesDev - chequesNaoComp;
        return limiteDisp;
    }

    private Double getSaldoDevedor(Long id, EnumConstSaldoTitPessoaGrupoPessoa tipo) {
        ServiceSaldoTituloImpl serviceSaldoTitulo = (ServiceSaldoTituloImpl)ConfApplicationContext.getBean(ServiceSaldoTituloImpl.class);
        return serviceSaldoTitulo.getSaldoDevedorPessoa(id, EnumConstSaldoTitPagRec.TIPO_TITULO_REC, tipo, new Date());
    }

    private Double getSaldoChequesDevolvidos(Pessoa pessoa) {
        ServiceChequeTerceirosImpl serviceChequeTerceiros = (ServiceChequeTerceirosImpl)ConfApplicationContext.getBean(ServiceChequeTerceirosImpl.class);
        return serviceChequeTerceiros.valorChequesDevolvidos(pessoa.getIdentificador());
    }

    private Double getSaldoDevedorChequesNaoComp(Pessoa pessoa) {
        ServiceChequeTerceirosImpl serviceChequeTerceiros = (ServiceChequeTerceirosImpl)ConfApplicationContext.getBean(ServiceChequeTerceirosImpl.class);
        return serviceChequeTerceiros.valorChequesNaoCompensados(pessoa.getIdentificador());
    }

    @Override
    public Cliente findClienteByCodCliente(String codCliente) {
        return ((DaoClienteImpl)this.getGenericDao()).findClienteByCodCliente(codCliente);
    }

    public List<DTOCliente.DTOClienteFinanceiroSocioAutorizado> getSociosAutorizados(Long idCliente) {
        Cliente c = (Cliente)((DaoClienteImpl)this.getDao()).get(idCliente);
        if (c == null) {
            return new ArrayList<DTOCliente.DTOClienteFinanceiroSocioAutorizado>();
        }
        return this.buildToDTOGeneric(c.getFichaFinanceira().getSociosAutorizadas(), DTOCliente.DTOClienteFinanceiroSocioAutorizado.class);
    }

    public List<DTOCliente.DTOClienteFichaFinanceiraAutorizados> getPessoasAutorizadas(Long idCliente) {
        Cliente c = (Cliente)((DaoClienteImpl)this.getDao()).get(idCliente);
        if (c == null) {
            return new ArrayList<DTOCliente.DTOClienteFichaFinanceiraAutorizados>();
        }
        return this.buildToDTOGeneric(c.getFichaFinanceira().getPessoasAutorizadas(), DTOCliente.DTOClienteFichaFinanceiraAutorizados.class);
    }

    public List<DTOUnidadeFatCliente> getUnidadesFatCliente(Long idCliente, Class<DTOUnidadeFatCliente> aClass) throws ExceptionObjNotFound {
        Cliente c = (Cliente)this.getOrThrow(idCliente);
        if (c == null) {
            return new ArrayList<DTOUnidadeFatCliente>();
        }
        return this.buildToDTOGeneric(c.getUnidadeFatClientes(), DTOUnidadeFatCliente.class);
    }

    public List<DTOCondicoesPagamento> getCondicoesPagamentoLiberadas(Long idCliente) throws ExceptionObjNotFound {
        Cliente c = (Cliente)this.getOrThrow(idCliente);
        if (!TMethods.isWithData((Collection)c.getClienteNFCeMeioPagamento())) {
            return this.serviceCondicoesPagamentoImpl.getCondicoesPagamentoSaidaDTO();
        }
        return this.serviceCondicoesPagamentoImpl.buildToDTO(((DaoClienteImpl)this.getDao()).getCondicoesPagamentoConfCliente(c), DTOCondicoesPagamento.class);
    }

    public Transportador getTransportadorCliente(Long identificador) throws ExceptionObjNotFound {
        Cliente vo = (Cliente)this.getOrThrow(identificador);
        if (vo.getFaturamento() != null && vo.getFaturamento().getTransportadora() != null) {
            return vo.getFaturamento().getTransportadora();
        }
        return null;
    }

    public TipoFrete getTipoFreteCliente(Long identificador) throws ExceptionObjNotFound {
        Cliente vo = (Cliente)this.get(identificador);
        if (vo != null && vo.getFaturamento() != null && vo.getFaturamento().getTransportadora() != null) {
            return vo.getFaturamento().getTipoFrete();
        }
        return null;
    }

    public List<Cliente> findClientesByRamoAtvComComprasNaDataLim(Short filtrarRamoAtividade, Long ramoAtividadeInicial, Long ramoAtividadeFinal, Date dataLimite) {
        return ((DaoClienteImpl)this.getDao()).findClientesByRamoAtvComComprasNaDataLim(filtrarRamoAtividade, ramoAtividadeInicial, ramoAtividadeFinal, dataLimite);
    }

    public List<String> getCnpjClientesAtivos() {
        return ((DaoClienteImpl)this.getDao()).getCnpjClientesAtivos();
    }

    public DTOEstatisticasCliente consultarDadosFinanceirosCliente(Long identificador, OpcoesFinanceiras opcoesFinanceiras) throws ExceptionObjNotFound {
        Cliente cliente = (Cliente)this.getOrThrow(identificador);
        DTOEstatisticasCliente dto = new DTOEstatisticasCliente();
        dto.setHabilParaCompra(cliente.getFinanceiro().getHabilParaCompra());
        dto.setLimiteCredito(cliente.getFinanceiro().getLimiteCreditoFinanceiro());
        dto.setLimiteCredito(cliente.getFinanceiro().getLimiteCreditoFinanceiro());
        dto.setTotalCompras(this.serviceSaldoTitulo.getSaldoDevedorPessoa(cliente.getPessoa().getIdentificador(), EnumConstSaldoTitPagRec.TIPO_TITULO_REC, EnumConstSaldoTitPessoaGrupoPessoa.TIPO_PESSOA, new Date()));
        if (this.isAffimative(opcoesFinanceiras.getIncluirChequeAnCred())) {
            dto.setChequesNaoCompensados(this.serviceChequeTerceiros.valorChequesNaoCompensados(cliente.getPessoa().getIdentificador()));
            dto.setChequesDevolvidos(this.serviceChequeTerceiros.valorChequesDevolvidos(cliente.getPessoa().getIdentificador()));
        }
        dto.setTotalCompras(dto.getTotalCompras());
        if (this.isNotNull(dto.getChequesNaoCompensados()).booleanValue()) {
            dto.setTotalCompras(Double.valueOf(dto.getTotalCompras() + dto.getChequesNaoCompensados()));
        }
        if (this.isNotNull(dto.getChequesDevolvidos()).booleanValue()) {
            dto.setTotalCompras(Double.valueOf(dto.getTotalCompras() + dto.getChequesDevolvidos()));
        }
        dto.setLimiteDisponivel(Double.valueOf(cliente.getFinanceiro().getLimiteCreditoFinanceiro() - dto.getTotalCompras()));
        dto.setPessoasAutorizadas(this.buildToDTOGeneric(cliente.getFichaFinanceira().getPessoasAutorizadas(), DTOCliente.DTOClienteFichaFinanceiraAutorizados.class));
        dto.setTiposPagamento(this.buildToDTOGeneric(cliente.getClienteNFCeMeioPagamento(), DTOCliente.DTOClienteNFCeMeioPagamento.class));
        dto.setUnidadesFatCliente(this.buildToDTOGeneric(cliente.getUnidadeFatClientes(), DTOUnidadeFatCliente.class));
        return dto;
    }
}

