/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.clientecontsistemas;

import com.touchcomp.basementor.model.vo.ClienteContSistemas;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.ServidorCliente;
import com.touchcomp.basementor.model.vo.UsuarioBasico;
import com.touchcomp.basementor.model.vo.UsuarioClienteContSistemas;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoClienteContSistemasImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceClienteContSistemas;
import com.touchcomp.touchvomodel.res.DTOEntidadeCodigoRes;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceClienteContSistemasImpl
extends ServiceGenericEntityImpl<ClienteContSistemas, Long, DaoClienteContSistemasImpl>
implements ServiceClienteContSistemas {
    @Autowired
    public ServiceClienteContSistemasImpl(DaoClienteContSistemasImpl genericDao) {
        super(genericDao);
    }

    @Override
    public ClienteContSistemas findCliente(String cnpjEmp) {
        return ((DaoClienteContSistemasImpl)this.getGenericDao()).findCliente(cnpjEmp);
    }

    @Override
    public ClienteContSistemas findClienteEmpCNPJFiliais(String cnpjEmp) {
        return ((DaoClienteContSistemasImpl)this.getGenericDao()).findClienteEmpCNPJFiliais(cnpjEmp);
    }

    public ServidorCliente getServidorCliente(String cnpj, Integer tipoAplicacao) {
        return ((DaoClienteContSistemasImpl)this.getDao()).getServidorCliente(cnpj, tipoAplicacao);
    }

    public ServidorCliente getServidorCliente(String cnpj, String macAdress, Integer tipoAplicacao) {
        return ((DaoClienteContSistemasImpl)this.getDao()).getServidorCliente(cnpj, macAdress, tipoAplicacao);
    }

    public void resetarLogConsulta(Date data, UsuarioClienteContSistemas u) {
        ((DaoClienteContSistemasImpl)this.getDao()).resetarLogConsulta(data, u);
    }

    public boolean isUsuarioTreinado(UsuarioClienteContSistemas user, Nodo n) {
        return ((DaoClienteContSistemasImpl)this.getDao()).isUsuarioTreinado(user, n);
    }

    public List<DTOEntidadeCodigoRes> getPerfisAcesso(UsuarioBasico loggedUsuarioBasico) {
        return ((DaoClienteContSistemasImpl)this.getDao()).getPerfisClientesAcessoUsuario(loggedUsuarioBasico);
    }

    public ClienteContSistemas getByCodigoClienteOrThrow(String codigoCliente) throws ExceptionObjNotFound {
        ClienteContSistemas cl = ((DaoClienteContSistemasImpl)this.getDao()).getByCodigoCliente(codigoCliente);
        this.throwIfNull(cl, (Serializable)((Object)codigoCliente));
        return cl;
    }
}

