/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.codigobarras;

import com.touchcomp.basementor.constants.enums.codigobarras.EnumConstCodigoBarras;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.codigobarras.CompCodigoBarras;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.codigobarras.ServiceCodigoBarrasImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.ordemservicoprodlinhaprod.ServiceSubdivisaoOSProdLinhaProdImpl;
import com.touchcomp.basementorservice.service.impl.ordemservicoprodsobenc.ServiceSubdivisaoOSProdSobEncImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementortools.tools.string.ToolString;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceCodigoBarrasGenericImpl
extends ServiceGenericImpl {
    @Autowired
    private ServiceCodigoBarrasImpl serviceCodigoBarrasImpl;
    @Autowired
    private ServiceGradeCorImpl serviceGradeCorImpl;
    @Autowired
    private ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl;
    @Autowired
    private ServiceProdutoImpl serviceProdutoImpl;
    @Autowired
    private ServiceSubdivisaoOSProdLinhaProdImpl serviceSubOSLinha;
    @Autowired
    private ServiceSubdivisaoOSProdSobEncImpl serviceSubOSEnc;

    public Object getEntityByCodBarras(String codBarras, ServiceGenericEntityImpl serviceEntity) throws ExceptionInvalidData {
        EnumConstCodigoBarras type = new CompCodigoBarras().identificaTipoCodBarras(codBarras);
        return this.getEntityInternal(codBarras, type, serviceEntity, null);
    }

    public Object getEntityByCodBarras(String codBarras, ServiceGenericEntityImpl serviceEntity, Empresa empresa, EnumConstCodigoBarras ... types) throws ExceptionInvalidData {
        EnumConstCodigoBarras type = new CompCodigoBarras().identificaTipoCodBarras(codBarras, types);
        return this.getEntityInternal(codBarras, type, serviceEntity, empresa);
    }

    private Object getEntityInternal(String codBarras, EnumConstCodigoBarras type, ServiceGenericEntityImpl serviceEntity, Empresa empresa) throws ExceptionInvalidData {
        switch (type) {
            case CODIGO_BARRAS_EAN: {
                return this.serviceCodigoBarrasImpl.getByCodigo(codBarras);
            }
            case CODIGO_BARRAS_GRADE: {
                String idGradeCor = new CompCodigoBarras().findCodigoBarras(type, codBarras);
                return this.serviceGradeCorImpl.get(Long.valueOf(idGradeCor));
            }
            case CODIGO_BARRAS_ID_ENTIDADE: {
                return serviceEntity.get(Long.valueOf(ToolString.onlyNumbers((String)codBarras)));
            }
            case CODIGO_BARRAS_LOTE_FABRICACAO: {
                String idLoteFabricacao = new CompCodigoBarras().findCodigoBarras(type, codBarras);
                return this.serviceLoteFabricacaoImpl.get(Long.valueOf(idLoteFabricacao));
            }
            case CODIGO_BARRAS_PRODUTO: {
                String idProduto = new CompCodigoBarras().findCodigoBarras(type, codBarras);
                return this.serviceProdutoImpl.get(Long.valueOf(idProduto));
            }
            case CODIGO_BARRAS_OS_LINHA_PROD: {
                return this.serviceSubOSLinha.getByCodigoBarras(codBarras);
            }
            case CODIGO_BARRAS_OS_SOB_ENC: {
                return this.serviceSubOSEnc.getByCodigoBarras(codBarras);
            }
        }
        throw new ExceptionInvalidData("01-02-00733", new Object[]{type});
    }
}

