/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.colaborador;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoOcorrenciaEvtColaborador;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstESocialStatus;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.SituacaoColaborador;
import com.touchcomp.basementor.model.vo.TabelaINSS;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.situacaocolaborador.ServiceSituacaoColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.tabelainss.ServiceTabelaINSSImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.touchvomodel.vo.eventocolaborador.web.DTOEventoColaborador;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class SCompColaborador
extends ServiceGenericImpl {
    ServiceTabelaINSSImpl serviceTabelaINSSImpl;
    ServiceSituacaoColaboradorImpl serviceSituacaoColaboradorImpl;

    public boolean semAlteracaoCadastralAberta(Colaborador vo) {
        for (EsocPreEvento esocPreEvento : vo.getPreEventosEsocial()) {
            if (!this.isEquals(esocPreEvento.getTipoEventoEsocial().getIdentificador(), ConstantsESocial.REGISTRO_2206) || !this.isEquals(esocPreEvento.getEventoProdRestritaProducao(), EnumConstEventoProducao.EVENTO_PRODUCAO.getEnumId()) || !this.isNull(esocPreEvento.getEventoPosterior()).booleanValue()) continue;
            return this.isNotNull(esocPreEvento.getEsocEvento()) != false && this.isEquals(esocPreEvento.getEsocEvento().getStatus(), EnumConstESocialStatus.STATUS_SUCESSO.getEnumId());
        }
        return true;
    }

    public void validarContratoVerdeAmarelo(Colaborador vo, Double valorSalario, Date dataUltimaDemissao) {
        if (!this.isEquals(vo.getEsocCategoriaTrabalhador().getCodigo(), "108") && !this.isEquals(vo.getEsocCategoriaTrabalhador().getCodigo(), "107")) {
            return;
        }
        Double valorSalarioMinimo = this.getSalarioMinimoAnual(vo.getDataAdmissao(), vo.getDataAdmissao());
        this.validarDadosContratoVerdeAmarelo(vo, valorSalario, valorSalarioMinimo, dataUltimaDemissao);
    }

    private Double getSalarioMinimoAnual(Date dataInicial, Date dataFinal) {
        TabelaINSS tabelaInss = this.serviceTabelaINSSImpl.getTabelaInssPorDataInicialFinal(dataInicial, dataFinal);
        if (this.isNull(tabelaInss).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0516.005"));
        }
        return tabelaInss.getVrSalarioMinimo();
    }

    private void validarDadosContratoVerdeAmarelo(Colaborador vo, Double valorSalario, Double valorSalarioMinimo, Date dataUltimaDemissao) {
        this.validarSalarioVerdeAmarelo(valorSalario, valorSalarioMinimo);
        this.validarIdade(vo);
        this.validarContratacaoJaExistente(vo, dataUltimaDemissao);
        this.validarDatasContrato(vo);
    }

    private void validarSalarioVerdeAmarelo(Double valorSalario, Double valorSalarioMinimo) {
        Double salarioPermitido = ToolNumber.arredondarNumero((Double)(valorSalarioMinimo * 1.5), (Integer)2, (Integer)0);
        if (valorSalario > salarioPermitido) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0516.006"));
        }
    }

    private void validarIdade(Colaborador vo) {
        Date dataAdmissao = vo.getDataAdmissao();
        Date dataNascimento = vo.getPessoa().getComplemento().getDataNascimento();
        if (this.isNull(dataNascimento).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0516.007"));
        }
        if (dataAdmissao.before(dataNascimento)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0516.008"));
        }
        Long dataAtual = dataAdmissao.getTime() / 1000L;
        Long dataNiver = dataNascimento.getTime() / 1000L;
        Long total = dataAtual - dataNiver;
        Long idade = total / 365L / 24L / 60L / 60L;
        if (idade < 18L || idade > 29L) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0516.009"));
        }
    }

    private void validarContratacaoJaExistente(Colaborador vo, Date dataUltimaDemissao) {
        Integer difDias;
        if (this.isNotNull(dataUltimaDemissao).booleanValue() && (difDias = Integer.valueOf(ToolDate.diferenceDayBetweenDatesExclusive((Date)dataUltimaDemissao, (Date)vo.getDataAdmissao()) + 1)) < 180) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0516.010"));
        }
    }

    private void validarDatasContrato(Colaborador vo) {
        if (this.isNull(vo.getPrimeiraDataExperiencia()).booleanValue() && this.isNull(vo.getSegundaDataExperiencia()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0516.011"));
        }
    }

    public void verificarSituacaoColaborador(Colaborador vo) {
        if (this.isNull(vo.getDataDemissao() == null && this.isEquals(vo.getAtivo(), EnumConstantsMentorSimNao.SIM.getValue())).booleanValue()) {
            vo.setSituacaoColaborador(this.getSituacaoColaborador(1L));
        } else if (this.isNull(vo.getDataDemissao()).booleanValue() && this.isEquals(vo.getAtivo(), EnumConstantsMentorSimNao.NAO.getValue())) {
            vo.setSituacaoColaborador(this.getSituacaoColaborador(2L));
        } else if (this.isNotNull(vo.getDataDemissao()).booleanValue()) {
            vo.setSituacaoColaborador(this.getSituacaoColaborador(3L));
        }
    }

    private SituacaoColaborador getSituacaoColaborador(Long idSituacaoColaborador) {
        return (SituacaoColaborador)this.serviceSituacaoColaboradorImpl.get(idSituacaoColaborador);
    }

    public void definirTipoEventoColaborador(List<DTOEventoColaborador> eventos) {
        if (SCompColaborador.isWithData(eventos)) {
            for (DTOEventoColaborador vo : eventos) {
                this.definirTipoEventoColaborador(vo);
            }
        }
    }

    public void definirTipoEventoColaborador(DTOEventoColaborador vo) {
        if ((this.isEquals(vo.getTipoOcorrencia(), EnumConstTipoOcorrenciaEvtColaborador.TP_OCORRENCIA_SEMPRE_CALCULAR_EVENTO.getEnumId()) || this.isEquals(vo.getTipoOcorrencia(), EnumConstTipoOcorrenciaEvtColaborador.TP_OCORRENCIA_ANUALMENTE_PERIODO.getEnumId()) && this.isNull(vo.getDataInicial()).booleanValue() && this.isNull(vo.getDataFinal()).booleanValue() || this.validarEventoMensal(vo)) && this.isAffimative(vo.getAtivo())) {
            vo.setTipoDeEvento("Evento Folha");
        } else {
            vo.setTipoDeEvento("Outros Eventos");
        }
    }

    private boolean validarEventoMensal(DTOEventoColaborador vo) {
        if (this.isEquals(vo.getTipoOcorrencia(), EnumConstTipoOcorrenciaEvtColaborador.TP_OCORRENCIA_ESPECIFICAMENTE_PERIODO.getEnumId())) {
            if (vo.getDataInicial() != null && vo.getDataFinal() != null) {
                Integer mesInicial = ToolDate.monthFromDate((Date)vo.getDataInicial());
                Integer mesFinal = ToolDate.monthFromDate((Date)vo.getDataFinal());
                Integer anoInicial = ToolDate.yearFromDate((Object)vo.getDataInicial());
                Integer anoFinal = ToolDate.yearFromDate((Object)vo.getDataFinal());
                Integer anoAtual = ToolDate.yearFromDate((Object)new Date());
                Integer mesAtual = ToolDate.monthFromDate((Date)new Date());
                if (this.isEquals(mesInicial, mesFinal) && this.isEquals(anoInicial, anoFinal) && anoInicial <= anoAtual && mesInicial <= mesAtual) {
                    return false;
                }
            }
            if (this.isNotNull(vo.getDataInicial()).booleanValue() && (this.isNull(vo.getDataFinal()).booleanValue() || this.isNotNull(vo.getDataFinal()).booleanValue() && vo.getDataFinal().after(new Date()))) {
                return true;
            }
        }
        return false;
    }

    @Generated
    public SCompColaborador(ServiceTabelaINSSImpl serviceTabelaINSSImpl, ServiceSituacaoColaboradorImpl serviceSituacaoColaboradorImpl) {
        this.serviceTabelaINSSImpl = serviceTabelaINSSImpl;
        this.serviceSituacaoColaboradorImpl = serviceSituacaoColaboradorImpl;
    }
}

