/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.colaborador;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoOcorrenciaEvtColaborador;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstTipoEventoESocial;
import com.touchcomp.basementor.helper.impl.colaborador.HelperColaborador;
import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.AtualizacaoSalarial;
import com.touchcomp.basementor.model.vo.CadastroBeneficioRefeicaoCesta;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorSalario;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocTreinamentoColaborador;
import com.touchcomp.basementor.model.vo.EventoColaborador;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.ParametrizacaoEventosAdmissao;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PreCadastroColaborador;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.TipoEventoEsocial;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorbinary.model.ArqFotoColaborador;
import com.touchcomp.basementorbinary.service.impl.arqfotocolaborador.ServiceBinaryArqFotoColaborador;
import com.touchcomp.basementorclientwebservices.ponto.model.funcionario.DTOPontoFuncionario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoColaboradorImpl;
import com.touchcomp.basementorservice.helpers.impl.esocpreevento.HelperEsocPreEvento;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.afastamentocolaborador.ServiceAfastamentoColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.cadastrobeneficiorefeicaocesta.ServiceCadastroBeneficioRefeicaoCestaImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.SCompColaborador;
import com.touchcomp.basementorservice.service.impl.colaboradorsalario.ServiceColaboradorSalarioImpl;
import com.touchcomp.basementorservice.service.impl.empresarh.ServiceEmpresaRhImpl;
import com.touchcomp.basementorservice.service.impl.esoctreinamento.ServiceEsocTreinamentoImpl;
import com.touchcomp.basementorservice.service.impl.exclusaoeventosesocial.ServiceExclusaoEventosEsocialImpl;
import com.touchcomp.basementorservice.service.impl.itemsaneamentodadoscolaborador.ServiceItemSaneamentoDadosColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaoeventosadmissao.ServiceParametrizacaoEventosAdmissaoImpl;
import com.touchcomp.basementorservice.service.impl.precadastrocolaborador.ServicePreCadastroColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.recisao.ServiceRecisaoImpl;
import com.touchcomp.basementorservice.service.impl.tipocalculoevento.ServiceTipoCalculoEventoImpl;
import com.touchcomp.basementortools.constants.EnumConstantsSimNao;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.image.ToolImage;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.touchvomodel.vo.colaborador.web.DTOColaborador;
import com.touchcomp.touchvomodel.vo.colaborador.web.DTOColaboradorRes;
import com.touchcomp.touchvomodel.vo.colaboradorsalario.web.DTOColaboradorSalario;
import com.touchcomp.touchvomodel.vo.esoctreinamentocolaborador.web.DTOEsocTreinamentoColaborador;
import com.touchcomp.touchvomodel.vo.eventocolaborador.web.DTOEventoColaborador;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ServiceColaboradorImpl
extends ServiceGenericEntityImpl<Colaborador, Long, DaoColaboradorImpl> {
    final HelperEsocPreEvento helperEsocPreEvento;
    final SCompColaborador sCompColaborador;
    final ServiceBinaryArqFotoColaborador serviceBinaryArqFotoColaborador;
    final ServicePreCadastroColaboradorImpl servicePreCadastroColaboradorImpl;
    final ServiceTipoCalculoEventoImpl serviceTipoCalculoEventoImpl;
    final ServiceEsocTreinamentoImpl serviceEsocTreinamentoImpl;
    final ServiceParametrizacaoEventosAdmissaoImpl serviceParametrizacaoEventosAdmissaoImpl;
    final ServiceColaboradorSalarioImpl serviceColaboradorSalarioImpl;
    final ServiceAfastamentoColaboradorImpl serviceAfastamentoColaboradorImpl;
    final ServiceEmpresaRhImpl serviceEmpresaRhImpl;
    final ServiceCadastroBeneficioRefeicaoCestaImpl serviceCadastroBeneficioRefeicaoCestaImpl;
    final ServiceItemSaneamentoDadosColaboradorImpl serviceItemSaneamentoDadosColaboradorImpl;
    final ServiceRecisaoImpl serviceRescisao;

    @Autowired
    public ServiceColaboradorImpl(DaoColaboradorImpl dao, HelperEsocPreEvento helperEsocPreEvento, SCompColaborador sCompColaborador, ServiceBinaryArqFotoColaborador serviceBinaryArqFotoColaborador, ServicePreCadastroColaboradorImpl servicePreCadastroColaboradorImpl, ServiceTipoCalculoEventoImpl serviceTipoCalculoEventoImpl, ServiceEsocTreinamentoImpl serviceEsocTreinamentoImpl, ServiceParametrizacaoEventosAdmissaoImpl serviceParametrizacaoEventosAdmissaoImpl, ServiceColaboradorSalarioImpl serviceColaboradorSalarioImpl, ServiceEmpresaRhImpl serviceEmpresaRhImpl, ServiceCadastroBeneficioRefeicaoCestaImpl serviceCadastroBeneficioRefeicaoCestaImpl, ServiceItemSaneamentoDadosColaboradorImpl serviceItemSaneamentoDadosColaboradorImpl, ServiceAfastamentoColaboradorImpl serviceAfastamentoColaboradorImpl, ServiceRecisaoImpl serviceRescisao) {
        super(dao);
        this.helperEsocPreEvento = helperEsocPreEvento;
        this.sCompColaborador = sCompColaborador;
        this.serviceBinaryArqFotoColaborador = serviceBinaryArqFotoColaborador;
        this.servicePreCadastroColaboradorImpl = servicePreCadastroColaboradorImpl;
        this.serviceTipoCalculoEventoImpl = serviceTipoCalculoEventoImpl;
        this.serviceEsocTreinamentoImpl = serviceEsocTreinamentoImpl;
        this.serviceParametrizacaoEventosAdmissaoImpl = serviceParametrizacaoEventosAdmissaoImpl;
        this.serviceColaboradorSalarioImpl = serviceColaboradorSalarioImpl;
        this.serviceEmpresaRhImpl = serviceEmpresaRhImpl;
        this.serviceCadastroBeneficioRefeicaoCestaImpl = serviceCadastroBeneficioRefeicaoCestaImpl;
        this.serviceItemSaneamentoDadosColaboradorImpl = serviceItemSaneamentoDadosColaboradorImpl;
        this.serviceAfastamentoColaboradorImpl = serviceAfastamentoColaboradorImpl;
        this.serviceRescisao = serviceRescisao;
    }

    @Override
    public Colaborador beforeSaveEntity(Colaborador vo) {
        EmpresaRh empresaRh;
        if (this.isNotNull(vo.getHorasMesColaborador()).booleanValue()) {
            vo.setHorasMesColaborador(ToolNumber.arredondarNumero((Double)(vo.getHorasTrabDia() * vo.getDiasJornada()), (Integer)2, (Integer)0));
        }
        if (!this.isNotNull(empresaRh = this.getSharedData().getEmpresaRh(vo.getEmpresa())).booleanValue() || !this.isEquals(empresaRh.getAutomatizarAlteracaoCadastral(), EnumConstantsMentorSimNao.SIM.getValue()) || this.sCompColaborador.semAlteracaoCadastralAberta(vo)) {
            // empty if block
        }
        List<DTOColaboradorSalario> colaboradorSalario = this.serviceColaboradorSalarioImpl.getColaboradorSalarioPorColaborador(vo.getIdentificador());
        if (this.isNull(vo.getIdentificador()).booleanValue() || !ServiceColaboradorImpl.isWithData(colaboradorSalario)) {
            Date dataUltimaDemissao = this.getUltimaDataDemissaoPorPessoaEmpresa(vo.getEmpresa().getIdentificador(), vo.getPessoa().getIdentificador());
            this.sCompColaborador.validarContratoVerdeAmarelo(vo, vo.getValorSalario(), dataUltimaDemissao);
        }
        this.sCompColaborador.verificarSituacaoColaborador(vo);
        if (ServiceColaboradorImpl.isWithData(vo.getEventos())) {
            vo.getEventos().forEach(i -> i.setColaborador(vo));
        }
        if (ServiceColaboradorImpl.isWithData(vo.getRecisoes())) {
            vo.getRecisoes().forEach(i -> this.serviceRescisao.beforeSaveEntity((Recisao)i));
        }
        if (ServiceColaboradorImpl.isWithData(vo.getAfastamentos())) {
            for (AfastamentoColaborador afastamento : vo.getAfastamentos()) {
                afastamento.setColaborador(vo);
                if (ServiceColaboradorImpl.isWithData(afastamento.getMediaAfastamento())) {
                    afastamento.getMediaAfastamento().forEach(i -> i.setAfastamentoColaborador(afastamento));
                }
                if (!ServiceColaboradorImpl.isWithData(afastamento.getPreEventosEsocial())) continue;
                afastamento.getPreEventosEsocial().forEach(i -> i.setAfastamentoColaborador(afastamento));
            }
        }
        if (ServiceColaboradorImpl.isWithData(vo.getTipoParentescoColaborador())) {
            vo.getTipoParentescoColaborador().forEach(i -> i.setColaborador(vo));
        }
        if (ServiceColaboradorImpl.isWithData(vo.getPreEventosEsocial())) {
            vo.getPreEventosEsocial().forEach(i -> i.setColaborador(vo));
        }
        if (ServiceColaboradorImpl.isWithData(vo.getHistoricoHorario())) {
            vo.getHistoricoHorario().forEach(i -> i.setColaborador(vo));
        }
        if (ServiceColaboradorImpl.isWithData(vo.getMultiplosVinculos())) {
            vo.getMultiplosVinculos().forEach(i -> i.setColaborador(vo));
        }
        if (ServiceColaboradorImpl.isWithData(vo.getHistoricoLotacaoTributaria())) {
            vo.getHistoricoLotacaoTributaria().forEach(i -> i.setColaborador(vo));
        }
        if (ServiceColaboradorImpl.isWithData(vo.getHorasExtras())) {
            vo.getHorasExtras().forEach(i -> i.setColaborador(vo));
        }
        if (ServiceColaboradorImpl.isWithData(vo.getTreinamentos())) {
            vo.getTreinamentos().forEach(i -> i.setColaborador(vo));
        }
        if (ServiceColaboradorImpl.isWithData(vo.getDependentesColaborador())) {
            vo.getDependentesColaborador().forEach(i -> i.setColaborador(vo));
        }
        return vo;
    }

    @Override
    public Colaborador afterSaveEntity(Colaborador vo) {
        List<DTOColaboradorSalario> colaboradorSalario = this.serviceColaboradorSalarioImpl.getColaboradorSalarioPorColaborador(vo.getIdentificador());
        if (this.isNull(vo.getIdentificador()).booleanValue() || !ServiceColaboradorImpl.isWithData(colaboradorSalario)) {
            this.serviceColaboradorSalarioImpl.createColaboradorSalario(vo, vo.getValorSalario());
            this.serviceCadastroBeneficioRefeicaoCestaImpl.createCadastroBeneficioRefeicaoCesta(vo);
        } else {
            List<CadastroBeneficioRefeicaoCesta> cadastroBeneficioRefeicaoCesta = this.serviceCadastroBeneficioRefeicaoCestaImpl.getBeneficioRefeicaoCestaPorColaborador(vo.getIdentificador());
            if (!ServiceColaboradorImpl.isWithData(cadastroBeneficioRefeicaoCesta)) {
                this.serviceCadastroBeneficioRefeicaoCestaImpl.createCadastroBeneficioRefeicaoCesta(vo);
            }
        }
        return vo;
    }

    @Override
    public Colaborador beforeDeleteEntity(Colaborador vo) {
        this.serviceItemSaneamentoDadosColaboradorImpl.deleteItemSaneamentoDadosColaboradorPorColaborador(vo.getIdentificador());
        ServiceExclusaoEventosEsocialImpl serviceExclusaoEventosEsocialImpl = this.getBean(ServiceExclusaoEventosEsocialImpl.class);
        serviceExclusaoEventosEsocialImpl.desvincularColaboradorDaExclusaoEventosEsocial(vo.getIdentificador());
        this.serviceColaboradorSalarioImpl.deleteColaboradorSalarioPorColaborador(vo.getIdentificador());
        return vo;
    }

    public Colaborador pesquisarColaboradorPorNumeroRegistro(String numeroRegistro) {
        return ((DaoColaboradorImpl)this.getGenericDao()).pesquisarColaboradorPorNumeroRegistro(numeroRegistro);
    }

    public void atualizacaoSalarialColaborador(AtualizacaoSalarial vo) {
        for (ColaboradorSalario salColaborador : vo.getColaboradoresSalario()) {
            Colaborador colaborador = salColaborador.getColaborador();
            colaborador.setFuncao(salColaborador.getFuncao());
            colaborador.setValorSalario(salColaborador.getValorSalario());
            this.saveOrUpdate(colaborador);
        }
    }

    public Double getHorasTrabDiaEvt(Colaborador colab, Date data) {
        Double d1 = this.getHorasTrabDiaEvtSobEnc(colab, data);
        Double d2 = this.getHorasTrabDiaEvtLinProd(colab, data);
        return d1 + d2;
    }

    public Double getHorasTrabDiaEvtSobEnc(Colaborador colab, Date data) {
        return ((DaoColaboradorImpl)this.getGenericDao()).getHorasTrabDiaEvtSobEnc(colab, data);
    }

    public Double getHorasTrabDiaEvtLinProd(Colaborador colab, Date data) {
        return ((DaoColaboradorImpl)this.getGenericDao()).getHorasTrabDiaEvtLinProd(colab, data);
    }

    public List<Colaborador> findColaboradoresPrevisaoFerias(Date dataInicial, Date dataFinal, Long centroCusto, Empresa empresa, Short imprimirAfastados) {
        if (this.isEquals(imprimirAfastados, EnumConstantsSimNao.NAO.getValue())) {
            return ((DaoColaboradorImpl)this.getGenericDao()).findColaboradoresPrevisaoFeriasSemAfastados(dataInicial, dataFinal, centroCusto, empresa);
        }
        return ((DaoColaboradorImpl)this.getGenericDao()).findColaboradoresPrevisaoFeriasComAfastados(dataInicial, dataFinal, centroCusto, empresa);
    }

    public DTOColaboradorRes getColaboradorPorNumeroRegistroResumido(String numeroRegistroMatricula) {
        return ((DaoColaboradorImpl)this.getDao()).getColaboradorPorNumeroRegistroResumido(numeroRegistroMatricula);
    }

    public DTOColaboradorRes getColaboradorAtivoPorNumeroRegistroResumido(String numeroRegistroMatricula) {
        return ((DaoColaboradorImpl)this.getDao()).getColaboradorAtivoPorNumeroRegistroResumido(numeroRegistroMatricula);
    }

    public Colaborador getColaboradorPorNumeroRegistro(String numeroRegistroMatricula) {
        return ((DaoColaboradorImpl)this.getDao()).getColaboradorPorNumeroRegistro(numeroRegistroMatricula);
    }

    public boolean validaColaboradorSenhaAcesso(String numeroRegistroColaborador, String input) {
        return ((DaoColaboradorImpl)this.getDao()).validaColaboradorSenhaAcesso(numeroRegistroColaborador, input);
    }

    public ArqFotoColaborador getFotoColaborador(Colaborador vo) {
        return this.serviceBinaryArqFotoColaborador.getFotoColaborador(vo.getIdentificador());
    }

    public List<DTOColaboradorRes> getColaboradorAtivos(Empresa empresa) {
        return this.buildToDTOGeneric(((DaoColaboradorImpl)this.getDao()).getColaboradorAtivos(empresa), DTOColaboradorRes.class);
    }

    public Colaborador getColaboradorByPessoa(Pessoa pessoa) {
        if (this.isNull(pessoa).booleanValue()) {
            return null;
        }
        return this.getColaboradorByPessoa(pessoa.getIdentificador());
    }

    public Colaborador getColaboradorByPessoa(Long idPessoa) {
        return ((DaoColaboradorImpl)this.getGenericDao()).getColaboradorByIdPessoa(idPessoa);
    }

    public List<Colaborador> findColaboradoresSemEventosESocial(OpcoesESocial opcoes, GrupoEmpresa grupo) {
        return ((DaoColaboradorImpl)this.getGenericDao()).findColaboradoresSemEventosESocial(opcoes, grupo);
    }

    public List<DTOPontoFuncionario> findColaboradoresPonto(Date dataBaseSincDados, Date dataUltimaSincronizacao) {
        return ((DaoColaboradorImpl)this.getGenericDao()).findColaboradoresPonto(dataBaseSincDados, dataUltimaSincronizacao);
    }

    public List<Colaborador> findColaboradoresByTipoColaboradorEsoc(TipoEventoEsocial tipoEvento, GrupoEmpresa grupo, Date dataInicial, Date dataFinal) throws ExceptionObjNotFound {
        return ((DaoColaboradorImpl)this.getGenericDao()).findColaboradoresByTipoColaboradorEsoc(tipoEvento, grupo, null, null);
    }

    public String buscarProximoNumRegistro(Long empresa, Long tipo, CapsEmpresa capsEmpresa) {
        EmpresaRh empresaRh = this.serviceEmpresaRhImpl.getByIdEmpresa(capsEmpresa.get());
        if (this.isNotNull(empresaRh).booleanValue() && this.isEquals(empresaRh.getBuscarNumeroRegistro(), EnumConstantsMentorSimNao.SIM.getValue()) && this.isNotNull(empresa).booleanValue() && this.isNotNull(tipo).booleanValue()) {
            String ultimoRegistro = ((DaoColaboradorImpl)this.getGenericDao()).buscarUltimoNumRegistro(empresa, tipo);
            if (this.isStrWithData(ultimoRegistro)) {
                Integer novoNumRegistro = Integer.parseInt(ultimoRegistro) + 1;
                return String.valueOf(novoNumRegistro);
            }
            return "1";
        }
        return null;
    }

    public List<Colaborador> getColaboradoresAtivos(Date dataFinal, List<Long> centroCusto, List<Long> departamentos, List<String> nrRegColaboradores, Empresa empresa) {
        return ((DaoColaboradorImpl)this.getDao()).getColaboradoresAtivos(dataFinal, centroCusto, departamentos, nrRegColaboradores, empresa);
    }

    public DTOColaborador getBuscarPreCadastro(Long idPreCadastro, DTOColaborador dto) throws ExceptionObjNotFound {
        PreCadastroColaborador preCadastroColaborador = (PreCadastroColaborador)this.servicePreCadastroColaboradorImpl.getOrThrow(idPreCadastro);
        HelperColaborador helperColaborador = new HelperColaborador();
        Colaborador colaborador = helperColaborador.getBuscarPreCadastro(preCadastroColaborador, (Colaborador)this.buildToEntity(dto));
        return this.buildToDTOGeneric(colaborador, DTOColaborador.class);
    }

    public List<DTOEventoColaborador> carregarEventoFolha(Long[] ids) {
        List listTipoCalculoEvento = this.serviceTipoCalculoEventoImpl.gets(ids);
        List eventosColaborador = listTipoCalculoEvento.stream().map(i -> {
            EventoColaborador item = new EventoColaborador();
            item.setTipoCalculoEvento(i);
            item.setValor(Double.valueOf(0.0));
            item.setAtivo(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            return item;
        }).collect(Collectors.toList());
        List<DTOEventoColaborador> ret = this.buildToDTOGeneric(eventosColaborador, DTOEventoColaborador.class);
        this.sCompColaborador.definirTipoEventoColaborador(ret);
        return ret;
    }

    public CompletableFuture<File> salvarFotoColaborador(Long idColaborador) throws ExceptionIO {
        ArqFotoColaborador arqFotoColaborador = this.serviceBinaryArqFotoColaborador.getFotoColaborador(idColaborador);
        if (this.isNull(arqFotoColaborador).booleanValue()) {
            return null;
        }
        File arquivo = ToolFile.createTempFile((String)"imagem", (String)".png");
        ToolFile.writeBytesOnFile((File)arquivo, (byte[])arqFotoColaborador.getFoto());
        return CompletableFuture.completedFuture(arquivo);
    }

    public List<DTOEsocTreinamentoColaborador> adicionarTreinamento(Long[] ids) {
        List listEsocTreinamento = this.serviceEsocTreinamentoImpl.gets(ids);
        List listEsocTreinamentoColaborador = listEsocTreinamento.stream().map(i -> {
            EsocTreinamentoColaborador item = new EsocTreinamentoColaborador();
            item.setEsocTreinamento(i);
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(listEsocTreinamentoColaborador, DTOEsocTreinamentoColaborador.class);
    }

    public DTOColaborador carregarParametrizacao(Long idParametrizacaoEventosAdmissao, DTOColaborador input) throws ExceptionObjNotFound {
        Colaborador colaborador = (Colaborador)this.buildToEntity(input);
        if (this.isNull(colaborador.getDataAdmissao()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0516.004"));
        }
        ParametrizacaoEventosAdmissao paramEventoAdmissao = (ParametrizacaoEventosAdmissao)this.serviceParametrizacaoEventosAdmissaoImpl.getOrThrow(idParametrizacaoEventosAdmissao);
        List listEventoColaborador = paramEventoAdmissao.getItens().stream().map(i -> {
            EventoColaborador item = new EventoColaborador();
            item.setAtivo(EnumConstantsMentorSimNao.SIM.getEnumId());
            item.setTipoOcorrencia(i.getTipoEventoAdmissao().getTipoOcorrencia());
            if (this.isEquals(item.getTipoOcorrencia(), EnumConstTipoOcorrenciaEvtColaborador.TP_OCORRENCIA_ESPECIFICAMENTE_PERIODO.getEnumId())) {
                item.setDataInicial(colaborador.getDataAdmissao());
            } else {
                item.setMes(i.getMes());
            }
            item.setTipoCalculoEvento(i.getTipoCalculo());
            return item;
        }).collect(Collectors.toList());
        colaborador.setEventos(listEventoColaborador);
        return this.buildToDTOGeneric(colaborador, DTOColaborador.class);
    }

    public Date getUltimaDataDemissaoPorPessoaEmpresa(Long idEmpresa, Long idPessoa) {
        return ((DaoColaboradorImpl)this.getGenericDao()).getUltimaDataDemissaoPorPessoaEmpresa(idEmpresa, idPessoa);
    }

    private void verificarAlteracaoContratual(Colaborador vo) {
        Colaborador colaboradorSalvo;
        if (!this.isNotNull(vo).booleanValue() || !this.isNotNull(vo.getIdentificador()).booleanValue() || vo.getIdentificador() <= 0L || !this.isNull((colaboradorSalvo = (Colaborador)this.get(vo.getIdentificador())).getRegimeJornadaTrabalho()).booleanValue() || this.isNull(vo.getRegimeJornadaTrabalho()).booleanValue()) {
            // empty if block
        }
    }

    public void buildEsocEventos(CapsEmpresa capsEmpresa, Colaborador vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial {
        EmpresaRh empresaRh = this.serviceEmpresaRhImpl.getByIdEmpresa(capsEmpresa.get());
        if (this.isEquals(empresaRh.getAutomatizarAdmissao(), EnumConstantsMentorSimNao.SIM.getValue()) && !ServiceColaboradorImpl.isWithData(vo.getPreEventosEsocial())) {
            vo.setPreEventosEsocial(new ArrayList());
            vo.getPreEventosEsocial().add(this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstTipoEventoESocial.CADASTRAMENTO_INICIAL_VINC_ADMISSAO_INGRESSO_TRAB, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE, EnumConstantsMentorSimNao.NAO.getValue()));
            vo.getPreEventosEsocial().add(this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstTipoEventoESocial.CADASTRAMENTO_INICIAL_VINC_ADMISSAO_INGRESSO_TRAB, EnumConstEventoProducao.EVENTO_PRODUCAO, EnumConstantsMentorSimNao.NAO.getValue()));
        }
    }

    public Colaborador findColaboradorCarteiraPlanoSaude(String numeroCarteira) {
        return ((DaoColaboradorImpl)this.getDao()).findColaboradorCarteiraPlanoSaude(numeroCarteira);
    }

    public void salvarFotoColaboradorImagem(DTOColaborador.DTOImagemPessoa imagemPessoa, Long idColaborador) throws IOException, ExceptionDecodeHexString64 {
        ArqFotoColaborador arq;
        if (this.isNotNull(idColaborador).booleanValue() && this.isNotNull(imagemPessoa).booleanValue() && this.isStrWithData(imagemPessoa.getImage()) && this.isNull(arq = this.serviceBinaryArqFotoColaborador.getFotoColaborador(idColaborador)).booleanValue()) {
            arq = new ArqFotoColaborador();
            arq.setFoto(ToolBase64.decodeBase64((String)imagemPessoa.getImage()));
            arq.setIdColaborador(idColaborador);
            this.serviceBinaryArqFotoColaborador.saveOrUpdate((Object)arq);
        }
    }

    public DTOColaborador.DTOImagemPessoa buildImageColaborador(MultipartFile imagem) throws ExceptionInvalidData, IOException, ExceptionIO {
        if (this.isNull(imagem).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.0516.012", new Object[0]);
        }
        String hexImg = this.buildImage(imagem);
        DTOColaborador.DTOImagemPessoa dto = new DTOColaborador.DTOImagemPessoa();
        dto.setImage(hexImg);
        return dto;
    }

    public String buildImage(MultipartFile imagem) throws IOException, ExceptionIO {
        byte[] img = imagem.getBytes();
        String str = this.processImage(img, ToolImage.SIZE_STANDARD);
        return str;
    }

    public String processImage(byte[] img, Dimension dimension) throws ExceptionIO {
        if (this.isNull(img).booleanValue()) {
            return null;
        }
        ToolImage.ImageFormat format = ToolImage.getImageFormat((byte[])img);
        if (!ToolMethods.isEquals((Object)format, (Object)ToolImage.ImageFormat.PNG)) {
            img = ToolImage.convertImage((byte[])img, (ToolImage.ImageFormat)ToolImage.ImageFormat.PNG);
        }
        File temp = ToolFile.createTempFile((String)"imagem.png");
        ToolFile.writeBytesOnFile((File)temp, (byte[])img);
        temp = ToolImage.resizeImageKeepAspectRatioIfGreater((File)temp, (Dimension)ToolImage.SIZE_MEDIUM_THUMB_NAIL);
        img = ToolFile.getBytesFromFile((File)temp);
        return ToolBase64.encodeBase64((byte[])img);
    }

    public void excluirImagemColaborador(Long idColaborador) {
        this.serviceBinaryArqFotoColaborador.deleteImagemColaborador(idColaborador);
    }

    public List<Colaborador> findColaboradorByCentroCustoAndEmpresa(Long empresa, Long centroCusto) {
        return ((DaoColaboradorImpl)this.getGenericDao()).findColaboradorByCentroCustoAndEmpresa(empresa, centroCusto);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Colaborador saveOrUpdate(Colaborador colab, ColaboradorSalario cs, AfastamentoColaborador afast) {
        colab = this.saveOrUpdateOnly(colab);
        if (cs != null) {
            cs.setColaborador(colab);
            this.serviceColaboradorSalarioImpl.saveOrUpdate(cs);
        }
        if (afast != null) {
            afast.setColaborador(colab);
            this.serviceAfastamentoColaboradorImpl.saveOrUpdate(afast);
        }
        return colab;
    }

    public void definirTipoEventoColaborador(DTOColaborador dto) {
        if (this.isNotNull(dto).booleanValue()) {
            this.sCompColaborador.definirTipoEventoColaborador(dto.getEventos());
        }
    }

    public DTOEventoColaborador definirTipoEventoColaborador(DTOEventoColaborador dto) {
        if (this.isNotNull(dto).booleanValue()) {
            this.sCompColaborador.definirTipoEventoColaborador(dto);
        }
        return dto;
    }
}

