/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.colaboradorevtosprodsobenc;

import com.touchcomp.basementor.constants.enums.eventoosproducao.EnumConstFiltroColabAcompProducao;
import com.touchcomp.basementor.constants.enums.eventoosproducao.EnumConstTipoEvento;
import com.touchcomp.basementor.model.vo.ColaboradorEvtOsProdSobEnc;
import com.touchcomp.basementor.model.vo.EventoOsProdSobEnc;
import com.touchcomp.basementor.model.vo.EvtOSSobEncomendaEquip;
import com.touchcomp.basementor.model.vo.ItemEventoOsProdSobEnc;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.colaborador.web.DTOColaboradorAcompanhamentoProducao;
import com.touchcomp.touchvomodel.vo.equipamento.DTOEquipamentoRes;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AuxDashboardEvtProducao {
    public List<DTOColaboradorAcompanhamentoProducao> getColaboradoresEventos(List<ColaboradorEvtOsProdSobEnc> eventos, EnumConstFiltroColabAcompProducao statusColaborador) {
        if (eventos == null || eventos.isEmpty()) {
            return new ArrayList<DTOColaboradorAcompanhamentoProducao>();
        }
        ArrayList<DTOColaboradorAcompanhamentoProducao> ret = new ArrayList<DTOColaboradorAcompanhamentoProducao>();
        block7: for (ColaboradorEvtOsProdSobEnc evt : eventos) {
            switch (statusColaborador) {
                case COM_APONTAMENTO_ABERTO: {
                    if (!this.eventoAberto(evt).booleanValue()) continue block7;
                    this.adicionarColaborador(ret, evt, EnumConstFiltroColabAcompProducao.COM_APONTAMENTO_ABERTO);
                    continue block7;
                }
                case SEM_APONTAMENTO_ABERTO: {
                    if (!this.eventoConcluido(evt).booleanValue()) continue block7;
                    this.adicionarColaborador(ret, evt, EnumConstFiltroColabAcompProducao.SEM_APONTAMENTO_ABERTO);
                    continue block7;
                }
                case TEMPO_COM_LIMITE_CRITICO_EXCEDIDO: {
                    if (!this.eventoComTempoLimiteCriticoExcedido(evt).booleanValue()) continue block7;
                    this.adicionarColaborador(ret, evt, EnumConstFiltroColabAcompProducao.TEMPO_COM_LIMITE_CRITICO_EXCEDIDO);
                    continue block7;
                }
                case COM_PARADA_PROGRAMADA: {
                    if (!this.eventoComParadaProgramada(evt).booleanValue()) continue block7;
                    this.adicionarColaborador(ret, evt, EnumConstFiltroColabAcompProducao.COM_PARADA_PROGRAMADA);
                    continue block7;
                }
                case COM_PARADA_NAO_PROGRAMADA: {
                    if (!this.eventoComParadaNaoProgramada(evt).booleanValue()) continue block7;
                    this.adicionarColaborador(ret, evt, EnumConstFiltroColabAcompProducao.COM_PARADA_NAO_PROGRAMADA);
                    continue block7;
                }
            }
            this.adicionarColaborador(ret, evt, EnumConstFiltroColabAcompProducao.TODOS);
        }
        return ret;
    }

    private Boolean eventoAberto(ColaboradorEvtOsProdSobEnc evt) {
        if (TMethods.isEquals((Object)evt.getEventoOsProdSobEnc().getTipoEvento().getTiposFixos(), (Object)EnumConstTipoEvento.ABERTURA_ENCERRAMENTO.getValue()) && evt.getEventoOsProdSobEnc().getDataFechamento() == null) {
            return true;
        }
        return false;
    }

    private Boolean eventoConcluido(ColaboradorEvtOsProdSobEnc evt) {
        if (TMethods.isEquals((Object)evt.getEventoOsProdSobEnc().getTipoEvento().getTiposFixos(), (Object)EnumConstTipoEvento.ABERTURA_ENCERRAMENTO.getValue()) && evt.getEventoOsProdSobEnc().getDataFechamento() != null) {
            return true;
        }
        return false;
    }

    private Boolean eventoComTempoLimiteCriticoExcedido(ColaboradorEvtOsProdSobEnc evt) {
        Double horas = ToolDate.difBetweenDatesInHoursNumber((Date)evt.getEventoOsProdSobEnc().getDataAbertura(), (Date)new Date());
        Double dif = horas - evt.getEventoOsProdSobEnc().getSubdivisaoOSProdSobEnc().getHorasPrevistas();
        if (TMethods.isEquals((Object)evt.getEventoOsProdSobEnc().getTipoEvento().getTiposFixos(), (Object)EnumConstTipoEvento.ABERTURA_ENCERRAMENTO.getValue()) && evt.getEventoOsProdSobEnc().getDataFechamento() == null && dif >= 0.25) {
            return true;
        }
        return false;
    }

    private Boolean eventoComParadaNaoProgramada(ColaboradorEvtOsProdSobEnc evt) {
        if (TMethods.isEquals((Object)evt.getEventoOsProdSobEnc().getTipoEvento().getTiposFixos(), (Object)EnumConstTipoEvento.PREVENTIVA_CORRETIVA.getValue()) && evt.getEventoOsProdSobEnc().getDataFechamento() != null) {
            return true;
        }
        return false;
    }

    private Boolean eventoComParadaProgramada(ColaboradorEvtOsProdSobEnc evt) {
        if (TMethods.isEquals((Object)evt.getEventoOsProdSobEnc().getTipoEvento().getTiposFixos(), (Object)EnumConstTipoEvento.PARADA_FUNCIONAL.getValue()) && evt.getEventoOsProdSobEnc().getDataFechamento() != null) {
            return true;
        }
        return false;
    }

    private void adicionarColaborador(List<DTOColaboradorAcompanhamentoProducao> ret, ColaboradorEvtOsProdSobEnc ce, EnumConstFiltroColabAcompProducao statusColaborador) {
        DTOColaboradorAcompanhamentoProducao dto = this.getColaboradorAdicionado(ret, ce);
        if (dto == null) {
            dto = new DTOColaboradorAcompanhamentoProducao();
            dto.setIdentificador(ce.getColaborador().getIdentificador());
            dto.setPessoa(ce.getColaborador().getPessoa().getNome());
            dto.setDataCadastro(ce.getColaborador().getDataCadastro());
            dto.setDataAdmissao(ce.getColaborador().getDataAdmissao());
            dto.setDataAtualizacao(ce.getColaborador().getDataAtualizacao());
            dto.setDataDemissao(ce.getColaborador().getDataDemissao());
            dto.setNumeroRegistro(ce.getColaborador().getNumeroRegistro());
            if (ce.getColaborador().getDepartamento() != null) {
                dto.setDepartamento(ce.getColaborador().getDepartamento().toString());
                dto.setDepartamentoIdentificador(ce.getColaborador().getDepartamento().getIdentificador());
            }
            if (ce.getColaborador().getCentroCusto() != null) {
                dto.setCentroCusto(ce.getColaborador().getCentroCusto().toString());
                dto.setCentroCustoIdentificador(ce.getColaborador().getCentroCusto().getIdentificador());
            }
            if (ce.getColaborador().getHorarioTrabalho() != null && ce.getColaborador().getHorarioTrabalho().getTurnoDeTrabalho() != null) {
                dto.setTurnoDeTrabalho(ce.getColaborador().getHorarioTrabalho().getTurnoDeTrabalho().toString());
                dto.setTurnoDeTrabalhoIdentificador(ce.getColaborador().getHorarioTrabalho().getTurnoDeTrabalho().getIdentificador());
            }
            dto.setEventosConcluidos(new ArrayList());
            dto.setEventosEmExecucao(new ArrayList());
            ret.add(dto);
        }
        if (ce.getEventoOsProdSobEnc().getDataFechamento() != null) {
            dto.getEventosConcluidos().add(this.getEvento(ce.getEventoOsProdSobEnc(), EnumConstFiltroColabAcompProducao.SEM_APONTAMENTO_ABERTO));
        } else {
            EnumConstFiltroColabAcompProducao status = statusColaborador;
            if (TMethods.isEquals((Object)statusColaborador, (Object)EnumConstFiltroColabAcompProducao.TODOS)) {
                if (this.eventoComTempoLimiteCriticoExcedido(ce).booleanValue()) {
                    status = EnumConstFiltroColabAcompProducao.TEMPO_COM_LIMITE_CRITICO_EXCEDIDO;
                } else if (this.eventoAberto(ce).booleanValue()) {
                    status = EnumConstFiltroColabAcompProducao.COM_APONTAMENTO_ABERTO;
                } else if (this.eventoConcluido(ce).booleanValue()) {
                    status = EnumConstFiltroColabAcompProducao.SEM_APONTAMENTO_ABERTO;
                } else if (this.eventoComParadaProgramada(ce).booleanValue()) {
                    status = EnumConstFiltroColabAcompProducao.COM_PARADA_PROGRAMADA;
                } else if (this.eventoComParadaNaoProgramada(ce).booleanValue()) {
                    status = EnumConstFiltroColabAcompProducao.COM_PARADA_NAO_PROGRAMADA;
                }
            }
            DTOColaboradorAcompanhamentoProducao.DTOEventoAcompanhamentoProducao vtDto = this.getEvento(ce.getEventoOsProdSobEnc(), status);
            dto.getEventosEmExecucao().add(vtDto);
        }
    }

    private DTOColaboradorAcompanhamentoProducao.DTOEventoAcompanhamentoProducao getEvento(EventoOsProdSobEnc evt, EnumConstFiltroColabAcompProducao status) {
        DTOColaboradorAcompanhamentoProducao.DTOEventoAcompanhamentoProducao dto = new DTOColaboradorAcompanhamentoProducao.DTOEventoAcompanhamentoProducao();
        dto.setIdentificador(evt.getIdentificador());
        if (evt.getSubdivisaoOSProdSobEnc() != null) {
            if (evt.getSubdivisaoOSProdSobEnc().getItemFormulacaoFases() != null && evt.getSubdivisaoOSProdSobEnc().getItemFormulacaoFases().getFaseProdutiva() != null) {
                dto.setFaseProdutiva(evt.getSubdivisaoOSProdSobEnc().getItemFormulacaoFases().getFaseProdutiva().getDescricaoAuxiliar());
            }
            if (evt.getSubdivisaoOSProdSobEnc().getOrdemServicoProdSobEnc() != null) {
                dto.setOrdemProducao(evt.getSubdivisaoOSProdSobEnc().getOrdemServicoProdSobEnc().getCodigo());
                dto.setProduto(evt.getSubdivisaoOSProdSobEnc().getOrdemServicoProdSobEnc().getGradeCor().getProdutoGrade().getProduto().getIdentificador() + " - " + evt.getSubdivisaoOSProdSobEnc().getOrdemServicoProdSobEnc().getGradeCor().getProdutoGrade().getProduto().getNome());
                dto.setNumDesenhoProducao(evt.getSubdivisaoOSProdSobEnc().getOrdemServicoProdSobEnc().getObservacoesPedidos());
                dto.setQuantidade(this.getQuantidadeTotal(evt));
            }
            dto.setNrOrdem(evt.getSubdivisaoOSProdSobEnc().getNrOrdem());
        }
        if (evt.getFaseProdutiva() != null) {
            dto.setEquipamentos(this.getEquipamentos(evt));
            dto.setCelulaProdutiva(evt.getFaseProdutiva().getCelulaProdutiva().getDescricao());
        }
        dto.setInicioProducao(evt.getDataAbertura());
        dto.setFimProducao(evt.getDataFechamento());
        dto.setStatus(Short.valueOf(status.getValue()));
        return dto;
    }

    private List<DTOEquipamentoRes> getEquipamentos(EventoOsProdSobEnc eventOsProdSobEnc) {
        ArrayList<DTOEquipamentoRes> equipamentos = new ArrayList<DTOEquipamentoRes>();
        if (eventOsProdSobEnc.getEquipamentos() != null) {
            for (EvtOSSobEncomendaEquip evtOS : eventOsProdSobEnc.getEquipamentos()) {
                DTOEquipamentoRes dto = new DTOEquipamentoRes();
                dto.setNome(evtOS.getFaseProdutivaEquip().getCelProdutivaEquip().getEquipamento().getNome());
                dto.setCodigo(evtOS.getFaseProdutivaEquip().getCelProdutivaEquip().getEquipamento().getCodigo());
                dto.setIdentificador(evtOS.getFaseProdutivaEquip().getCelProdutivaEquip().getEquipamento().getIdentificador());
                equipamentos.add(dto);
            }
        }
        return equipamentos;
    }

    private Double getQuantidadeTotal(EventoOsProdSobEnc evt) {
        if (evt.getItemEventoOsProdSobEnc() != null) {
            for (ItemEventoOsProdSobEnc itemEvt : evt.getItemEventoOsProdSobEnc()) {
                if (!TMethods.isEquals((Object)evt.getSubdivisaoOSProdSobEnc().getOrdemServicoProdSobEnc().getGradeCor().getProdutoGrade().getProduto(), (Object)itemEvt.getItemComunicadoProducao().getProduto())) continue;
                return itemEvt.getItemComunicadoProducao().getQuantidadeTotal();
            }
        }
        return 0.0;
    }

    private DTOColaboradorAcompanhamentoProducao getColaboradorAdicionado(List<DTOColaboradorAcompanhamentoProducao> colab, ColaboradorEvtOsProdSobEnc ce) {
        for (DTOColaboradorAcompanhamentoProducao dto : colab) {
            if (!TMethods.isEquals((Object)dto.getIdentificador(), (Object)ce.getColaborador().getIdentificador())) continue;
            return dto;
        }
        return null;
    }
}

