/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.colaboradorevtosprodsobenc;

import com.touchcomp.basementor.constants.enums.eventoosproducao.EnumConstFiltroColabAcompProducao;
import com.touchcomp.basementor.model.vo.ColaboradorEvtOsProdSobEnc;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoColaboradorEvtOsProdSobEncImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.colaboradorevtosprodsobenc.AuxDashboardEvtProducao;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchvomodel.vo.colaborador.web.DTOColaboradorAcompanhamentoProducao;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceColaboradorEvtOsProdSobEncImpl
extends ServiceGenericEntityImpl<ColaboradorEvtOsProdSobEnc, Long, DaoColaboradorEvtOsProdSobEncImpl> {
    @Autowired
    public ServiceColaboradorEvtOsProdSobEncImpl(DaoColaboradorEvtOsProdSobEncImpl genericDao) {
        super(genericDao);
    }

    public List<DTOColaboradorAcompanhamentoProducao> getColaboradoresEventos(Long departamento, Long turnoDeTrabalho, EnumConstFiltroColabAcompProducao statusColaborador) {
        List<ColaboradorEvtOsProdSobEnc> eventos = ((DaoColaboradorEvtOsProdSobEncImpl)this.getGenericDao()).getColaboradoresAtivosEventos(departamento, turnoDeTrabalho);
        return new AuxDashboardEvtProducao().getColaboradoresEventos(eventos, statusColaborador);
    }

    public DTOColaboradorAcompanhamentoProducao getEventosByColaborador(Long colaborador, EnumConstFiltroColabAcompProducao statusColaborador) {
        List<DTOColaboradorAcompanhamentoProducao> result;
        List<ColaboradorEvtOsProdSobEnc> eventos = ((DaoColaboradorEvtOsProdSobEncImpl)this.getGenericDao()).getEventosByColaborador(colaborador);
        if (eventos != null && !eventos.isEmpty() && (result = new AuxDashboardEvtProducao().getColaboradoresEventos(eventos, statusColaborador)) != null && !result.isEmpty()) {
            return result.get(0);
        }
        return null;
    }

    public List<DTOColaboradorAcompanhamentoProducao> getEventosByColaborador(Long[] colaborador, EnumConstFiltroColabAcompProducao statusColaborador) {
        ArrayList<DTOColaboradorAcompanhamentoProducao> ret = new ArrayList<DTOColaboradorAcompanhamentoProducao>();
        for (Long c : colaborador) {
            DTOColaboradorAcompanhamentoProducao dto = this.getEventosByColaborador(c, statusColaborador);
            if (dto == null) continue;
            ret.add(dto);
        }
        return ret;
    }

    public List<DTOColaboradorAcompanhamentoProducao.DTOEventoAcompanhamentoProducao> getColaboradoresEventosConcluidosPorData(Long departamento, Long turnoDeTrabalho, EnumConstFiltroColabAcompProducao statusColaborador, Long idColaborador, Long dtInicial, Long dtFinal) {
        if (this.isNull(dtInicial).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1968.001"));
        }
        if (this.isNull(dtFinal).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1968.002"));
        }
        Date dataInicial = ToolDate.lowDateTime((Date)new Date(dtInicial));
        Date dataFinal = ToolDate.highDateTime((Date)new Date(dtFinal));
        List<ColaboradorEvtOsProdSobEnc> eventos = ((DaoColaboradorEvtOsProdSobEncImpl)this.getGenericDao()).getColaboradorPorDataInicialFinal(departamento, turnoDeTrabalho, idColaborador, dataInicial, dataFinal);
        List<DTOColaboradorAcompanhamentoProducao> result = new AuxDashboardEvtProducao().getColaboradoresEventos(eventos, statusColaborador);
        if (!ServiceColaboradorEvtOsProdSobEncImpl.isWithData(result)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1968.003"));
        }
        return this.buildToDTOGeneric(result.get(0).getEventosConcluidos(), DTOColaboradorAcompanhamentoProducao.DTOEventoAcompanhamentoProducao.class);
    }
}

