/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.coleta;

import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.ColetaDadosAtivo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.TipoPontoControle;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.components.coleta.CompColeta;
import com.touchcomp.basementorservice.dao.impl.DaoColetaImpl;
import com.touchcomp.basementorservice.helpers.impl.coleta.HelperColeta;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.equipamento.ServiceEquipamentoImpl;
import com.touchcomp.basementorservice.service.impl.ordemservico.ServiceOrdemServicoImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceColetaImpl
extends ServiceGenericEntityImpl<Coleta, Long, DaoColetaImpl> {
    HelperColeta helperColeta;
    private ServiceEquipamentoImpl serviceEquipamento;
    private CompColeta compColeta;
    private ServiceOrdemServicoImpl serviceOrdemServico;

    @Autowired
    public ServiceColetaImpl(DaoColetaImpl dao, HelperColeta helperColeta, ServiceEquipamentoImpl serviceEquipamento, ServiceOrdemServicoImpl serviceOrdemServico, CompColeta compColeta) {
        super(dao);
        this.helperColeta = helperColeta;
        this.serviceEquipamento = serviceEquipamento;
        this.serviceOrdemServico = serviceOrdemServico;
        this.compColeta = compColeta;
    }

    public Coleta findColetaAnterior(Equipamento ativo, TipoPontoControle tipoPontoControle) {
        return ((DaoColetaImpl)this.getGenericDao()).findColetaAnterior(ativo, tipoPontoControle);
    }

    public Coleta findByNumero(Long numero, Long ativo) {
        return ((DaoColetaImpl)this.getDao()).findByNumero(numero, ativo);
    }

    public void setColetaAnterior(Coleta coleta) {
        Coleta coletaAnterior = this.findColetaAnterior(coleta.getAtivo(), coleta.getTipoPontoControle());
        coleta.setColetaAnterior(coletaAnterior);
        this.helperColeta.build(coleta).calculaValorAcumulado(coleta);
    }

    @Override
    public Coleta beforeSaveEntity(Coleta aux) {
        this.setColetaAnterior(aux);
        return super.beforeSave(aux);
    }

    public Coleta getColeta(ColetaDadosAtivo coleta) {
        return ((DaoColetaImpl)this.getDao()).getColeta(coleta);
    }

    public List<Coleta> buscaColetasAtivoComExclusao(Coleta coleta) {
        return ((DaoColetaImpl)this.getDao()).buscaColetasAtivoComExclusao(coleta);
    }

    public List<Coleta> gerarColetas(Long equipamentoIdentificador, Empresa empresa) throws ExceptionValidacaoDados {
        Equipamento eq = (Equipamento)this.serviceEquipamento.get(equipamentoIdentificador);
        if (eq == null) {
            throw new ExceptionValidacaoDados("E.ERP.1131.001", new Object[0]);
        }
        Boolean possuiSubComponentes = this.serviceEquipamento.isSubComponente(eq);
        if (possuiSubComponentes.booleanValue() || eq.getTipoPontoControleAtivo() == null || eq.getTipoPontoControleAtivo().isEmpty()) {
            throw new ExceptionValidacaoDados("E.ERP.1131.002", new Object[0]);
        }
        return this.compColeta.gerarColetas(eq, empresa);
    }

    public List<Coleta> checkExclusaoAtivoColeta(Long ativoIdentificador, List<Coleta> coletas) {
        Equipamento ativo = (Equipamento)this.serviceEquipamento.get(ativoIdentificador);
        Boolean isSubComponent = this.serviceEquipamento.isSubComponente(ativo);
        if (!isSubComponent.booleanValue()) {
            return this.compColeta.checkExclusaoAtivoColeta(ativo, coletas);
        }
        return new ArrayList<Coleta>();
    }

    public Double getColetaAnterior(String codigoAtivoPlaca, Date dataColeta) {
        return ((DaoColetaImpl)this.getDao()).getColetaAnterior(codigoAtivoPlaca, dataColeta);
    }

    public Coleta getUltimaColetaAtivoComExclusao(Coleta c) {
        List<Coleta> coletas = this.buscaColetasAtivoComExclusao(c);
        for (Coleta coleta : coletas) {
            OrdemServico ordemServicoColeta = this.serviceOrdemServico.findByColeta(coleta);
            if (ordemServicoColeta == null || ordemServicoColeta.getColeta() == null || ordemServicoColeta.getColeta().getNumeroColeta() == null || ordemServicoColeta.getColeta().getNumeroColeta() <= 0L) continue;
            return ordemServicoColeta.getColeta();
        }
        return null;
    }

    public Integer getValorAcumuladoColetaAtivo(Coleta c) {
        Integer valorAcumuladoTotal = 0;
        Long numeroUltimaColeta = 0L;
        List<Coleta> coletas = this.buscaColetasAtivoComExclusao(c);
        for (Coleta coleta : coletas) {
            OrdemServico ordemServicoColeta = this.serviceOrdemServico.findByColeta(coleta);
            if (ordemServicoColeta == null || ordemServicoColeta.getColeta() == null || ordemServicoColeta.getColeta().getNumeroColeta() == null) continue;
            numeroUltimaColeta = ordemServicoColeta.getColeta().getNumeroColeta();
            break;
        }
        for (Coleta coleta : coletas) {
            if (numeroUltimaColeta >= coleta.getNumeroColeta() || coleta.getColetaAnterior() == null) continue;
            valorAcumuladoTotal = coleta.getValorColeta() - coleta.getColetaAnterior().getValorColeta() + valorAcumuladoTotal;
        }
        if ((long)valorAcumuladoTotal.intValue() == 0L && c.getColetaAnterior() != null) {
            valorAcumuladoTotal = c.getColetaAnterior().getValorAcumulado();
        }
        return valorAcumuladoTotal;
    }
}

