/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.coletadadosativo;

import com.touchcomp.basementor.constants.enums.arquivodadospendentes.EnumConstDadosArquivoPendentes;
import com.touchcomp.basementor.constants.enums.equipcoletadadosativoiot.EnumConstEquipColDadosAtTipoEvt;
import com.touchcomp.basementor.model.impl.DataProcResult;
import com.touchcomp.basementor.model.vo.ArquivoDadosPendentes;
import com.touchcomp.basementor.model.vo.ColetaDadosAtivo;
import com.touchcomp.basementor.model.vo.EquipColetaDadosAtivoIOT;
import com.touchcomp.basementor.model.vo.EquipColetaDadosAtivoSensorIOT;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.SmartComponentPref;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIDefaultParams;
import com.touchcomp.basementorservice.components.businessintelligence.model.DefaultBIParamsMap;
import com.touchcomp.basementorservice.components.coletadadosativo.CompColetaDadosAtivo;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.arquivodadospendentes.ServiceArquivoDadosPendentesImpl;
import com.touchcomp.basementorservice.service.impl.coletadadosativo.ServiceColetaDadosAtivoImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.equipcoletadadosativoiot.ServiceEquipColetaDadosAtivoIOTImpl;
import com.touchcomp.basementorservice.service.impl.smartcomponente.BaseSmartComponenteResult;
import com.touchcomp.basementorservice.service.impl.smartcomponente.ServiceBuildSmartComponentImpl;
import com.touchcomp.basementorservice.service.impl.smartcomponente.voresult.InterfaceSCResult;
import com.touchcomp.basementorservice.service.impl.smartcomponente.voresult.SCResultDTO;
import com.touchcomp.basementorservice.tasks.TaskCreator;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.exception.ToolException;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.touchvomodel.vo.coletadadosativo.web.DTOColetaDadosSmartFactory;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(transactionManager="transactionManager", readOnly=false)
public class SCImportarColetaDadosAtivoImpl
extends ServiceGenericImpl {
    final ServiceArquivoDadosPendentesImpl serviceArquivoDadosPendentesImpl;
    final ServiceEquipColetaDadosAtivoIOTImpl serviceEquipColeta;
    final ServiceColetaDadosAtivoImpl serviceColeta;
    final ServiceBuildSmartComponentImpl serviceBuildSmartComponent;
    final ServiceEmpresaImpl serviceEmpresa;
    final CompColetaDadosAtivo compColetaDadosAtivo;

    public SCImportarColetaDadosAtivoImpl(ServiceArquivoDadosPendentesImpl serviceArquivoDadosPendentesImpl, ServiceColetaDadosAtivoImpl serviceColeta, ServiceEquipColetaDadosAtivoIOTImpl serviceEquipColeta, ServiceBuildSmartComponentImpl serviceBuildSmartComponent, ServiceEmpresaImpl serviceEmpresa, CompColetaDadosAtivo compColetaDadosAtivo) {
        this.serviceArquivoDadosPendentesImpl = serviceArquivoDadosPendentesImpl;
        this.serviceEquipColeta = serviceEquipColeta;
        this.serviceColeta = serviceColeta;
        this.serviceBuildSmartComponent = serviceBuildSmartComponent;
        this.serviceEmpresa = serviceEmpresa;
        this.compColetaDadosAtivo = compColetaDadosAtivo;
    }

    public DataProcResult<List<ColetaDadosAtivo>> importarDados(ArquivoDadosPendentes input) {
        return this.importarDados(input.getDadosArquivo(), false, input.getEquipColetaDadosAtivoIOT());
    }

    public DataProcResult<List<ColetaDadosAtivo>> importarDados(String input, Long idEquipamentoIOTColeta) throws ExceptionObjNotFound {
        EquipColetaDadosAtivoIOT eq = (EquipColetaDadosAtivoIOT)this.serviceEquipColeta.getOrThrow(idEquipamentoIOTColeta);
        return this.importarDados(input, true, eq);
    }

    public synchronized void importarColetaDadosAtivoIOTPendentes() {
        List data;
        long first = 0L;
        long page = 10L;
        do {
            data = this.serviceArquivoDadosPendentesImpl.getAll(first, page);
            for (ArquivoDadosPendentes arq : data) {
                if (!this.importarColetaDadosAtivoIOT(arq).getStatus().isOk()) continue;
                this.serviceArquivoDadosPendentesImpl.delete(arq);
            }
        } while (!data.isEmpty());
    }

    public DataProcResult<List<ColetaDadosAtivo>> importarColetaDadosAtivoIOT(ArquivoDadosPendentes arq) {
        return this.importarDados(arq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataProcResult<List<ColetaDadosAtivo>> importarDados(String input, boolean saveArqCasoErro, EquipColetaDadosAtivoIOT eq) {
        DataProcResult result = new DataProcResult((Object)input);
        this.gerarLogFiles(input);
        try {
            DTOColetaDadosSmartFactory coletaDTO = null;
            SmartComponentPref smart = eq.getSmartComponenteProcArquivo();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("P_INPUT_FILE_DATA", input);
            BaseSmartComponenteResult<InterfaceSCResult> ret = this.serviceBuildSmartComponent.buildSC(smart, (DefaultBIParamsMap<String, Object>)CompBIDefaultParams.getDefParamsMap(params), new TaskCreator.TaskProgress());
            if (!ret.getStatus().isOk()) {
                throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.1949.003"));
            }
            coletaDTO = (DTOColetaDadosSmartFactory)((SCResultDTO)ret.getResult()).getResultDTO();
            if (coletaDTO == null) {
                throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.1949.003"));
            }
            String mac = "";
            String uid = "";
            String lockit = "lock";
            if (TMethods.isStrWithData((String)coletaDTO.getCodigoUID())) {
                lockit = uid = coletaDTO.getCodigoUID();
            }
            if (TMethods.isStrWithData((String)coletaDTO.getMacAddress())) {
                lockit = mac = coletaDTO.getMacAddress();
            }
            if (!TString.contains((String)eq.getChaveIdentificacao(), (String)uid) && !TString.contains((String)eq.getChaveIdentificacao(), (String)mac)) {
                throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.1949.001", new Object[]{mac, uid, eq}));
            }
            String string = lockit;
            synchronized (string) {
                List<ColetaDadosAtivo> coleta = this.gerarColeta(eq, coletaDTO);
                result.setResult(coleta);
                return result;
            }
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            if (saveArqCasoErro) {
                ArquivoDadosPendentes arq = new ArquivoDadosPendentes();
                arq.setDadosArquivo(input);
                arq.setEquipColetaDadosAtivoIOT(eq);
                arq.setDataCadastro(new Date());
                arq.setTipoArquivo(Short.valueOf(EnumConstDadosArquivoPendentes.IMPORTACAO_DADOS_EQUIP_IOT.getValue()));
                String msg = ToolException.getFullPrintStrack((Throwable)ex);
                if (msg.length() > 2000) {
                    msg = msg.substring(0, 2000);
                }
                arq.setMensagemErro(msg);
                this.serviceArquivoDadosPendentesImpl.saveOrUpdate(arq);
            }
            result.setOnError();
            return result;
        }
    }

    private List<ColetaDadosAtivo> gerarColeta(EquipColetaDadosAtivoIOT iot, DTOColetaDadosSmartFactory coletaDadosDTO) throws ExceptionObjNotFound {
        LinkedList<ColetaDadosAtivo> coletas = new LinkedList<ColetaDadosAtivo>();
        for (EquipColetaDadosAtivoSensorIOT itemSensor : iot.getItensColetaSensores()) {
            this.gerarColeta(iot, coletaDadosDTO, itemSensor, coletas);
        }
        return coletas;
    }

    void gerarColeta(EquipColetaDadosAtivoIOT iot, DTOColetaDadosSmartFactory dtoColeta, EquipColetaDadosAtivoSensorIOT sensor, List<ColetaDadosAtivo> coletas) throws ExceptionObjNotFound {
        DTOColetaDadosSmartFactory.SensorData sensorData = this.findDataSensor(dtoColeta, sensor);
        if (sensorData == null) {
            return;
        }
        Equipamento equipamentoMensurado = sensor.getEquipamento();
        EnumConstEquipColDadosAtTipoEvt tipoEvtColeta = EnumConstEquipColDadosAtTipoEvt.get((Object)sensor.getTipoEventoColeta());
        if (TMethods.isEquals((Object)tipoEvtColeta, (Object)EnumConstEquipColDadosAtTipoEvt.EVENTO_SIMPLES)) {
            if (sensorData.getValue() > 0.0) {
                this.novaColeta(dtoColeta, (short)1, coletas, equipamentoMensurado, iot, sensor, sensorData);
            }
            return;
        }
        ColetaDadosAtivo coleta = this.serviceColeta.getUltColetaAberta(this.getFormattedSensorId(sensorData), equipamentoMensurado, iot.getEquipamentoColeta());
        if (coleta == null && sensorData.getValue() <= 0.0) {
            return;
        }
        if (coleta == null && sensorData.getValue() > 0.0) {
            this.novaColeta(dtoColeta, (short)0, coletas, equipamentoMensurado, iot, sensor, sensorData);
            return;
        }
        if (coleta != null && sensorData.getValue() > 0.0) {
            Date dataColeta = coleta.getDataHoraPrimeiraColeta();
            Date dataColetaAtual = TDate.asDate((ZonedDateTime)dtoColeta.getDataColeta());
            int diaColeta = TDate.get((int)5, (Date)dataColeta);
            int diaColetaAtual = TDate.get((int)5, (Date)dataColetaAtual);
            if (TMethods.isEqualsNumber((Number)diaColeta, (Number)diaColetaAtual)) {
                this.atualizaColeta(coleta, dtoColeta, dataColetaAtual, coletas);
                return;
            }
            this.encerrarColeta(coleta, ToolDate.getLastDateOnDay((Date)dataColeta));
            dataColetaAtual = TDate.dataSemHora((Date)dataColetaAtual);
            this.novaColeta(dtoColeta, dataColetaAtual, (short)0, coletas, equipamentoMensurado, iot, sensor, sensorData);
            return;
        }
        if (coleta != null && sensorData.getValue() <= 0.0) {
            if (this.coletaDentroTolerancia(coleta, dtoColeta)) {
                return;
            }
            this.encerrarColeta(coleta, TDate.asDate((ZonedDateTime)dtoColeta.getDataColeta()));
            return;
        }
        throw new ExceptionErroProgramacao("Nao identificado como lidar com o tipo de evento. Ver arquivos pendentes de processamento para ver como proceder.");
    }

    private DTOColetaDadosSmartFactory.SensorData findDataSensor(DTOColetaDadosSmartFactory data, EquipColetaDadosAtivoSensorIOT itemSensor) {
        for (DTOColetaDadosSmartFactory.SensorData sensorData : data.getSensorData()) {
            String sensor = this.getFormattedSensorId(sensorData);
            if (!TMethods.isEquals((Object)this.compColetaDadosAtivo.getIdSensorFormatado(itemSensor.getIdentificacaoSensor()), (Object)sensor)) continue;
            return sensorData;
        }
        return null;
    }

    private String getFormattedSensorId(DTOColetaDadosSmartFactory.SensorData sensorData) {
        return this.compColetaDadosAtivo.getIdSensorFormatado(sensorData.getSlotIndex(), sensorData.getChanellIndex(), sensorData.getIotype());
    }

    void novaColeta(DTOColetaDadosSmartFactory dtoColeta, short statusColeta, List<ColetaDadosAtivo> coletas, Equipamento equipamentoMensurado, EquipColetaDadosAtivoIOT iot, EquipColetaDadosAtivoSensorIOT sensor, DTOColetaDadosSmartFactory.SensorData sensorData) throws ExceptionObjNotFound {
        this.novaColeta(dtoColeta, ToolDate.asDate((ZonedDateTime)dtoColeta.getDataColeta()), statusColeta, coletas, equipamentoMensurado, iot, sensor, sensorData);
    }

    void novaColeta(DTOColetaDadosSmartFactory dtoColeta, Date dataColeta, short statusColeta, List<ColetaDadosAtivo> coletas, Equipamento equipamentoMensurado, EquipColetaDadosAtivoIOT iot, EquipColetaDadosAtivoSensorIOT itemSensor, DTOColetaDadosSmartFactory.SensorData sensorData) throws ExceptionObjNotFound {
        ColetaDadosAtivo coleta = new ColetaDadosAtivo();
        coleta.setDataCadastro(new Date());
        coleta.setStatusColeta(Short.valueOf(statusColeta));
        coleta.setDataHoraPrimeiraColeta(dataColeta);
        coleta.setDataHoraUltColeta(dataColeta);
        coleta.setDataColeta(ToolDate.dataSemHora((Date)dataColeta));
        coleta.setIdentificacaoLeitura(dtoColeta.getDataColeta().toString());
        coleta.setCodigoColeta(dtoColeta.getCodigoColeta());
        coleta.setEquipColetaDadosAtivoIOT(iot);
        coleta.setEquipamento(equipamentoMensurado);
        EquipColetaDadosAtivoIOT equip = this.serviceEquipColeta.getOrThrowByEquipamento(iot.getEquipamentoColeta());
        coleta.setEquipColetaDadosAtivoIOT(equip);
        if (coleta.getEquipamento().getEmpresaProprietaria() != null) {
            coleta.setEmpresa(this.serviceEmpresa.get(coleta.getEquipamento().getEmpresaProprietaria()));
        } else {
            coleta.setEmpresa(coleta.getEquipamento().getEmpresa());
        }
        coleta.setIdentificacaoSensor(itemSensor.getIdentificacaoSensor());
        coleta.setValorColetado(sensorData.getValue());
        coleta.setTipoColetaDadosAtivo(itemSensor.getTipoColetaDados());
        coleta.setEquipColetaDadosAtSensorIOT(itemSensor);
        coleta.setContadorColetas(Integer.valueOf(1));
        coleta = this.serviceColeta.saveOrUpdateFlush(coleta);
        coletas.add(coleta);
    }

    void atualizaColeta(ColetaDadosAtivo coleta, DTOColetaDadosSmartFactory dtoColeta, Date dataColetaAtual, List<ColetaDadosAtivo> coletas) {
        coleta.setDataHoraUltColeta(dataColetaAtual);
        coleta.setContadorColetas(Integer.valueOf(coleta.getContadorColetas() + 1));
        coleta.setTempoDuracaoColeta(Double.valueOf(ToolDate.difBetweenDatesInHoursNumber((Date)coleta.getDataHoraPrimeiraColeta(), (Date)coleta.getDataHoraUltColeta())));
        coleta.setTempoMedioColeta(Double.valueOf(coleta.getTempoDuracaoColeta() / (double)coleta.getContadorColetas().intValue()));
        coleta = this.serviceColeta.saveOrUpdateFlush(coleta);
        coletas.add(coleta);
    }

    ColetaDadosAtivo encerrarColeta(ColetaDadosAtivo coleta, Date dataColeta) {
        coleta.setStatusColeta(Short.valueOf((short)1));
        coleta.setDataHoraUltColeta(dataColeta);
        coleta.setTempoDuracaoColeta(TDate.calcularDifHoras((Date)coleta.getDataHoraPrimeiraColeta(), (Date)coleta.getDataHoraUltColeta()));
        if (coleta.getContadorColetas() > 0) {
            coleta.setTempoMedioColeta(Double.valueOf(coleta.getTempoDuracaoColeta() / (double)coleta.getContadorColetas().intValue()));
        }
        return this.serviceColeta.saveOrUpdateFlush(coleta);
    }

    private void gerarLogFiles(String input) {
    }

    private boolean coletaDentroTolerancia(ColetaDadosAtivo coleta, DTOColetaDadosSmartFactory dtoColeta) {
        if (coleta.getEquipColetaDadosAtSensorIOT() == null || !ToolMethods.isWithData((Number)coleta.getEquipColetaDadosAtSensorIOT().getToleranciaAltSinal())) {
            return false;
        }
        Date dataColeta = coleta.getDataHoraPrimeiraColeta();
        Date dataColetaAtual = TDate.asDate((ZonedDateTime)dtoColeta.getDataColeta());
        return dataColetaAtual.getTime() - dataColeta.getTime() <= (long)coleta.getEquipColetaDadosAtSensorIOT().getToleranciaAltSinal().intValue();
    }
}

