/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.coletadadosativo;

import com.touchcomp.basementor.model.vo.ColetaDadosAtivo;
import com.touchcomp.basementor.model.vo.EquipColetaDadosAtivoSensorIOT;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.TipoColetaDadosAtivo;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.coletadadosativo.CompColetaDadosAtivo;
import com.touchcomp.basementorservice.dao.impl.DaoColetaDadosAtivoImpl;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapColetaDadosDiariaIOT;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.arquivodadospendentes.ServiceArquivoDadosPendentesImpl;
import com.touchcomp.basementorservice.service.impl.coletadadosativo.ServiceProcColetaInfoImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.equipcoletadadosativoiot.ServiceEquipColetaDadosAtivoIOTImpl;
import com.touchcomp.basementorservice.service.impl.smartcomponente.ServiceBuildSmartComponentImpl;
import com.touchcomp.basementorservice.service.impl.tipocoletadadosativo.ServiceTipoColetaDadosAtivoImpl;
import com.touchcomp.touchvomodel.vo.coletadadosativo.web.DTOColetaDadosAtivoInfo;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ServiceColetaDadosAtivoImpl
extends ServiceGenericEntityImpl<ColetaDadosAtivo, Long, DaoColetaDadosAtivoImpl> {
    ServiceArquivoDadosPendentesImpl serviceArquivoDadosPendentesImpl;
    ServiceEquipColetaDadosAtivoIOTImpl serviceEquipColeta;
    ServiceBuildSmartComponentImpl serviceBuildSmartComponent;
    ServiceEmpresaImpl serviceEmpresa;
    ServiceTipoColetaDadosAtivoImpl serviceTipoColeta;
    CompColetaDadosAtivo compColetaDadosAtivo;
    ServiceProcColetaInfoImpl serviceProcColetaInfoImpl;

    public ServiceColetaDadosAtivoImpl(DaoColetaDadosAtivoImpl dao, ServiceArquivoDadosPendentesImpl serviceArquivoDadosPendentesImpl, ServiceEquipColetaDadosAtivoIOTImpl serviceEquipColeta, ServiceBuildSmartComponentImpl serviceBuildSmartComponent, ServiceEmpresaImpl serviceEmpresa, ServiceTipoColetaDadosAtivoImpl serviceTipoColeta, CompColetaDadosAtivo compColetaDadosAtivo, ServiceProcColetaInfoImpl serviceProcColetaInfoImpl) {
        super(dao);
        this.serviceArquivoDadosPendentesImpl = serviceArquivoDadosPendentesImpl;
        this.serviceEquipColeta = serviceEquipColeta;
        this.serviceBuildSmartComponent = serviceBuildSmartComponent;
        this.serviceEmpresa = serviceEmpresa;
        this.serviceTipoColeta = serviceTipoColeta;
        this.compColetaDadosAtivo = compColetaDadosAtivo;
        this.serviceProcColetaInfoImpl = serviceProcColetaInfoImpl;
    }

    @Override
    public ColetaDadosAtivo beforeSaveEntity(ColetaDadosAtivo aux) {
        return aux;
    }

    @Override
    public ColetaDadosAtivo afterSaveEntity(ColetaDadosAtivo coleta) {
        return coleta;
    }

    public DTOColetaDadosAtivoInfo getTipoColetaDadosAtivoInfo(Long idTipoColeta) throws ExceptionObjNotFound {
        TipoColetaDadosAtivo tp = (TipoColetaDadosAtivo)this.serviceTipoColeta.get(idTipoColeta);
        if (tp == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.1954.001", new Object[]{idTipoColeta}));
        }
        DTOColetaDadosAtivoInfo ret = new DTOColetaDadosAtivoInfo();
        ret.setTipoColetaDadosAtivoIdentificador(tp.getIdentificador());
        ret.setTipoColetaDadosAtivo(tp.getDescricao());
        return ret;
    }

    public synchronized void reprocessarColetasPendentes() {
        List<ColetaDadosAtivo> coletas = ((DaoColetaDadosAtivoImpl)this.getDao()).getColetasProcPendente();
        for (ColetaDadosAtivo col : coletas) {
            this.serviceProcColetaInfoImpl.processarColetaSensoresErro(col);
            this.saveOrUpdateOnly(col);
        }
    }

    public ColetaDadosAtivo getUltColetaAberta(String sensor, Equipamento equipamentoMensurado, Equipamento equipamentoColeta) {
        return ((DaoColetaDadosAtivoImpl)this.getDao()).getUltColetaAberta(sensor, equipamentoMensurado, equipamentoColeta);
    }

    public List<GenericMapValues<GenMapColetaDadosDiariaIOT>> getColetasDiarias(EquipColetaDadosAtivoSensorIOT sensorIOT, Date dataInicial, Date dataFinal) {
        return ((DaoColetaDadosAtivoImpl)this.getDao()).getColetasDiarias(sensorIOT, dataInicial, dataFinal);
    }
}

