/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.coletadadosativo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.model.vo.ColetaDadosAtivo;
import com.touchcomp.basementor.model.vo.EquipColetaDadosAtivoProcIOT;
import com.touchcomp.basementor.model.vo.SmartComponentPref;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIDefaultParams;
import com.touchcomp.basementorservice.components.businessintelligence.model.DefaultBIParamsMap;
import com.touchcomp.basementorservice.service.impl.smartcomponente.BaseSmartComponenteResult;
import com.touchcomp.basementorservice.service.impl.smartcomponente.ServiceBuildSmartComponentImpl;
import com.touchcomp.basementorservice.service.impl.smartcomponente.voresult.InterfaceSCResult;
import com.touchcomp.basementorservice.tasks.TaskCreator;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.HashMap;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.REQUIRES_NEW)
public class ServiceProcColetaInfoImpl {
    private final ServiceBuildSmartComponentImpl serviceBuildSmartComponent;

    public ServiceProcColetaInfoImpl(ServiceBuildSmartComponentImpl serviceBuildSmartComponent) {
        this.serviceBuildSmartComponent = serviceBuildSmartComponent;
    }

    public void processarColetaSensoresErro(ColetaDadosAtivo coleta) {
        if (!TMethods.isEquals((Object)EnumConstantsMentorStatus.get((Object)coleta.getStatusProcessamento()), (Object)EnumConstantsMentorStatus.SUCESSO)) {
            this.processarColetaSensores(coleta);
        }
    }

    public void processarColetaSensores(ColetaDadosAtivo coleta) {
        if (coleta.getEquipColetaDadosAtSensorIOT() == null) {
            return;
        }
        this.processarItens(coleta);
    }

    private void processarItens(ColetaDadosAtivo coleta) {
        for (EquipColetaDadosAtivoProcIOT eq : coleta.getEquipColetaDadosAtSensorIOT().getItensProcessamento()) {
            if (eq.getSmartComponente() == null) continue;
            SmartComponentPref smart = eq.getSmartComponente();
            try {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("P_COLETA_DADOS_ATIVO", coleta);
                params.put("P_COLETA_DADOS_ATIVO_INFO_SENSOR_PROC", eq);
                BaseSmartComponenteResult<InterfaceSCResult> ret = this.serviceBuildSmartComponent.buildSC(smart, (DefaultBIParamsMap<String, Object>)CompBIDefaultParams.getDefParamsMap(params), new TaskCreator.TaskProgress());
                if (ret != null && !ret.getStatus().isOk()) {
                    coleta.setStatusProcessamento(Short.valueOf(EnumConstantsMentorStatus.ERRO.getValue()));
                    coleta.setObservacao(ret.getMensagem());
                    continue;
                }
                coleta.setStatusProcessamento(Short.valueOf(EnumConstantsMentorStatus.SUCESSO.getValue()));
            }
            catch (Exception ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
                coleta.setStatusProcessamento(Short.valueOf(EnumConstantsMentorStatus.ERRO.getValue()));
                coleta.setObservacao(ex.getMessage());
            }
        }
    }
}

