/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.comunicadoproducao;

import com.touchcomp.basementor.constants.enums.celulaprodutiva.EnumConstCelulaProdTipoCusto;
import com.touchcomp.basementor.constants.enums.formulacaoprodutos.EnumConstTipoRateioDesmProdConjunta;
import com.touchcomp.basementor.constants.enums.tipoitemsped.EnumConstTipoItemSped;
import com.touchcomp.basementor.constants.enums.tipoproducaosped.EnumConstTipoProducaoSped;
import com.touchcomp.basementor.model.interfaces.InterfaceStaticObjects;
import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.EventoOsProdSobEnc;
import com.touchcomp.basementor.model.vo.EventoOsProducaoLinhaProd;
import com.touchcomp.basementor.model.vo.GradeItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemComposicaoCusto;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.OrdemServicoProdSobEnc;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoComunicadoProducaoImpl;
import com.touchcomp.basementorservice.dao.impl.DaoEventoOsProdSobEncImpl;
import com.touchcomp.basementorservice.service.impl.celulaprodutiva.ServiceCelulaProdutivaImpl;
import com.touchcomp.basementorservice.service.impl.centroestoque.ServiceCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.composicaocustos.AuxAvaliaCompCustosColaborador;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.composicaocustos.AuxAvaliaCompCustosFaseProdutiva;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.composicaocustos.AuxAvaliaCompCustosOutrosCustos;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.composicaocustos.AuxAvaliaCompCustosRequisicao;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.modelaux.VOColaboradorEvt;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.modelaux.VOFaseProdutivaEvt;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.modelaux.VOProdutosRequisicaoEvt;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.roteiroproducao.ServiceFaseProdutivaImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceAnaliseComposicaoCustosComProdImpl {
    private final ServiceSaldoEstoqueImpl serviceSaldoEstoque;
    private final ServiceCelulaProdutivaImpl serviceCelulaProd;
    private final DaoEventoOsProdSobEncImpl daoEventoOsProdSobEncImpl;
    private final InterfaceStaticObjects sharedData;
    private final DaoComunicadoProducaoImpl daoComunicadoProducaoImpl;
    private final ServiceColaboradorImpl serviceColaboradorImpl;
    private final ServiceFaseProdutivaImpl serviceFaseProdutivaImpl;
    private final ServiceGradeCorImpl serviceGradeCorImpl;
    private final ServiceCentroEstoqueImpl serviceCentroEstoqueImpl;

    public ServiceAnaliseComposicaoCustosComProdImpl(ServiceSaldoEstoqueImpl serviceSaldoEstoque, ServiceCelulaProdutivaImpl serviceCelulaProd, InterfaceStaticObjects sharedData, DaoComunicadoProducaoImpl daoComunicadoProducaoImpl, DaoEventoOsProdSobEncImpl serviceEventoOsProdSobEncImpl, ServiceColaboradorImpl serviceColaboradorImpl, ServiceFaseProdutivaImpl serviceFaseProdutivaImpl, ServiceGradeCorImpl serviceGradeCorImpl, ServiceCentroEstoqueImpl serviceCentroEstoqueImpl) {
        this.serviceColaboradorImpl = serviceColaboradorImpl;
        this.serviceSaldoEstoque = serviceSaldoEstoque;
        this.serviceCelulaProd = serviceCelulaProd;
        this.sharedData = sharedData;
        this.daoComunicadoProducaoImpl = daoComunicadoProducaoImpl;
        this.daoEventoOsProdSobEncImpl = serviceEventoOsProdSobEncImpl;
        this.serviceFaseProdutivaImpl = serviceFaseProdutivaImpl;
        this.serviceGradeCorImpl = serviceGradeCorImpl;
        this.serviceCentroEstoqueImpl = serviceCentroEstoqueImpl;
    }

    public void avaliarValorCustoLinhaProducao(EventoOsProducaoLinhaProd evt) {
        this.avaliarValorCustoLinhaProducao(evt.getComunicadoProducao(), evt);
    }

    public void avaliarValorCustoPCP(List<ComunicadoProducao> com) throws ExceptionObjNotFound {
        for (ComunicadoProducao comunicadoProducao : com) {
            this.avaliarValorCustoPCP(comunicadoProducao);
        }
    }

    public void avaliarValorCustoPCP(ComunicadoProducao com) throws ExceptionObjNotFound {
        if (com.getEventoOsProducao() != null) {
            this.avaliarValorCustoLinhaProducao(com, com.getEventoOsProducao());
        } else if (com.getOrdemServicoProdSobEnc() != null) {
            this.avaliarValorCustoSobEnc(com, com.getOrdemServicoProdSobEnc());
        } else {
            this.avaliarValorCustoLinhaProducao(com, null);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void avaliarValorCustoLinhaProducaoESalvarCom(Long idCom) {
        ComunicadoProducao com = (ComunicadoProducao)this.daoComunicadoProducaoImpl.get(idCom);
        this.avaliarValorCustoLinhaProducao(com, com.getEventoOsProducao());
        this.daoComunicadoProducaoImpl.saveOrUpdate(com);
    }

    public void avaliarValorCustoLinhaProducao(ComunicadoProducao com, EventoOsProducaoLinhaProd evt) {
        if (com == null) {
            return;
        }
        OpcoesPCP opcoesPCP = this.sharedData.getOpcoesPCP(com.getEmpresa());
        EnumConstCelulaProdTipoCusto tipoCusto = EnumConstCelulaProdTipoCusto.get((Short)opcoesPCP.getTipoPesqCustoHoraCel());
        if (evt != null) {
            com.setDataFinal(evt.getDataFechamento());
        }
        EnumConstTipoProducaoSped tipoProd = EnumConstTipoProducaoSped.get((Object)com.getTipoProducaoSped().getCodigo());
        this.calcularPercentuaisRateioDesmProdConj(com, tipoProd);
        for (ItemComunicadoProducao it : com.getItemComunicadoProducao()) {
            LinkedList<ItemComposicaoCusto> aux = it.getItemComposicaoCusto();
            if (aux == null) {
                aux = new LinkedList<ItemComposicaoCusto>();
                it.setItemComposicaoCusto(aux);
            }
            this.zerarValoresItemCompCusto(it);
            new AuxAvaliaCompCustosOutrosCustos(aux).getItemComposicaoCustoOutrosCustos(it, com.getDataFinal(), com.getEmpresa());
            if (com.getRequisicao() != null) {
                new AuxAvaliaCompCustosRequisicao(aux, this.serviceSaldoEstoque, this.serviceGradeCorImpl, this.serviceCentroEstoqueImpl).getItemCompCustoRequisicao(ToolMethods.toList((Object[])new Object[]{com.getRequisicao()}), it, com.getDataFinal());
            } else {
                new AuxAvaliaCompCustosRequisicao(aux, this.serviceSaldoEstoque, this.serviceGradeCorImpl, this.serviceCentroEstoqueImpl).getItemCompCustoRequisicao(it.getRequisicoes(), it, com.getDataFinal());
            }
            if (evt != null) {
                new AuxAvaliaCompCustosColaborador(aux, this.serviceColaboradorImpl).getItemComposicaoCustoColaborador(evt, it);
                new AuxAvaliaCompCustosFaseProdutiva(this.serviceCelulaProd, aux, this.serviceFaseProdutivaImpl).getItemComposicaoCustoFaseProd(evt.getFaseProdutiva(), it, com.getDataFinal(), evt.getHoraEvento(), tipoCusto);
            }
            this.tratativasDesmanche(com, it, tipoProd);
            this.setSetValorCusto(it);
        }
    }

    public void avaliarValorCustoSobEnc(ComunicadoProducao com, OrdemServicoProdSobEnc osSobEnc) throws ExceptionObjNotFound {
        if (com == null) {
            return;
        }
        for (ItemComunicadoProducao itemComunicadoProducao : com.getItemComunicadoProducao()) {
            this.avaliarValorCustoSobEnc(itemComunicadoProducao, osSobEnc);
        }
    }

    public ItemComunicadoProducao avaliarValorCustoSobEnc(ItemComunicadoProducao item, OrdemServicoProdSobEnc osSobEnc) throws ExceptionObjNotFound {
        if (item == null) {
            return item;
        }
        OpcoesPCP opcoesPCP = this.sharedData.getOpcoesPCP(item.getComunicadoProducao().getEmpresa());
        EnumConstCelulaProdTipoCusto tipoCusto = EnumConstCelulaProdTipoCusto.get((Short)opcoesPCP.getTipoPesqCustoHoraCel());
        EnumConstTipoProducaoSped tipoProd = EnumConstTipoProducaoSped.get((Object)item.getComunicadoProducao().getTipoProducaoSped().getCodigo());
        this.calcularPercentuaisRateioDesmProdConj(item.getComunicadoProducao(), tipoProd);
        for (ItemComunicadoProducao it : item.getComunicadoProducao().getItemComunicadoProducao()) {
            LinkedList<ItemComposicaoCusto> aux = it.getItemComposicaoCusto();
            if (aux == null) {
                aux = new LinkedList<ItemComposicaoCusto>();
                it.setItemComposicaoCusto(aux);
            }
            this.zerarValoresItemCompCusto(it);
            new AuxAvaliaCompCustosOutrosCustos(aux).getItemComposicaoCustoOutrosCustos(it, item.getComunicadoProducao().getDataFinal(), item.getComunicadoProducao().getEmpresa());
            List<VOFaseProdutivaEvt> evtsFase = this.daoEventoOsProdSobEncImpl.getEventosVOFase(osSobEnc);
            List<VOColaboradorEvt> evtsColab = this.daoEventoOsProdSobEncImpl.getEventosVOColaborador(osSobEnc);
            List<VOProdutosRequisicaoEvt> evtsReq = this.daoEventoOsProdSobEncImpl.getEventosVOProduto(it);
            new AuxAvaliaCompCustosRequisicao(aux, this.serviceSaldoEstoque, this.serviceGradeCorImpl, this.serviceCentroEstoqueImpl).getItemCompCustoRequisicao(evtsReq, it);
            new AuxAvaliaCompCustosColaborador(aux, this.serviceColaboradorImpl).getItemComposicaoCustoColaboradorDTO(evtsColab, it);
            new AuxAvaliaCompCustosFaseProdutiva(this.serviceCelulaProd, aux, this.serviceFaseProdutivaImpl).getItemComposicaoCustoFaseProd(it, tipoCusto, evtsFase);
            this.setSetValorCusto(it);
            it.setItemComposicaoCusto(aux);
        }
        return item;
    }

    private double setSetValorCusto(ItemComunicadoProducao it) {
        double valorCusto = 0.0;
        double valorCustoIndireto = 0.0;
        double valorCustoProcesso = 0.0;
        double valorCustoOutros = 0.0;
        double valorCustoMatPrima = 0.0;
        for (ItemComposicaoCusto itc : it.getItemComposicaoCusto()) {
            valorCusto += itc.getValorInicial().doubleValue();
            if (itc.getColaborador() != null) {
                valorCustoMatPrima += itc.getValorInicial().doubleValue();
            }
            if (itc.getProduto() != null) {
                if (TMethods.isEquals((Object)itc.getProduto().getTipoIemSped().getTipoItemAnaliseCusto(), (Object)EnumConstTipoItemSped.MATERIAIS_DIRETOS.getValue())) {
                    valorCustoMatPrima += itc.getValorInicial().doubleValue();
                } else {
                    valorCustoProcesso += itc.getValorInicial().doubleValue();
                }
            }
            if (itc.getFaseProdutiva() != null) {
                valorCustoIndireto += itc.getValorInicial().doubleValue();
            }
            if (itc.getItemOutrosCustos() == null) continue;
            valorCustoOutros += itc.getValorInicial().doubleValue();
        }
        it.setValorCustoEmProcesso(Double.valueOf(valorCustoProcesso));
        it.setValorCustoIndireto(Double.valueOf(valorCustoIndireto));
        it.setValorCustoMatPrima(Double.valueOf(valorCustoMatPrima));
        it.setValorOutrosCustos(Double.valueOf(valorCustoOutros));
        it.setValorCustoTotal(Double.valueOf(valorCusto + it.getValorAdCusto()));
        if (TMethods.isWithData((Number)it.getValorCustoTotal()) && TMethods.isWithData((Number)it.getQuantidadeTotal())) {
            double temp = it.getValorCustoTotal() / it.getQuantidadeTotal();
            for (GradeItemComunicadoProducao gr : it.getGradeItemComunicadoProducao()) {
                gr.setValorUnitario(Double.valueOf(temp));
            }
        }
        return valorCusto;
    }

    private void tratativasDesmanche(ComunicadoProducao com, ItemComunicadoProducao it, EnumConstTipoProducaoSped tipoProd) {
        if (!tipoProd.isDesmancheOuProdConjunt()) {
            it.setPercentualCustoDesmancheConsiderado(Double.valueOf(100.0));
            it.setPercentualCustoDesmanche(Double.valueOf(100.0));
            return;
        }
        for (ItemComposicaoCusto itemComp : it.getItemComposicaoCusto()) {
            Double perc = it.getPercentualCustoDesmancheConsiderado();
            if (!ToolMethods.isWithData((Number)perc)) {
                perc = it.getPercentualCustoDesmanche();
            }
            itemComp.setValorInicial(Double.valueOf(itemComp.getValorInicial() * perc / 100.0));
        }
    }

    private void calcularPercentuaisRateioDesmProdConj(ComunicadoProducao com, EnumConstTipoProducaoSped tipoProd) {
        if (!tipoProd.isDesmancheOuProdConjunt()) {
            return;
        }
        if (TMethods.isEquals((Object)com.getTipoRateioDesmProdConjunta(), (Object)EnumConstTipoRateioDesmProdConjunta.QUANTIDADE_INFORMADA.getCodigo())) {
            double totalQtd = com.getItemComunicadoProducao().stream().mapToDouble(i -> i.getQuantidadeTotal()).sum();
            for (ItemComunicadoProducao item : com.getItemComunicadoProducao()) {
                item.setPercentualCustoDesmanche(Double.valueOf(item.getQuantidadeTotal() / totalQtd * 100.0));
                item.setPercentualCustoDesmancheConsiderado(Double.valueOf(item.getQuantidadeTotal() / totalQtd * 100.0));
            }
        }
    }

    private void zerarValoresItemCompCusto(ItemComunicadoProducao it) {
        for (ItemComposicaoCusto itemComposicaoCusto : it.getItemComposicaoCusto()) {
            itemComposicaoCusto.setQuantidadeRef(Double.valueOf(0.0));
            itemComposicaoCusto.setValorInicial(Double.valueOf(0.0));
            itemComposicaoCusto.setPrecoMedio(Double.valueOf(0.0));
            itemComposicaoCusto.setValorReal(Double.valueOf(0.0));
        }
    }

    void reprocessaCustoRemEvt(ItemComunicadoProducao itemComunicadoProducao, EventoOsProdSobEnc entity) {
    }
}

