/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.comunicadoproducao;

import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IntegComuProdEspecie;
import com.touchcomp.basementor.model.vo.IntegComuProdSubEspecie;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoComunicadoProducaoImpl;
import com.touchcomp.basementorservice.helpers.impl.comunicadoproducao.HelperComunicadoProducao;
import com.touchcomp.basementorservice.helpers.impl.comunicadoproducao.HelperItemComunicadoProducao;
import com.touchcomp.basementorservice.helpers.impl.requisicao.HelperRequisicao;
import com.touchcomp.basementorservice.helpers.impl.wmsentradaprodutos.HelperWmsEntradaProdutos;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.ServiceAnaliseComposicaoCustosComProdImpl;
import com.touchcomp.touchvomodel.vo.lotefabricacao.web.DTORastreioLoteFabricacao;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceComunicadoProducaoImpl
extends ServiceGenericEntityImpl<ComunicadoProducao, Long, DaoComunicadoProducaoImpl> {
    HelperWmsEntradaProdutos wmsEntradaProdutos;
    HelperRequisicao helperRequisicao;
    HelperItemComunicadoProducao helperItemComunicadoProducao;
    HelperComunicadoProducao helperComunicadoProducao;
    ServiceAnaliseComposicaoCustosComProdImpl serviceAnaliseComposicaoCustosComProdImpl;

    @Autowired
    public ServiceComunicadoProducaoImpl(DaoComunicadoProducaoImpl genericDao, HelperWmsEntradaProdutos wmsEntradaProdutos, HelperRequisicao helperRequisicao, HelperItemComunicadoProducao helperItemComunicadoProducao, HelperComunicadoProducao helperComunicadoProducao, ServiceAnaliseComposicaoCustosComProdImpl serviceAnaliseComposicaoCustosComProdImpl) {
        super(genericDao);
        this.wmsEntradaProdutos = wmsEntradaProdutos;
        this.helperRequisicao = helperRequisicao;
        this.helperItemComunicadoProducao = helperItemComunicadoProducao;
        this.helperComunicadoProducao = helperComunicadoProducao;
        this.serviceAnaliseComposicaoCustosComProdImpl = serviceAnaliseComposicaoCustosComProdImpl;
    }

    public Double getUltimoCusto(Produto produto, Empresa empresa) {
        return this.getUltimoCusto(produto.getIdentificador(), empresa.getIdentificador());
    }

    public Double getUltimoCusto(Long idProduto, Long idEmpresa) {
        return ((DaoComunicadoProducaoImpl)this.getDao()).getUltimoCusto(idProduto, idEmpresa);
    }

    public Double getUltimoCusto(Long idProduto, Long idEmpresa, Date dataBase) {
        return ((DaoComunicadoProducaoImpl)this.getDao()).getUltimoCusto(idProduto, idEmpresa);
    }

    public Double getUltimoCusto(Long idProduto) {
        return ((DaoComunicadoProducaoImpl)this.getDao()).getUltimoCusto(idProduto);
    }

    public Double getUltimoCusto(Long idProduto, Date dataBase) {
        return ((DaoComunicadoProducaoImpl)this.getDao()).getUltimoCusto(idProduto, dataBase);
    }

    public List<ComunicadoProducao> getComunicadosProducaoPorPeriodo(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesContabeis opcoesContabeis, List<IntegComuProdSubEspecie> listSubEspecie, List<IntegComuProdEspecie> listEspecie) {
        return ((DaoComunicadoProducaoImpl)this.getDao()).getComunicadosProducaoPorPeriodo(dataInicial, dataFinal, empresa, opcoesContabeis, listSubEspecie, listEspecie);
    }

    @Override
    public ComunicadoProducao beforeSaveEntity(ComunicadoProducao aux) {
        try {
            this.helperComunicadoProducao.beforeSave(aux);
            this.helperItemComunicadoProducao.calcularTotais(aux.getItemComunicadoProducao());
            aux.getItemComunicadoProducao().forEach(ic -> ic.getRequisicoes().forEach(r -> this.helperRequisicao.beforeSave((Requisicao)r)));
            aux.setWmsEntradaEstoque(this.wmsEntradaProdutos.getWmsEntrada(aux, this.getSharedData().getWmsOpcoes(aux.getEmpresa())));
            this.serviceAnaliseComposicaoCustosComProdImpl.avaliarValorCustoPCP(aux);
            return super.beforeSave(aux);
        }
        catch (ExceptionInvalidState | ExceptionObjNotFound ex) {
            this.logError(ex);
            throw new ExceptionRuntimeBase((ExceptionBase)ex);
        }
    }

    @Override
    public ComunicadoProducao saveOrUpdateOnly(ComunicadoProducao entity) {
        if (this.isNull(entity).booleanValue()) {
            return null;
        }
        return ((DaoComunicadoProducaoImpl)this.getGenericDao()).saveOrUpdate(entity);
    }

    public List<DTORastreioLoteFabricacao> rastreioLoteComunicadoProducao(Date dataInicial, Date dataFinal, List lotes, Long produtoInicial, Long produtoFinal) {
        return ((DaoComunicadoProducaoImpl)this.getGenericDao()).rastreioLoteComunicadoProducao(dataInicial, dataFinal, lotes, produtoInicial, produtoFinal);
    }

    public void reprocessarItemCompCusto(Date dataIn, Date dataFim, Empresa logedEmpresa) {
        int page = 0;
        int regs = 100;
        List<Long> idsCom = null;
        do {
            idsCom = ((DaoComunicadoProducaoImpl)this.getDao()).getComunicadosProducaoPorPeriodo(dataIn, dataFim, logedEmpresa, page, regs);
            for (Long idCom : idsCom) {
                this.serviceAnaliseComposicaoCustosComProdImpl.avaliarValorCustoLinhaProducaoESalvarCom(idCom);
            }
            page += regs;
        } while (idsCom != null && !idsCom.isEmpty());
    }
}

