/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.comunicadoproducao.composicaocustos;

import com.touchcomp.basementor.model.vo.ColabEvtOsProdLinhaProd;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EventoOsProducaoLinhaProd;
import com.touchcomp.basementor.model.vo.ItemComposicaoCusto;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.composicaocustos.AuxBaseAvaliaCompCustos;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.modelaux.VOColaboradorEvt;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class AuxAvaliaCompCustosColaborador
extends AuxBaseAvaliaCompCustos {
    private final List<ItemComposicaoCusto> itensComposicaoCusto;
    private ServiceColaboradorImpl serviceColaboradorImpl;

    public AuxAvaliaCompCustosColaborador(List<ItemComposicaoCusto> composicoesCusto, ServiceColaboradorImpl serviceColaboradorImpl) {
        this.itensComposicaoCusto = composicoesCusto;
        this.serviceColaboradorImpl = serviceColaboradorImpl;
    }

    public void getItemComposicaoCustoColaborador(EventoOsProducaoLinhaProd e, ItemComunicadoProducao it) {
        LinkedList<ItemComposicaoCusto> itensProcessados = new LinkedList<ItemComposicaoCusto>();
        for (ColabEvtOsProdLinhaProd colabEvt : e.getColaboradoresEvtProd()) {
            ItemComposicaoCusto io;
            Optional<ItemComposicaoCusto> found = this.itensComposicaoCusto.stream().filter(i -> this.isEquals((ItemComposicaoCusto)i, colabEvt, e)).findFirst();
            if (found.isPresent()) {
                io = found.get();
            } else {
                io = this.newItemComposicaoCusto(e.getEmpresa(), e.getDataFechamento());
                io.setColaborador(colabEvt.getColaborador());
                this.itensComposicaoCusto.add(io);
            }
            io.setDataReferencia(ToolDate.dataSemHora((Date)e.getDataAbertura()));
            io.setValorInicial(Double.valueOf(0.0));
            io.setValorReal(Double.valueOf(0.0));
            io.setItemComProducao(it);
            io.setQuantidadeRef(Double.valueOf(io.getQuantidadeRef() + e.getHoraEvento()));
            this.calcularValorHora(io);
            itensProcessados.add(io);
        }
        this.processarRemoverItensNProcessados(this.itensComposicaoCusto, itensProcessados);
    }

    public void getItemComposicaoCustoColaboradorDTO(List<VOColaboradorEvt> eventos, ItemComunicadoProducao it) throws ExceptionObjNotFound {
        LinkedList<ItemComposicaoCusto> itensProcessados = new LinkedList<ItemComposicaoCusto>();
        for (VOColaboradorEvt evt : eventos) {
            ItemComposicaoCusto io;
            Optional<ItemComposicaoCusto> found = this.itensComposicaoCusto.stream().filter(i -> this.isEquals((ItemComposicaoCusto)i, evt)).findFirst();
            if (found.isPresent()) {
                io = found.get();
            } else {
                io = this.newItemComposicaoCusto(it.getComunicadoProducao().getEmpresa(), evt.getDataFechamento());
                io.setColaborador((Colaborador)this.serviceColaboradorImpl.getOrThrow(evt.getColaboradorIdentificador()));
                this.itensComposicaoCusto.add(io);
            }
            if (ToolMethods.isNotNull((Object)evt.getDataFechamento()).booleanValue()) {
                io.setDataReferencia(ToolDate.dataSemHora((Date)evt.getDataFechamento()));
            }
            io.setValorInicial(Double.valueOf(0.0));
            io.setValorReal(Double.valueOf(0.0));
            io.setItemComProducao(it);
            io.setQuantidadeRef(Double.valueOf(io.getQuantidadeRef() + evt.getHoraEvento()));
            this.calcularValorHora(io);
            itensProcessados.add(io);
        }
        this.processarRemoverItensNProcessados(this.itensComposicaoCusto, itensProcessados);
    }

    private void processarRemoverItensNProcessados(List<ItemComposicaoCusto> itensComposicaoCusto, List<ItemComposicaoCusto> itensProcessados) {
        LinkedList<ItemComposicaoCusto> toRem = new LinkedList<ItemComposicaoCusto>();
        for (ItemComposicaoCusto item : itensComposicaoCusto) {
            Optional<ItemComposicaoCusto> found = itensProcessados.stream().filter(i -> this.isEquals(item, (ItemComposicaoCusto)i)).findFirst();
            if (found.isPresent() || item.getColaborador() == null) continue;
            toRem.add(item);
        }
        itensComposicaoCusto.removeAll(toRem);
    }

    private void calcularValorHora(ItemComposicaoCusto io) {
        if (io.getColaborador().getValorPorHora() == null) {
            return;
        }
        double valorHora = (io.getColaborador().getValorPorHora() * 1.0 + io.getColaborador().getValorTributosPorHora()) * io.getQuantidadeRef();
        io.setValorInicial(Double.valueOf(valorHora));
    }

    private boolean isEquals(Long colaborador, Long colaborador0, Date dataRef, Date dataRef0) {
        return TMethods.isEquals((Object)colaborador, (Object)colaborador0) && TMethods.isEquals((Object)TDate.dataSemHora((Date)dataRef), (Object)TDate.dataSemHora((Date)dataRef0));
    }

    private boolean isEquals(ItemComposicaoCusto i, ColabEvtOsProdLinhaProd colabEvt, EventoOsProducaoLinhaProd e) {
        Long idColab1 = 0L;
        Long idColab2 = 0L;
        if (i.getColaborador() != null) {
            idColab1 = i.getColaborador().getIdentificador();
        }
        if (colabEvt.getColaborador() != null) {
            idColab2 = colabEvt.getColaborador().getIdentificador();
        }
        return this.isEquals(idColab1, idColab2, i.getDataReferencia(), e.getDataFechamento());
    }

    private boolean isEquals(ItemComposicaoCusto item, ItemComposicaoCusto i) {
        Long idColab1 = 0L;
        Long idColab2 = 0L;
        if (i.getColaborador() != null) {
            idColab1 = i.getColaborador().getIdentificador();
        }
        if (item.getColaborador() != null) {
            idColab2 = item.getColaborador().getIdentificador();
        }
        if (ToolMethods.isNull((Object)item.getDataReferencia()).booleanValue() || ToolMethods.isNull((Object)i.getDataReferencia()).booleanValue()) {
            return false;
        }
        return this.isEquals(idColab1, idColab2, i.getDataReferencia(), item.getDataReferencia());
    }

    private boolean isEquals(ItemComposicaoCusto i, VOColaboradorEvt item) {
        Long idColab1 = 0L;
        Long idColab2 = 0L;
        if (i.getColaborador() != null) {
            idColab1 = i.getColaborador().getIdentificador();
        }
        if (item.getColaboradorIdentificador() != null) {
            idColab2 = item.getColaboradorIdentificador();
        }
        if (ToolMethods.isNull((Object)item.getDataFechamento()).booleanValue() || ToolMethods.isNull((Object)i.getDataReferencia()).booleanValue()) {
            return false;
        }
        return this.isEquals(idColab1, idColab2, i.getDataReferencia(), item.getDataFechamento());
    }
}

