/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.comunicadoproducao.composicaocustos;

import com.touchcomp.basementor.constants.enums.celulaprodutiva.EnumConstCelulaProdTipoCusto;
import com.touchcomp.basementor.model.vo.FaseProdutiva;
import com.touchcomp.basementor.model.vo.ItemComposicaoCusto;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.service.impl.celulaprodutiva.ServiceCelulaProdutivaImpl;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.composicaocustos.AuxBaseAvaliaCompCustos;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.modelaux.VOFaseProdutivaEvt;
import com.touchcomp.basementorservice.service.impl.roteiroproducao.ServiceFaseProdutivaImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class AuxAvaliaCompCustosFaseProdutiva
extends AuxBaseAvaliaCompCustos {
    final ServiceCelulaProdutivaImpl serviceCelulaProdutivaImpl;
    final ServiceFaseProdutivaImpl serviceFaseProdutivaImpl;
    final List<ItemComposicaoCusto> itensComposicaoCusto;

    public AuxAvaliaCompCustosFaseProdutiva(ServiceCelulaProdutivaImpl serviceCelulaProdutivaImpl, List<ItemComposicaoCusto> itensComposicaoCusto, ServiceFaseProdutivaImpl serviceFaseProdutivaImpl) {
        this.serviceCelulaProdutivaImpl = serviceCelulaProdutivaImpl;
        this.itensComposicaoCusto = itensComposicaoCusto;
        this.serviceFaseProdutivaImpl = serviceFaseProdutivaImpl;
    }

    public void getItemComposicaoCustoFaseProd(ItemComunicadoProducao it, EnumConstCelulaProdTipoCusto tipoCusto, List<VOFaseProdutivaEvt> eventos) throws ExceptionObjNotFound {
        LinkedList<ItemComposicaoCusto> itensProcessados = new LinkedList<ItemComposicaoCusto>();
        for (VOFaseProdutivaEvt evento : eventos) {
            this.getItemComposicaoCustoFaseProd(evento.getFaseProdutivaIdentificador(), it, evento.getDataFechamento(), evento.getHoraEvento(), tipoCusto, itensProcessados);
        }
        this.processarRemoverItensNProcessados(this.itensComposicaoCusto, itensProcessados);
    }

    public void getItemComposicaoCustoFaseProd(Long faseProdutivaIdentificador, ItemComunicadoProducao it, Date data, Double qtdHoras, EnumConstCelulaProdTipoCusto tipoCusto, List<ItemComposicaoCusto> itensProcessados) throws ExceptionObjNotFound {
        ItemComposicaoCusto io;
        Optional<ItemComposicaoCusto> found = this.itensComposicaoCusto.stream().filter(i -> i.getFaseProdutiva() != null && TMethods.isEquals((Object)i.getFaseProdutiva().getIdentificador(), (Object)faseProdutivaIdentificador)).findFirst();
        if (found.isPresent()) {
            io = found.get();
        } else {
            io = this.newItemComposicaoCusto(it.getComunicadoProducao().getEmpresa(), data);
            io.setFaseProdutiva((FaseProdutiva)this.serviceFaseProdutivaImpl.getOrThrow(faseProdutivaIdentificador));
            this.itensComposicaoCusto.add(io);
        }
        io.setDataReferencia(data);
        io.setValorInicial(Double.valueOf(this.serviceCelulaProdutivaImpl.getCustoCelulaProdutiva(tipoCusto, data, io.getFaseProdutiva().getCelulaProdutiva()) * qtdHoras));
        io.setQuantidadeRef(Double.valueOf(io.getQuantidadeRef() + qtdHoras));
        io.setItemComProducao(it);
        itensProcessados.add(io);
    }

    public void getItemComposicaoCustoFaseProd(FaseProdutiva faseProdutiva, ItemComunicadoProducao it, Date data, Double qtdHoras, EnumConstCelulaProdTipoCusto tipoCusto) {
        ItemComposicaoCusto io;
        Optional<ItemComposicaoCusto> found = this.itensComposicaoCusto.stream().filter(i -> TMethods.isEquals((Object)i.getFaseProdutiva(), (Object)faseProdutiva)).findFirst();
        LinkedList<ItemComposicaoCusto> itensProcessados = new LinkedList<ItemComposicaoCusto>();
        if (found.isPresent()) {
            io = found.get();
        } else {
            io = this.newItemComposicaoCusto(it.getComunicadoProducao().getEmpresa(), data);
            io.setFaseProdutiva(faseProdutiva);
            this.itensComposicaoCusto.add(io);
        }
        io.setDataReferencia(data);
        io.setValorInicial(Double.valueOf(this.serviceCelulaProdutivaImpl.getCustoCelulaProdutiva(tipoCusto, data, faseProdutiva.getCelulaProdutiva()) * qtdHoras));
        io.setQuantidadeRef(Double.valueOf(io.getQuantidadeRef() + qtdHoras));
        io.setItemComProducao(it);
        itensProcessados.add(io);
        this.processarRemoverItensNProcessados(this.itensComposicaoCusto, itensProcessados);
    }

    private void processarRemoverItensNProcessados(List<ItemComposicaoCusto> itensComposicaoCusto, List<ItemComposicaoCusto> itensProcessados) {
        LinkedList<ItemComposicaoCusto> toRem = new LinkedList<ItemComposicaoCusto>();
        for (ItemComposicaoCusto item : itensComposicaoCusto) {
            Optional<ItemComposicaoCusto> found = itensProcessados.stream().filter(i -> this.isEquals(item, (ItemComposicaoCusto)i)).findFirst();
            if (found.isPresent() || item.getFaseProdutiva() == null) continue;
            toRem.add(item);
        }
        itensComposicaoCusto.removeAll(toRem);
    }

    private boolean isEquals(FaseProdutiva faseProdutiva, FaseProdutiva faseProdutiva0, Date dataRef, Date dataRef0) {
        return TMethods.isEquals((Object)faseProdutiva, (Object)faseProdutiva0) && TMethods.isEquals((Object)dataRef, (Object)dataRef0);
    }

    private boolean isEquals(ItemComposicaoCusto item, ItemComposicaoCusto i) {
        return this.isEquals(item.getFaseProdutiva(), i.getFaseProdutiva(), item.getDataReferencia(), i.getDataReferencia());
    }
}

