/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.comunicadoproducao.composicaocustos;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemRequisicao;
import com.touchcomp.basementor.model.vo.ItemComposicaoCusto;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.service.impl.centroestoque.ServiceCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.composicaocustos.AuxBaseAvaliaCompCustos;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.modelaux.VOProdutosRequisicaoEvt;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class AuxAvaliaCompCustosRequisicao
extends AuxBaseAvaliaCompCustos {
    private final List<ItemComposicaoCusto> itensComposicaoCusto;
    private final ServiceSaldoEstoqueImpl serviceSaldoEstoque;
    private final ServiceGradeCorImpl serviceGradeCorImpl;
    private final ServiceCentroEstoqueImpl serviceCentroEstoqueImpl;

    public AuxAvaliaCompCustosRequisicao(List<ItemComposicaoCusto> aux, ServiceSaldoEstoqueImpl serviceSaldoEstoque, ServiceGradeCorImpl serviceGradeCorImpl, ServiceCentroEstoqueImpl serviceCentroEstoqueImpl) {
        this.itensComposicaoCusto = aux;
        this.serviceSaldoEstoque = serviceSaldoEstoque;
        this.serviceGradeCorImpl = serviceGradeCorImpl;
        this.serviceCentroEstoqueImpl = serviceCentroEstoqueImpl;
    }

    public List<ItemComposicaoCusto> getItemCompCustoRequisicao(List<Requisicao> requisicoes, ItemComunicadoProducao it, Date data) {
        if (requisicoes == null) {
            return this.itensComposicaoCusto;
        }
        LinkedList<ItemComposicaoCusto> todosItensProcessados = new LinkedList<ItemComposicaoCusto>();
        for (Requisicao requisicao : requisicoes) {
            for (ItemRequisicao ir : requisicao.getItensRequisicao()) {
                this.availaCustosItem(requisicao.getEmpresa(), requisicao.getDataRequisicao(), ir, it, todosItensProcessados);
            }
        }
        for (ItemComposicaoCusto io : todosItensProcessados) {
            Double valor = this.serviceSaldoEstoque.findPrecoMedioProduto(io.getProduto(), io.getEmpresa(), io.getDataReferencia(), EnumConstSaldoEstTipoSaldo.TIPO_SALDO_PRODUTO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_VALOR, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
            io.setPrecoMedio(valor);
            io.setValorInicial(Double.valueOf(io.getPrecoMedio() * io.getQuantidadeRef()));
        }
        this.processarRemoverItensNProcessados(this.itensComposicaoCusto, todosItensProcessados);
        return this.itensComposicaoCusto;
    }

    private void availaCustosItem(Empresa empresa, Date dataRequisicao, ItemRequisicao ir, ItemComunicadoProducao it, List<ItemComposicaoCusto> todosItensProcessados) {
        if (ir.getCentroEstoque() == null) {
            return;
        }
        if (!ToolMethods.isEqualsNumber((Number)ir.getCentroEstoque().getTipoEstProprioTerceiros(), (Number)EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue())) {
            return;
        }
        for (GradeItemRequisicao g : ir.getGradeItemRequisicao()) {
            ItemComposicaoCusto io;
            Optional<ItemComposicaoCusto> found = this.itensComposicaoCusto.stream().filter(i -> this.isEquals(g, (ItemComposicaoCusto)i)).findFirst();
            if (found.isPresent()) {
                io = found.get();
            } else {
                io = this.newItemComposicaoCusto(empresa, dataRequisicao);
                io.setGradeCor(g.getGradeCor());
                io.setProduto(ir.getProduto());
                io.setCentroEstoque(ir.getCentroEstoque());
                this.itensComposicaoCusto.add(io);
            }
            io.setQuantidadeRef(Double.valueOf(io.getQuantidadeRef() + g.getQuantidade()));
            io.setItemComProducao(it);
            io.setDataReferencia(dataRequisicao);
            todosItensProcessados.add(io);
        }
    }

    public List<ItemComposicaoCusto> getItemCompCustoRequisicao(List<VOProdutosRequisicaoEvt> itens, ItemComunicadoProducao it) throws ExceptionObjNotFound {
        LinkedList<ItemComposicaoCusto> itensProcessados = new LinkedList<ItemComposicaoCusto>();
        for (VOProdutosRequisicaoEvt g : itens) {
            ItemComposicaoCusto io;
            Optional<ItemComposicaoCusto> found = this.itensComposicaoCusto.stream().filter(i -> this.isEquals(g, (ItemComposicaoCusto)i)).findFirst();
            if (found.isPresent()) {
                io = found.get();
            } else {
                io = this.newItemComposicaoCusto(it.getComunicadoProducao().getEmpresa(), g.getDataFechamento());
                io.setGradeCor((GradeCor)this.serviceGradeCorImpl.getOrThrow(g.getGradeCorIdentificador()));
                io.setProduto(io.getGradeCor().getProdutoGrade().getProduto());
                io.setCentroEstoque((CentroEstoque)this.serviceCentroEstoqueImpl.getOrThrow(g.getCentroEstoqueIdentificador()));
                this.itensComposicaoCusto.add(io);
            }
            io.setQuantidadeRef(Double.valueOf(io.getQuantidadeRef() + g.getQuantidade()));
            io.setItemComProducao(it);
            io.setDataReferencia(g.getDataFechamento());
            itensProcessados.add(io);
        }
        for (ItemComposicaoCusto io : itensProcessados) {
            if (TMethods.isEquals((Object)io.getCentroEstoque().getTipoEstProprioTerceiros(), (Object)EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue())) {
                Double valor = this.serviceSaldoEstoque.findPrecoMedioProduto(io.getProduto(), it.getComunicadoProducao().getEmpresa(), io.getDataReferencia(), EnumConstSaldoEstTipoSaldo.TIPO_SALDO_PRODUTO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_VALOR, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
                io.setPrecoMedio(valor);
                io.setValorInicial(Double.valueOf(io.getPrecoMedio() * io.getQuantidadeRef()));
                continue;
            }
            io.setPrecoMedio(Double.valueOf(0.0));
            io.setValorInicial(Double.valueOf(0.0));
            io.setValorReal(Double.valueOf(0.0));
        }
        this.processarRemoverItensNProcessados(this.itensComposicaoCusto, itensProcessados);
        return this.itensComposicaoCusto;
    }

    private void processarRemoverItensNProcessados(List<ItemComposicaoCusto> itensComposicaoCusto, List<ItemComposicaoCusto> itensProcessados) {
        LinkedList<ItemComposicaoCusto> toRem = new LinkedList<ItemComposicaoCusto>();
        for (ItemComposicaoCusto item : itensComposicaoCusto) {
            Optional<ItemComposicaoCusto> found;
            if (item.getGradeCor() == null || (found = itensProcessados.stream().filter(i -> this.isEquals(item, (ItemComposicaoCusto)i)).findFirst()).isPresent()) continue;
            toRem.add(item);
        }
        System.out.println("teste");
        itensComposicaoCusto.removeAll(toRem);
    }

    private boolean isEquals(GradeItemRequisicao g, ItemComposicaoCusto i) {
        Long idGC1 = 0L;
        Long idGC2 = 0L;
        Long idCC1 = 0L;
        Long idCC2 = 0L;
        if (g.getGradeCor() != null) {
            idGC1 = g.getGradeCor().getIdentificador();
        }
        if (i.getGradeCor() != null) {
            idGC2 = i.getGradeCor().getIdentificador();
        }
        if (g.getCentroEstoque() != null) {
            idCC1 = g.getCentroEstoque().getIdentificador();
        }
        if (i.getCentroEstoque() != null) {
            idCC2 = i.getCentroEstoque().getIdentificador();
        }
        return this.isEquals(idGC1, idGC2, idCC1, idCC2, i.getDataReferencia(), g.getDataMovimentacao());
    }

    private boolean isEquals(ItemComposicaoCusto item1, ItemComposicaoCusto item2) {
        Long idGC1 = 0L;
        Long idGC2 = 0L;
        Long idCC1 = 0L;
        Long idCC2 = 0L;
        if (item1.getGradeCor() != null) {
            idGC1 = item1.getGradeCor().getIdentificador();
        }
        if (item2.getGradeCor() != null) {
            idGC2 = item2.getGradeCor().getIdentificador();
        }
        if (item1.getCentroEstoque() != null) {
            idCC1 = item1.getCentroEstoque().getIdentificador();
        }
        if (item2.getCentroEstoque() != null) {
            idCC2 = item2.getCentroEstoque().getIdentificador();
        }
        return this.isEquals(idGC1, idGC2, idCC1, idCC2, item1.getDataReferencia(), item2.getDataReferencia());
    }

    private boolean isEquals(Long gradeCor, Long gradeCor0, Long centroEstoque, Long centroEstoque0, Date dataRef, Date dataRef0) {
        return TMethods.isEqualsNumber((Number)gradeCor, (Number)gradeCor0) && TMethods.isEqualsNumber((Number)centroEstoque, (Number)centroEstoque0) && TMethods.isEquals((Object)TDate.dataSemHora((Date)dataRef), (Object)TDate.dataSemHora((Date)dataRef0));
    }

    private boolean isEquals(VOProdutosRequisicaoEvt g, ItemComposicaoCusto i) {
        Long idGC1 = 0L;
        Long idGC2 = 0L;
        Long idCC1 = 0L;
        Long idCC2 = 0L;
        if (g.getGradeCorIdentificador() != null) {
            idGC1 = g.getGradeCorIdentificador();
        }
        if (i.getGradeCor() != null) {
            idGC2 = i.getGradeCor().getIdentificador();
        }
        if (g.getCentroEstoqueIdentificador() != null) {
            idCC1 = g.getCentroEstoqueIdentificador();
        }
        if (i.getCentroEstoque() != null) {
            idCC2 = i.getCentroEstoque().getIdentificador();
        }
        return this.isEquals(idGC1, idGC2, idCC1, idCC2, g.getDataFechamento(), i.getDataReferencia());
    }
}

