/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.conciliacaobancaria;

import com.touchcomp.basementor.constants.enums.configservicos.EnumConstConfigServicos;
import com.touchcomp.basementor.model.vo.ConciliacaoBancaria;
import com.touchcomp.basementor.model.vo.ConfigServicos;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.exceptions.BankNotSupportedException;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.components.banksapi.SCompBanksSincConciliacao;
import com.touchcomp.basementorservice.service.impl.conciliacaobancaria.ServiceConciliacaoBancariaImpl;
import com.touchcomp.basementorservice.service.impl.configservicos.ServiceConfigServicosImpl;
import com.touchcomp.basementorservice.service.impl.contavalores.ServiceContaValoresImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SCConciliacaoBancariaAPIServiceImpl
extends ServiceGenericImpl {
    @Autowired
    ServiceContaValoresImpl serviceContaValoresImpl;
    @Autowired
    ServiceConfigServicosImpl serviceConfigServicosImpl;
    @Autowired
    ServiceConciliacaoBancariaImpl serviceConciliacaoBancariaImpl;
    @Autowired
    SCompBanksSincConciliacao scompConciliacaoSantander;

    public void conciliarExtratoAPI(List<ContaValores> contavalor) throws ExceptionBase, BankException, BankNotSupportedException {
        for (ContaValores contaValores : contavalor) {
            this.conciliarExtratoAPI(contaValores);
        }
    }

    public void conciliarExtratoAPI(List<ContaValores> contavalor, Date dataIn, Date dataFinal) throws ExceptionBase, BankException, BankNotSupportedException {
        for (ContaValores contaValores : contavalor) {
            this.conciliarExtratoAPI(contaValores, dataIn, dataFinal);
        }
    }

    public void conciliarExtratoAPI(String idConta, Date dataIn, Date dataFinal) throws ExceptionObjNotFound, ExceptionBase, BankException, BankNotSupportedException {
        ContaValores conta = (ContaValores)this.serviceContaValoresImpl.getOrThrow(idConta);
        this.conciliarExtratoAPI(conta, dataFinal, dataFinal);
    }

    public void conciliarExtratoAPI(ContaValores contavalor) throws ExceptionBase, BankException, BankNotSupportedException {
        Date dataInicial = ToolDate.previousDays((Date)new Date(), (int)1);
        Date dataFinal = ToolDate.previousDays((Date)new Date(), (int)1);
        Date dataUltconc = this.serviceConciliacaoBancariaImpl.getDataFinalUltimaConciliacao(contavalor);
        if (dataUltconc != null) {
            dataInicial = ToolDate.nextDays((Date)dataUltconc, (int)1);
        }
        if (dataInicial.before(ToolDate.previousDays((Date)dataFinal, (int)90))) {
            dataInicial = ToolDate.previousDays((Date)dataFinal, (int)90);
        }
        this.conciliarExtratoAPI(contavalor, dataInicial, dataFinal);
    }

    public void conciliarExtratoAPI(ContaValores contavalor, Date dataInicial, Date dataFinal) throws ExceptionBase, BankException, BankNotSupportedException {
        ConfigServicos cs = this.serviceConfigServicosImpl.getOrThrow(EnumConstConfigServicos.CONCILIACAO_FINANCEIRA_API);
        SCompBanksSincConciliacao conciliacao = this.getConciliacao(contavalor);
        ConciliacaoBancaria conc = conciliacao.conciliar(contavalor, cs, dataInicial, dataFinal);
        this.serviceConciliacaoBancariaImpl.saveOrUpdate(conc);
    }

    private SCompBanksSincConciliacao getConciliacao(ContaValores contavalor) throws ExceptionInvalidData {
        String bank;
        switch (bank = contavalor.getAgenciaValor().getInstituicaoValor().getNrBanco()) {
            case "033": {
                return this.scompConciliacaoSantander;
            }
        }
        throw new ExceptionInvalidData("E.ERP.1671.012", new Object[]{bank});
    }
}

