/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.conciliacaobancaria;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.remessacobranca.EnumConstCnabCodificacaoArquivo;
import com.touchcomp.basementor.model.impl.SaldoContaValores;
import com.touchcomp.basementor.model.vo.ConciliacaoBancaria;
import com.touchcomp.basementor.model.vo.ConciliacaoBancariaDia;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.IntegracaoMovBancarioMovimento;
import com.touchcomp.basementor.model.vo.ItemConciliacaoMovimento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.ModeloLancBancario;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementorbanks.services.impl.statements.model.Statements;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.ofxexception.ExceptionArquivoOFX;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.dao.impl.DaoConciliacaoBancariaImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.bloqueiomovimentobancario.ServiceBloqueioMovimentoBancarioImpl;
import com.touchcomp.basementorservice.service.impl.conciliacaobancaria.UtilConciliaExtrato;
import com.touchcomp.basementorservice.service.impl.conciliacaobancaria.components.SCompAtualizarTotalizadoresConciliacao;
import com.touchcomp.basementorservice.service.impl.conciliacaobancaria.components.SCompGerarMovimentoFinanceiro;
import com.touchcomp.basementorservice.service.impl.conciliacaobancaria.components.SCompProcessarExtratoBancario;
import com.touchcomp.basementorservice.service.impl.conciliacaobancariadia.ServiceConciliacaoBancariaDiaImpl;
import com.touchcomp.basementorservice.service.impl.contavalores.ServiceContaValoresImpl;
import com.touchcomp.basementorservice.service.impl.empresacontabilidade.ServiceEmpresaContabilidadeImpl;
import com.touchcomp.basementorservice.service.impl.modelolancbancario.ServiceModeloLancBancarioImpl;
import com.touchcomp.basementorservice.service.impl.saldocontavalores.ServiceSaldoContaValoresImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceLancamento;
import com.touchcomp.basementorservice.service.interfaces.ServiceMovimentoBancario;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.entities.impl.conciliacaobancaria.ValidConciliacaoBancaria;
import com.touchcomp.basementorvalidator.entities.model.ValidContainerItem;
import com.touchcomp.touchvomodel.vo.conciliacaobancaria.web.DTOConciliacaoBancaria;
import com.touchcomp.touchvomodel.vo.conciliacaobancaria.web.DTOConciliacaoBancariaOFX;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import com.webcohesion.ofx4j.io.OFXParseException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceConciliacaoBancariaImpl
extends ServiceGenericEntityImpl<ConciliacaoBancaria, Long, DaoConciliacaoBancariaImpl> {
    @Autowired
    private ServiceSaldoContaValoresImpl serviceSaldoContaValoresImpl;
    @Autowired
    private ServiceContaValoresImpl serviceContaValores;
    @Autowired
    private ServiceModeloLancBancarioImpl serviceModeloLancBancario;
    @Autowired
    private ServiceConciliacaoBancariaDiaImpl serviceConciliacaoDia;
    @Autowired
    private ServiceEmpresaContabilidadeImpl serviceEmpresaContabilidade;
    @Autowired
    private SCompProcessarExtratoBancario compProcessExtrato;
    @Autowired
    private SCompGerarMovimentoFinanceiro compGerarMovimento;
    @Autowired
    private SCompAtualizarTotalizadoresConciliacao compTotalizadoresConciliacao;
    @Autowired
    private ServiceBloqueioMovimentoBancarioImpl serviceBloqueio;
    @Autowired
    private ServiceLancamento serviceLancamento;
    @Autowired
    private ServiceMovimentoBancario serviceMovimento;

    public ServiceConciliacaoBancariaImpl(DaoConciliacaoBancariaImpl genericDao) {
        super(genericDao);
    }

    @Override
    public ConciliacaoBancaria beforeSave(ConciliacaoBancaria vo) {
        try {
            if (ServiceConciliacaoBancariaImpl.isWithData(vo.getConciliacaoBancariaDia())) {
                this.validarDataPlanoContaConciliacao(vo);
                for (ConciliacaoBancariaDia c : vo.getConciliacaoBancariaDia()) {
                    c.setConciliacaoBancaria(vo);
                    this.serviceConciliacaoDia.beforeSave(c);
                }
            }
            if (this.isStrWithData(vo.getCaminhoArquivo())) {
                vo.setCaminhoArquivo(ToolString.cut((String)vo.getCaminhoArquivo(), (int)500));
            }
            return vo;
        }
        catch (ExceptionInvalidData ex) {
            throw new ExceptionRuntimeBase(ex.getFormattedMessage());
        }
    }

    @Override
    @Transactional(transactionManager="transactionManager", propagation=Propagation.REQUIRED)
    public ConciliacaoBancaria saveOrUpdateOnly(ConciliacaoBancaria vo) {
        EmpresaContabilidade empresaContabilidade = this.serviceEmpresaContabilidade.findByEmpresa(vo.getEmpresa());
        if (this.isNotNull(empresaContabilidade).booleanValue() && this.isEquals(empresaContabilidade.getLancMovimentoBancario(), (short)0)) {
            for (ConciliacaoBancariaDia c : vo.getConciliacaoBancariaDia()) {
                for (ItemConciliacaoMovimento i : c.getItemConciliacaoMovimento()) {
                    if (!ToolMethods.isAffirmative((Number)i.getMovimentoBancario().getMovimentoConciliacao())) continue;
                    IntegracaoMovBancarioMovimento intMov = new IntegracaoMovBancarioMovimento();
                    intMov.setMovimentoBancario(i.getMovimentoBancario());
                    LoteContabil lote = this.serviceLancamento.gerarLancamentosMovimentoBancario(intMov);
                    intMov.setLoteContabil(lote);
                    i.getMovimentoBancario().setIntegracaoMovBancarioMovimento(intMov);
                }
            }
        }
        if (ToolMethods.isAffirmative((Number)(vo = super.saveOrUpdateOnly(vo)).getGerarBloqueioMovBancario())) {
            this.serviceBloqueio.criarBloqueio(vo.getContaValores(), vo.getDataInicial(), vo.getDataFinal());
        }
        return vo;
    }

    private void validarDataPlanoContaConciliacao(ConciliacaoBancaria vo) throws ExceptionInvalidData {
        Object errorMsg = "";
        for (ConciliacaoBancariaDia c : vo.getConciliacaoBancariaDia()) {
            ConciliacaoBancariaDia conflito;
            if (!this.isNotNull(c.getDataMovimento()).booleanValue() || !this.isNotNull(conflito = this.serviceConciliacaoDia.find(vo.getContaValores(), ToolDate.dataSemHora((Date)c.getDataMovimento()))).booleanValue()) continue;
            errorMsg = (String)errorMsg + MessagesBaseMentor.getErrorMsg((String)"E.ERP.1671.001", (Object[])new Object[]{conflito.getConciliacaoBancaria().getIdentificador(), vo.getContaValores().toString(), ToolDate.dateToStr((Date)c.getDataMovimento())});
        }
        if (this.isStrWithData((String)errorMsg)) {
            throw new ExceptionInvalidData((String)errorMsg, new Object[0]);
        }
    }

    public List<ConciliacaoBancariaDia> conciliarExtrato(File file, EnumConstantsMentorSimNao filtrarDataManual, Date dataInicial, Date dataFinal, ContaValores contaValor, EnumConstantsMentorSimNao filtrarMovimentosArquivoPeriodo, EnumConstCnabCodificacaoArquivo codificacaoArquivo) throws ExceptionIO, ExceptionArquivoOFX {
        Double saldoAnteriorExtrato = this.getSaldoAnterior(dataInicial, contaValor);
        Double saldoAnteriorMovimento = this.getSaldoAnteriorMov(dataInicial, contaValor);
        return new UtilConciliaExtrato().conciliarExtrato(file, filtrarDataManual, dataInicial, dataFinal, contaValor, filtrarMovimentosArquivoPeriodo, saldoAnteriorExtrato, saldoAnteriorMovimento, codificacaoArquivo);
    }

    @Override
    public boolean delete(ConciliacaoBancaria vo) {
        ArrayList<MovimentoBancario> movimentosExlcuidos = new ArrayList<MovimentoBancario>();
        for (ConciliacaoBancariaDia c : vo.getConciliacaoBancariaDia()) {
            for (ItemConciliacaoMovimento i : c.getItemConciliacaoMovimento()) {
                if (i.getMovimentoBancario() != null && ToolMethods.isAffirmative((Number)i.getMovimentoBancario().getMovimentoConciliacao())) {
                    i.getMovimentoBancario().setMovimentoConciliacao(Short.valueOf((short)0));
                    movimentosExlcuidos.add(i.getMovimentoBancario());
                    i.setMovimentoBancario(null);
                    continue;
                }
                i.setMovimentoBancario(null);
            }
        }
        super.delete(vo);
        this.serviceMovimento.deleteCollection(movimentosExlcuidos);
        return true;
    }

    public Double getSaldoAnterior(Date dataInicial, ContaValores contaValores) {
        return ((DaoConciliacaoBancariaImpl)this.getDao()).getSaldoAnterior(dataInicial, contaValores);
    }

    public Double getSaldoAnteriorMov(Date dataInicial, ContaValores contaValores) {
        SaldoContaValores saldo = this.serviceSaldoContaValoresImpl.findSaldoCompensacao(dataInicial, dataInicial, contaValores);
        return saldo != null ? saldo.getValorSaldoAnterior() : 0.0;
    }

    public DTOConciliacaoBancaria processarArquivoOFX(DTOConciliacaoBancariaOFX dto, Short filtrarMovimentos, Short gerarBloqueioMovBancario, Long dataInicial, Long dataFinal, Long idContaValores) throws ExceptionObjNotFound, IOException, OFXParseException, ExceptionInvalidData, ExceptionDecodeHexString64 {
        String input = ToolBase64.decodeBase64String((String)dto.getInputOfxFile());
        if (!this.isStrWithData(input)) {
            throw new ExceptionInvalidData("E.ERP.1671.006", new Object[0]);
        }
        ConciliacaoBancaria vo = (ConciliacaoBancaria)this.buildToEntity(dto.getConciliacao());
        ContaValores contaValores = (ContaValores)this.serviceContaValores.getOrThrow(idContaValores);
        vo.setGerarBloqueioMovBancario(gerarBloqueioMovBancario);
        vo.setDataInicial(new Date(dataInicial));
        vo.setDataFinal(new Date(dataFinal));
        vo.setContaValores(contaValores);
        ArrayList<Statements.Statement> statements = new ArrayList<Statements.Statement>();
        Double saldoAnteriorExtrato = this.getSaldoAnterior(dataInicial != null ? new Date(dataInicial) : null, contaValores);
        this.compProcessExtrato.processar(filtrarMovimentos, vo, saldoAnteriorExtrato, statements);
        return this.buildToDTOGeneric(vo, DTOConciliacaoBancaria.class);
    }

    public List<ConciliacaoBancariaDia> aplicarModeloLancBancario(DTOConciliacaoBancaria input, Long idModeloLancBancario, Long idContaValores, Long dataInicial) throws ExceptionObjNotFound, ExceptionInvalidData {
        ModeloLancBancario modelo = (ModeloLancBancario)this.serviceModeloLancBancario.getOrThrow(idModeloLancBancario);
        ContaValores contaValores = (ContaValores)this.serviceContaValores.getOrThrow(idContaValores);
        ConciliacaoBancaria conciliacao = (ConciliacaoBancaria)this.buildToEntity(input);
        if (ServiceConciliacaoBancariaImpl.isWithData(conciliacao.getConciliacaoBancariaDia())) {
            this.compGerarMovimento.criarMovimentoFinanceiro(conciliacao, modelo);
            Double saldoAnteriorExtrato = this.getSaldoAnterior(dataInicial != null ? new Date(dataInicial) : null, contaValores);
            this.compTotalizadoresConciliacao.calcularTotalizadoresConciliacaoDia(conciliacao.getConciliacaoBancariaDia(), saldoAnteriorExtrato, saldoAnteriorExtrato);
        }
        return conciliacao.getConciliacaoBancariaDia();
    }

    public WebDTOResult validarConciliacao(DTOConciliacaoBancaria input, ValidConciliacaoBancaria validator) {
        ConciliacaoBancaria vo = (ConciliacaoBancaria)this.buildToEntity(input);
        validator.validarConciliacao(vo);
        WebDTOResult result = new WebDTOResult();
        if (ServiceConciliacaoBancariaImpl.isWithData(validator.getContainerWarns().getItens())) {
            for (ValidContainerItem item : validator.getContainerWarns().getItens()) {
                result.addWarning(item.getCodigo().getCode());
            }
        }
        return result;
    }

    public Date getDataFinalUltimaConciliacao(ContaValores contavalor) {
        return ((DaoConciliacaoBancariaImpl)this.getDao()).getDataFinalUltimaConciliacao(contavalor);
    }
}

