/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.conciliacaobancaria;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.remessacobranca.EnumConstCnabCodificacaoArquivo;
import com.touchcomp.basementor.model.vo.ConciliacaoBancariaDia;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.ItemConciliacaoExtrato;
import com.touchcomp.basementor.model.vo.ItemConciliacaoMovimento;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementorbanks.constants.CharsetType;
import com.touchcomp.basementorbanks.exceptions.BankException;
import com.touchcomp.basementorbanks.services.impl.statements.impl.santander.constants.EnumCreditDebitType;
import com.touchcomp.basementorbanks.services.impl.statements.model.Statements;
import com.touchcomp.basementorbanks.services.impl.statements.ofx.BankOFXFileReader;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.ofxexception.EnumExcepArquivoOFX;
import com.touchcomp.basementorexceptions.exceptions.impl.ofxexception.ExceptionArquivoOFX;
import com.touchcomp.basementorservice.service.interfaces.ServiceMovimentoBancario;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.webcohesion.ofx4j.io.OFXParseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class UtilConciliaExtrato {
    private final ServiceMovimentoBancario serviceMovBancario = (ServiceMovimentoBancario)ConfApplicationContext.getBean(ServiceMovimentoBancario.class);

    List<ConciliacaoBancariaDia> conciliarExtrato(File file, EnumConstantsMentorSimNao filtrarDataManual, Date dataInicial, Date dataFinal, ContaValores contaValor, EnumConstantsMentorSimNao filtrarMovimentosArquivoPeriodo, Double saldoAnteriorExtrato, Double saldoAnteriorMovimento, EnumConstCnabCodificacaoArquivo enumCodificacaoArquivo) throws ExceptionIO, ExceptionArquivoOFX {
        try {
            if (ToolMethods.isNull((Object)enumCodificacaoArquivo).booleanValue()) {
                enumCodificacaoArquivo = EnumConstCnabCodificacaoArquivo.UTF8;
            }
            FileInputStream fio = new FileInputStream(file);
            String texto = IOUtils.toString((InputStream)fio, (String)enumCodificacaoArquivo.getEnumId());
            texto = ToolString.clearInvalidUTF8Char((String)texto);
            texto = texto.replace("&", "");
            File temp = File.createTempFile("temp", ".ofx");
            FileWriter fileWriter = new FileWriter(temp, true);
            try (PrintWriter p = new PrintWriter(fileWriter);){
                p.append(texto.trim());
                p.flush();
            }
            List<ItemConciliacaoExtrato> itens = this.lerArquivoOFX(file, contaValor, enumCodificacaoArquivo);
            if (filtrarMovimentosArquivoPeriodo == EnumConstantsMentorSimNao.SIM && dataInicial != null && dataFinal != null) {
                itens = this.filtrarItensConciliacaoPorData(itens, dataInicial, dataFinal);
            }
            List<ConciliacaoBancariaDia> conciliacoesDia = this.processarItensExtratoDiaADia(itens, dataFinal);
            List<MovimentoBancario> movimentos = this.serviceMovBancario.findPorDataAndContaValor(dataInicial, dataFinal, contaValor);
            this.criarItensConciliacaoMovimento(conciliacoesDia, movimentos);
            this.processarConciliacoes(conciliacoesDia);
            this.calcularTotalizadores(conciliacoesDia, saldoAnteriorExtrato, saldoAnteriorMovimento);
            return conciliacoesDia;
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
        catch (BankException | OFXParseException ex) {
            throw new ExceptionArquivoOFX(EnumExcepArquivoOFX.ERRO_LEITURA_ARQUIVO_OFX, new Object[]{ex.getMessage()});
        }
    }

    public List<ItemConciliacaoExtrato> lerArquivoOFX(File file2, ContaValores contaValor, EnumConstCnabCodificacaoArquivo enumCodificacaoArquivo) throws IOException, OFXParseException, BankException {
        ArrayList<ItemConciliacaoExtrato> itens = new ArrayList<ItemConciliacaoExtrato>();
        FileInputStream fio = new FileInputStream(file2);
        BankOFXFileReader reader = new BankOFXFileReader();
        Statements statements = reader.lerArquivoOFX((InputStream)fio, contaValor.getNumeroDiasDifConc(), CharsetType.get((String)enumCodificacaoArquivo.getEnumId()));
        for (Statements.Statement transaction : statements.getStatements()) {
            ItemConciliacaoExtrato i = new ItemConciliacaoExtrato();
            Double valor = transaction.getAmount();
            if (ToolMethods.isEquals((Object)transaction.getCreditDebitType(), (Object)EnumCreditDebitType.CREDITO)) {
                i.setDebCred(Short.valueOf((short)1));
                i.setValor(valor);
            } else {
                i.setDebCred(Short.valueOf((short)0));
                i.setValor(valor);
            }
            i.setDescricao(transaction.getTransactionName());
            i.setDataMovimento(ToolDate.dataSemHora((Date)ToolDate.nextDays((Date)transaction.getTransactionDate(), (int)contaValor.getNumeroDiasDifConc())));
            itens.add(i);
        }
        return itens;
    }

    private List<ItemConciliacaoExtrato> filtrarItensConciliacaoPorData(List<ItemConciliacaoExtrato> lista, Date dataInicial, Date dataFinal) {
        ArrayList<ItemConciliacaoExtrato> itens = new ArrayList<ItemConciliacaoExtrato>();
        for (ItemConciliacaoExtrato i : lista) {
            if (!i.getDataMovimento().equals(dataInicial) && !i.getDataMovimento().after(dataInicial) || !i.getDataMovimento().equals(dataFinal) && !i.getDataMovimento().before(dataFinal)) continue;
            itens.add(i);
        }
        return itens;
    }

    private void processarConciliacoes(List<ConciliacaoBancariaDia> conciliacoes) {
        List<ItemConciliacaoMovimento> itensMovimentosDebitos = this.getMovimentosDebitosCreditos(conciliacoes, (short)0);
        List<ItemConciliacaoMovimento> itensMovimentosCreditos = this.getMovimentosDebitosCreditos(conciliacoes, (short)1);
        ArrayList<MovimentoBancario> movimentosConciliados = new ArrayList<MovimentoBancario>();
        for (ConciliacaoBancariaDia c : conciliacoes) {
            block1: for (ItemConciliacaoExtrato itemExtrato : c.getItemConciliacaoExtrato()) {
                Date data2;
                Double valor2;
                Short debCred = itemExtrato.getDebCred();
                Double valor1 = itemExtrato.getValor();
                Date data1 = ToolDate.dataSemHora((Date)itemExtrato.getDataMovimento());
                if (debCred.equals((short)0)) {
                    for (ItemConciliacaoMovimento itemMovimento : itensMovimentosDebitos) {
                        valor2 = itemMovimento.getMovimentoBancario().getValor();
                        data2 = ToolDate.dataSemHora((Date)itemMovimento.getMovimentoBancario().getDataCompensacao());
                        if (!valor1.equals(valor2) || !data1.equals(data2) || this.movimentoUtilizado(itemMovimento.getMovimentoBancario(), movimentosConciliados)) continue;
                        itemExtrato.setConciliado(Short.valueOf((short)1));
                        itemMovimento.setConciliado(Short.valueOf((short)1));
                        continue block1;
                    }
                    continue;
                }
                if (!debCred.equals((short)1)) continue;
                for (ItemConciliacaoMovimento itemMovimento : itensMovimentosCreditos) {
                    valor2 = itemMovimento.getMovimentoBancario().getValor();
                    data2 = ToolDate.dataSemHora((Date)itemMovimento.getMovimentoBancario().getDataCompensacao());
                    if (!valor1.equals(valor2) || !data1.equals(data2) || this.movimentoUtilizado(itemMovimento.getMovimentoBancario(), movimentosConciliados)) continue;
                    itemExtrato.setConciliado(Short.valueOf((short)1));
                    itemMovimento.setConciliado(Short.valueOf((short)1));
                    continue block1;
                }
            }
        }
    }

    private boolean movimentoUtilizado(MovimentoBancario m, List<MovimentoBancario> movimentosConciliados) {
        if (movimentosConciliados.contains(m)) {
            return true;
        }
        movimentosConciliados.add(m);
        return false;
    }

    private List<ItemConciliacaoMovimento> getMovimentosDebitosCreditos(List<ConciliacaoBancariaDia> conciliacoes, Short debCred) {
        ArrayList<ItemConciliacaoMovimento> lista = new ArrayList<ItemConciliacaoMovimento>();
        for (ConciliacaoBancariaDia c : conciliacoes) {
            for (ItemConciliacaoMovimento m : c.getItemConciliacaoMovimento()) {
                if (!m.getMovimentoBancario().getDebCred().equals(debCred)) continue;
                lista.add(m);
            }
        }
        return lista;
    }

    private List<ConciliacaoBancariaDia> processarItensExtratoDiaADia(List<ItemConciliacaoExtrato> itens, Date dataFinal) {
        ArrayList<ConciliacaoBancariaDia> conciliacoes = new ArrayList<ConciliacaoBancariaDia>();
        for (ItemConciliacaoExtrato i : itens) {
            Date data = i.getDataMovimento();
            if (!data.before(dataFinal) && !ToolMethods.isEquals((Object)data, (Object)dataFinal)) continue;
            ConciliacaoBancariaDia c = this.findConciliacaoDia(data, conciliacoes);
            c.getItemConciliacaoExtrato().add(i);
            if (conciliacoes.contains(c)) continue;
            conciliacoes.add(c);
        }
        return conciliacoes;
    }

    private ConciliacaoBancariaDia findConciliacaoDia(Date data, List<ConciliacaoBancariaDia> conciliacoes) {
        for (ConciliacaoBancariaDia c : conciliacoes) {
            if (!c.getDataMovimento().equals(data)) continue;
            return c;
        }
        ConciliacaoBancariaDia c = new ConciliacaoBancariaDia();
        c.setDataMovimento(data);
        return c;
    }

    private void criarItensConciliacaoMovimento(List<ConciliacaoBancariaDia> conciliacoesDia, List<MovimentoBancario> movimentos) {
        block0: for (MovimentoBancario m : movimentos) {
            for (ConciliacaoBancariaDia c : conciliacoesDia) {
                if (!m.getDataCompensacao().equals(c.getDataMovimento())) continue;
                ItemConciliacaoMovimento i = new ItemConciliacaoMovimento();
                i.setDataMovimento(m.getDataCompensacao());
                i.setMovimentoBancario(m);
                i.setConciliacaoBancariaDia(c);
                c.getItemConciliacaoMovimento().add(i);
                continue block0;
            }
        }
    }

    private void calcularTotalizadores(List<ConciliacaoBancariaDia> conciliacoesDia, Double saldoAnteriorExtrato, Double saldoAnteriorMovimentos) {
        for (ConciliacaoBancariaDia c : conciliacoesDia) {
            Double vrDebito = c.getItemConciliacaoExtrato().stream().filter(i -> ToolMethods.isEqualsNumber((Number)i.getDebCred(), (Number)1)).mapToDouble(i -> i.getValor()).sum();
            Double vrCredito = c.getItemConciliacaoExtrato().stream().filter(i -> ToolMethods.isEqualsNumber((Number)i.getDebCred(), (Number)0)).mapToDouble(i -> i.getValor()).sum();
            c.setValorSaldoAnteriorExtrato(saldoAnteriorExtrato);
            c.setValorDebitosExtrato(vrDebito);
            c.setValorCreditosExtrato(vrCredito);
            c.setValorSaldoAtualExtrato(Double.valueOf(saldoAnteriorExtrato + vrCredito - vrDebito));
            if (c.getValorSaldoAtualExtrato() == -0.0) {
                c.setValorSaldoAtualExtrato(Double.valueOf(0.0));
            }
            saldoAnteriorExtrato = c.getValorSaldoAtualExtrato();
        }
        for (ConciliacaoBancariaDia c : conciliacoesDia) {
            Double vrCredito = 0.0;
            Double vrDebito = 0.0;
            for (ItemConciliacaoMovimento i2 : c.getItemConciliacaoMovimento()) {
                if (ToolMethods.isEqualsNumber((Number)i2.getMovimentoBancario().getDebCred(), (Number)1)) {
                    vrCredito = vrCredito + i2.getMovimentoBancario().getValor();
                    continue;
                }
                vrDebito = vrDebito + i2.getMovimentoBancario().getValor();
            }
            c.setValorSaldoAnteriorMov(saldoAnteriorMovimentos);
            c.setValorDebitosMov(vrDebito);
            c.setValorCreditosMov(vrCredito);
            c.setValorSaldoAtualMov(Double.valueOf(saldoAnteriorMovimentos + vrCredito - vrDebito));
            if (c.getValorSaldoAtualMov() == -0.0) {
                c.setValorSaldoAtualMov(Double.valueOf(0.0));
            }
            saldoAnteriorMovimentos = c.getValorSaldoAtualMov();
        }
    }
}

