/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.conciliacaobancaria.components;

import com.touchcomp.basementor.constants.enums.modelolancamentobancario.EnumConstModeloLancamentoBancario;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.ItemConciliacaoExtrato;
import com.touchcomp.basementor.model.vo.ItemExtratoConciliacao;
import com.touchcomp.basementor.model.vo.ModeloLancBancario;
import com.touchcomp.basementor.model.vo.ParamConciliacaoBancInstituicaoValores;
import com.touchcomp.basementor.model.vo.ParametrizacaoConciliacaoBancaria;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.instituicaovalores.ServiceInstituicaoValoresImpl;
import com.touchcomp.basementorservice.service.impl.itemconciliacaoextrato.ServiceItemConciliacaoExtratoImpl;
import com.touchcomp.basementorservice.service.impl.itemconciliacaomovimento.ServiceItemConciliacaoMovimentoImpl;
import com.touchcomp.basementorservice.service.impl.itemextratoconciliacao.ServiceItemExtratoConciliacaoImpl;
import com.touchcomp.basementorservice.service.impl.modelolancbancario.ServiceModeloLancBancarioImpl;
import com.touchcomp.basementorservice.service.impl.paramconciliacaoinstituicaovalores.ServiceParamConciliacaoBancInstituicaoValoresImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaoconciliacaobancaria.ServiceParametrizacaoConciliacaoBancariaImpl;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SCompBuscarParametrizacaoItemExtrato
extends ServiceGenericImpl {
    @Autowired
    private ServiceParametrizacaoConciliacaoBancariaImpl serviceParametrizacaoConciliacaoBanc;
    @Autowired
    private ServiceParamConciliacaoBancInstituicaoValoresImpl serviceParamConciliacaoBancInstVal;
    @Autowired
    private ServiceModeloLancBancarioImpl serviceModeloLancFinanceiro;
    @Autowired
    private ServiceItemConciliacaoMovimentoImpl serviceItemConciliacaoMov;
    @Autowired
    private ServiceItemConciliacaoExtratoImpl serviceItemConciliacaoExtrato;
    @Autowired
    private ServiceItemExtratoConciliacaoImpl serviceItemExtratoConciliacao;
    @Autowired
    private ServiceInstituicaoValoresImpl serviceInstituicaoValores;
    private final Double SIMILARIDADE_MINIMA = 80.0;

    public ModeloLancBancario buscarModeloLancBancario(ItemConciliacaoExtrato cce) {
        ItemExtratoConciliacao paramItemExtrato = null;
        Double percentualSimilaridade = 0.0;
        List<ParametrizacaoConciliacaoBancaria> parametrizacoes = this.serviceParametrizacaoConciliacaoBanc.buscarParametrizacoes(cce.getConciliacaoBancariaDia().getContaValores().getAgenciaValor().getInstituicaoValor(), cce.getConciliacaoBancariaDia().getConciliacaoBancaria().getEmpresa(), cce.getDebCred());
        for (ParametrizacaoConciliacaoBancaria param : parametrizacoes) {
            for (ParamConciliacaoBancInstituicaoValores piv : param.getBancos()) {
                for (ItemExtratoConciliacao itExt : piv.getItensExtrato()) {
                    Double similaridade = ToolString.similarityBetweenStrings((String)cce.getDescricao(), (String)itExt.getDescricaoItemExtrato());
                    if (!(similaridade >= itExt.getPercentualSimilaridade()) || !this.isNull(paramItemExtrato).booleanValue() && (!this.isNotNull(paramItemExtrato).booleanValue() || !(percentualSimilaridade < similaridade))) continue;
                    paramItemExtrato = itExt;
                    percentualSimilaridade = similaridade;
                }
            }
        }
        if (paramItemExtrato != null) {
            return paramItemExtrato.getModeloLancFinanceiro();
        }
        ItemExtratoConciliacao itemExtratoParametrizacao = this.criarParametrizacao(cce, cce.getConciliacaoBancariaDia().getContaValores().getAgenciaValor().getInstituicaoValor(), cce.getDebCred());
        if (itemExtratoParametrizacao != null) {
            return itemExtratoParametrizacao.getModeloLancFinanceiro();
        }
        return null;
    }

    public void criarParametrizacaoHistorico() {
        Long totalParametrizacoes = this.serviceParametrizacaoConciliacaoBanc.countOf();
        Long totalParametrizacoesBancos = this.serviceParamConciliacaoBancInstVal.countOf();
        if (totalParametrizacoes == 0L || totalParametrizacoesBancos == 0L) {
            List<Object[]> resume = this.serviceItemConciliacaoExtrato.findResumeItensExtConciliacao();
            List<ParametrizacaoConciliacaoBancaria> parametrizacoes = this.serviceParametrizacaoConciliacaoBanc.findAll();
            for (Object[] aux : resume) {
                String descricaoExtrato;
                Long instituicaoValoresIdentificador;
                Long modeloIdentificador = (Long)aux[1];
                ItemExtratoConciliacao itExt = this.serviceItemExtratoConciliacao.findItemByModeloAndInstituicaoValores(modeloIdentificador, instituicaoValoresIdentificador = (Long)aux[3], descricaoExtrato = (String)aux[2]);
                if (!this.isNull(itExt).booleanValue()) continue;
                ModeloLancBancario modelo = (ModeloLancBancario)this.serviceModeloLancFinanceiro.get(modeloIdentificador);
                InstituicaoValores instituicaoVal = (InstituicaoValores)this.serviceInstituicaoValores.get(instituicaoValoresIdentificador);
                if (!this.isNotNull(modelo).booleanValue() || !this.isNotNull(instituicaoVal).booleanValue()) continue;
                this.novoItemExtratoConciliacao(parametrizacoes, modelo, instituicaoVal, descricaoExtrato, this.SIMILARIDADE_MINIMA);
            }
            this.serviceParametrizacaoConciliacaoBanc.flushData();
            this.serviceParamConciliacaoBancInstVal.flushData();
        }
    }

    private ItemExtratoConciliacao novoItemExtratoConciliacao(List<ParametrizacaoConciliacaoBancaria> parametrizacoes, ModeloLancBancario modelo, InstituicaoValores instituicao, Double similaridade) {
        return this.novoItemExtratoConciliacao(parametrizacoes, modelo, instituicao, modelo.getNome(), similaridade);
    }

    private ItemExtratoConciliacao novoItemExtratoConciliacao(List<ParametrizacaoConciliacaoBancaria> parametrizacoes, ModeloLancBancario modelo, InstituicaoValores instituicao, String descricao, Double similaridade) {
        ItemExtratoConciliacao itExt = new ItemExtratoConciliacao();
        itExt.setPercentualSimilaridade(similaridade);
        if (this.isStrWithData(descricao)) {
            itExt.setDescricaoItemExtrato(descricao.toUpperCase());
            itExt.setModeloLancFinanceiro(modelo);
            if (!SCompBuscarParametrizacaoItemExtrato.isWithData(parametrizacoes)) {
                this.criarNovaParametrizacao(parametrizacoes, instituicao, itExt);
            } else {
                this.criarNovaParametrizacaoInstituicao(parametrizacoes, instituicao, itExt);
            }
            return itExt;
        }
        return null;
    }

    private ItemExtratoConciliacao criarParametrizacao(ItemConciliacaoExtrato cce, InstituicaoValores instituicao, Short debCred) {
        List<ModeloLancBancario> modelos = this.serviceModeloLancFinanceiro.getModelosLancBancario(EnumConstModeloLancamentoBancario.get((Object)debCred));
        List<ParametrizacaoConciliacaoBancaria> parametrizacoes = this.serviceParametrizacaoConciliacaoBanc.findAll();
        if (SCompBuscarParametrizacaoItemExtrato.isWithData(modelos)) {
            ModeloLancBancario modeloMaiorSimilaridade = null;
            Double maiorSimilaridade = 0.0;
            for (ModeloLancBancario modelo : modelos) {
                Double similaridade = ToolString.similarityBetweenStrings((String)cce.getDescricao(), (String)modelo.getNome());
                if (!(similaridade > maiorSimilaridade)) continue;
                modeloMaiorSimilaridade = modelo;
                maiorSimilaridade = similaridade;
            }
            if (maiorSimilaridade > this.SIMILARIDADE_MINIMA && this.isNotNull(modeloMaiorSimilaridade).booleanValue()) {
                ItemExtratoConciliacao itExt = null;
                if (modeloMaiorSimilaridade != null) {
                    itExt = this.novoItemExtratoConciliacao(parametrizacoes, modeloMaiorSimilaridade, instituicao, maiorSimilaridade);
                }
                return itExt;
            }
        }
        return null;
    }

    private void criarNovaParametrizacaoInstituicao(List<ParametrizacaoConciliacaoBancaria> parametrizacoes, InstituicaoValores instituicao, ItemExtratoConciliacao itExt) {
        Boolean geradoParamInstVal = false;
        for (ParametrizacaoConciliacaoBancaria param : parametrizacoes) {
            if (SCompBuscarParametrizacaoItemExtrato.isWithData(param.getBancos())) {
                for (ParamConciliacaoBancInstituicaoValores piv : param.getBancos()) {
                    if (!this.isEquals(piv.getInstituicaoValores(), instituicao)) continue;
                    itExt.setParamConcBancInstVal(piv);
                    piv.getItensExtrato().add(itExt);
                    this.serviceParamConciliacaoBancInstVal.saveOrUpdate(piv);
                    geradoParamInstVal = true;
                    break;
                }
            }
            if (!geradoParamInstVal.booleanValue()) continue;
            break;
        }
        if (!geradoParamInstVal.booleanValue()) {
            ParametrizacaoConciliacaoBancaria parametrizacao = parametrizacoes.getFirst();
            ParamConciliacaoBancInstituicaoValores paramInstVal = new ParamConciliacaoBancInstituicaoValores();
            paramInstVal.setInstituicaoValores(instituicao);
            paramInstVal.setParamConciliacaoBancaria(parametrizacao);
            paramInstVal.getItensExtrato().add(itExt);
            parametrizacao.getBancos().add(paramInstVal);
            this.serviceParametrizacaoConciliacaoBanc.saveOrUpdate(parametrizacao);
        }
    }

    private void criarNovaParametrizacao(List<ParametrizacaoConciliacaoBancaria> parametrizacoes, InstituicaoValores instituicao, ItemExtratoConciliacao itExt) {
        ParametrizacaoConciliacaoBancaria parametrizacao = new ParametrizacaoConciliacaoBancaria();
        parametrizacao.setDescricao(MessagesBaseMentor.getMsg((String)"geradoAutomaticamente", (Object[])new Object[0]));
        parametrizacao.setDataCadastro(new Date());
        ParamConciliacaoBancInstituicaoValores parametrizacaoInstVal = new ParamConciliacaoBancInstituicaoValores();
        parametrizacaoInstVal.setInstituicaoValores(instituicao);
        parametrizacaoInstVal.setParamConciliacaoBancaria(parametrizacao);
        itExt.setParamConcBancInstVal(parametrizacaoInstVal);
        parametrizacaoInstVal.getItensExtrato().add(itExt);
        parametrizacao.getBancos().add(parametrizacaoInstVal);
        parametrizacoes.add(this.serviceParametrizacaoConciliacaoBanc.saveOrUpdate(parametrizacao));
    }
}

