/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.conciliacaobancaria.components;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.ConciliacaoBancaria;
import com.touchcomp.basementor.model.vo.ConciliacaoBancariaDia;
import com.touchcomp.basementor.model.vo.ContraPartMovimentoBancario;
import com.touchcomp.basementor.model.vo.ItemConciliacaoExtrato;
import com.touchcomp.basementor.model.vo.ItemConciliacaoMovimento;
import com.touchcomp.basementor.model.vo.ItemModeloLancBancario;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.ModeloLancBancario;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SCompGerarMovimentoFinanceiro
extends BaseMethods {
    @Autowired
    private HelperLancamentoCtbGerencial helperLancamentoCtbGerencial;

    public void criarMovimentoFinanceiro(ConciliacaoBancaria conciliacao, ModeloLancBancario modeloLancFin) throws ExceptionInvalidData {
        for (ConciliacaoBancariaDia cc : conciliacao.getConciliacaoBancariaDia()) {
            if (!SCompGerarMovimentoFinanceiro.isWithData(cc.getItemConciliacaoExtrato())) continue;
            cc.setConciliacaoBancaria(conciliacao);
            for (ItemConciliacaoExtrato cce : cc.getItemConciliacaoExtrato()) {
                if (this.isAffimative(cce.getConciliado())) continue;
                ItemConciliacaoMovimento itemConcMov = this.criarMovimentoFinanceiro(cc, cce, modeloLancFin);
                cc.getItemConciliacaoMovimento().add(itemConcMov);
            }
        }
    }

    public ItemConciliacaoMovimento criarMovimentoFinanceiro(ConciliacaoBancariaDia cc, ItemConciliacaoExtrato cce, ModeloLancBancario modeloLancFin) throws ExceptionInvalidData {
        MovimentoBancario mov = new MovimentoBancario();
        mov.setEmpresa(cc.getConciliacaoBancaria().getEmpresa());
        mov.setMovimentoConciliacao(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        mov.setDebCred(cce.getDebCred());
        mov.setValor(cce.getValor());
        mov.setDataCadastro(new Date());
        mov.setDataLancamento(cce.getDataMovimento());
        mov.setDataCompensacao(cce.getDataMovimento());
        mov.setContaValor(cc.getContaValores());
        mov.setModeloLancamentoBancario(modeloLancFin);
        mov.setHistorico(cce.getDescricao());
        mov.setNaoContabilizarMov(modeloLancFin.getNaoContabilizarMov());
        mov.setCentroResultadoContFin(cc.getConciliacaoBancaria().getEmpresa().getEmpresaDados().getCentroResultadoContFin());
        if (SCompGerarMovimentoFinanceiro.isWithData(mov.getContraPartMovimentoBancario())) {
            mov.getContraPartMovimentoBancario().clear();
        }
        if (!SCompGerarMovimentoFinanceiro.isWithData(modeloLancFin.getItemModeloLancBancario())) {
            throw new ExceptionInvalidData("E.ERP.1671.002", new Object[0]);
        }
        for (ItemModeloLancBancario item : modeloLancFin.getItemModeloLancBancario()) {
            if (this.isNull(item.getPlanoConta()).booleanValue() || this.isNull(item.getPlanoContaGerencial()).booleanValue() || this.isNull(item.getHistoricoPadrao()).booleanValue()) {
                throw new ExceptionInvalidData("E.ERP.1671.003", new Object[0]);
            }
            ContraPartMovimentoBancario cp = new ContraPartMovimentoBancario();
            cp.setMovimentoBancario(mov);
            cp.setDebCred(item.getDebCred());
            cp.setBuscaTitulos(item.getBuscarTitulo());
            cp.setHistorico(item.getHistoricoPadrao().getDescricao());
            cp.setHistoricoPadrao(item.getHistoricoPadrao());
            cp.setPlanoConta(item.getPlanoConta());
            cp.setPlanoContaGerencial(item.getPlanoContaGerencial());
            cp.setContraPartidaGeradaModeloLancamentoBancario(item.getContraPartida());
            cp.setValor(mov.getValor());
            LancamentoCtbGerencial lancamento = this.helperLancamentoCtbGerencial.newLancamentoCtbGerencial(null, mov.getDataLancamento(), mov.getDataCompensacao(), cp.getDebCred(), mov.getEmpresa(), EnumConstantsMentorSimNao.NAO.getValue(), MessagesBaseMentor.getMsg((String)"M.ERP.1671.001", (Object[])new Object[0]), cp.getPlanoContaGerencial(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue(), null, cp.getValor(), null);
            cp.setLancamentoCtbGerencial(lancamento);
            mov.getContraPartMovimentoBancario().add(cp);
        }
        ItemConciliacaoMovimento itemConcMov = new ItemConciliacaoMovimento();
        itemConcMov.setMovimentoBancario(mov);
        itemConcMov.setDataMovimento(mov.getDataCompensacao());
        itemConcMov.setConciliacaoBancariaDia(cc);
        itemConcMov.setConciliado(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        cce.setConciliado(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        return itemConcMov;
    }
}

