/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.conciliacaobancaria.components;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.ConciliacaoBancaria;
import com.touchcomp.basementor.model.vo.ConciliacaoBancariaDia;
import com.touchcomp.basementor.model.vo.ItemConciliacaoExtrato;
import com.touchcomp.basementor.model.vo.ItemConciliacaoMovimento;
import com.touchcomp.basementor.model.vo.ModeloLancBancario;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementorbanks.services.impl.statements.impl.santander.constants.EnumCreditDebitType;
import com.touchcomp.basementorbanks.services.impl.statements.model.Statements;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.conciliacaobancaria.components.SCompAtualizarTotalizadoresConciliacao;
import com.touchcomp.basementorservice.service.impl.conciliacaobancaria.components.SCompBuscarParametrizacaoItemExtrato;
import com.touchcomp.basementorservice.service.impl.conciliacaobancaria.components.SCompCriarItemMovimentoConciliacao;
import com.touchcomp.basementorservice.service.impl.conciliacaobancaria.components.SCompGerarMovimentoFinanceiro;
import com.touchcomp.basementorservice.service.impl.movimentobancario.ServiceMovimentoBancarioImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SCompProcessarExtratoBancario
extends ServiceGenericImpl {
    @Autowired
    private ServiceMovimentoBancarioImpl serviceMovBancario;
    @Autowired
    private SCompCriarItemMovimentoConciliacao compGeradorMovimentosConciliacao;
    @Autowired
    private SCompBuscarParametrizacaoItemExtrato compBuscarParamItemExtrato;
    @Autowired
    private SCompGerarMovimentoFinanceiro compGeradorMovFinanceiro;
    @Autowired
    private SCompAtualizarTotalizadoresConciliacao compTotalizadoresConciliacao;

    private List<Statements.Statement> filterStatements(Short filtrarMovimentos, Date dataInicial, Date dataFinal, List<Statements.Statement> itens) {
        LinkedList<Statements.Statement> filter = new LinkedList<Statements.Statement>();
        if (this.isAffimative(filtrarMovimentos) && this.isNotNull(dataInicial).booleanValue() && this.isNotNull(dataFinal).booleanValue()) {
            for (Statements.Statement i : itens) {
                if (!ToolDate.dateBetween((Date)i.getTransactionDate(), (Date)dataInicial, (Date)dataFinal).booleanValue()) continue;
                filter.add(i);
            }
            return filter;
        }
        return itens;
    }

    private HashMap<String, List<Statements.Statement>> separarItensPorDia(List<Statements.Statement> itens) {
        HashMap<String, List<Statements.Statement>> conciliacoesDia = new HashMap<String, List<Statements.Statement>>();
        for (Statements.Statement i : itens) {
            String key = this.getKey(i.getTransactionDate());
            if (conciliacoesDia.containsKey(key)) {
                conciliacoesDia.get(key).add(i);
                continue;
            }
            LinkedList<Statements.Statement> aux = new LinkedList<Statements.Statement>();
            aux.add(i);
            conciliacoesDia.put(key, aux);
        }
        return conciliacoesDia;
    }

    private String getKey(Date dataTransacao) {
        return String.valueOf(ToolDate.dayFromDate((Date)dataTransacao)) + "_" + ToolDate.monthFromDate((Date)dataTransacao) + "_" + ToolDate.yearFromDate((Object)dataTransacao);
    }

    private ConciliacaoBancariaDia buildConciliacaoDia(ConciliacaoBancaria conciliacao) {
        ConciliacaoBancariaDia dia = new ConciliacaoBancariaDia();
        dia.setConciliacaoBancaria(conciliacao);
        dia.setValorSaldoAnteriorExtrato(Double.valueOf(0.0));
        dia.setValorDebitosExtrato(Double.valueOf(0.0));
        dia.setValorCreditosExtrato(Double.valueOf(0.0));
        dia.setValorSaldoAtualExtrato(Double.valueOf(0.0));
        dia.setValorSaldoAnteriorMov(Double.valueOf(0.0));
        dia.setValorDebitosMov(Double.valueOf(0.0));
        dia.setValorCreditosMov(Double.valueOf(0.0));
        dia.setValorSaldoAtualMov(Double.valueOf(0.0));
        dia.setContaValores(conciliacao.getContaValores());
        return dia;
    }

    public void processar(Short filtrarMovimentos, ConciliacaoBancaria conciliacao, Double saldoAnteriorExtrato, List<Statements.Statement> itens) throws ExceptionInvalidData {
        if (SCompProcessarExtratoBancario.isWithData(itens)) {
            this.compBuscarParamItemExtrato.criarParametrizacaoHistorico();
            itens = this.filterStatements(filtrarMovimentos, conciliacao.getDataInicial(), conciliacao.getDataFinal(), itens);
            HashMap<String, List<Statements.Statement>> conciliacoesDia = this.separarItensPorDia(itens);
            LinkedList<ConciliacaoBancariaDia> conciliacoes = new LinkedList<ConciliacaoBancariaDia>();
            for (String day : conciliacoesDia.keySet()) {
                Double totalConcCredito = 0.0;
                Double totalConcDebito = 0.0;
                ConciliacaoBancariaDia dia = this.buildConciliacaoDia(conciliacao);
                List<Statements.Statement> itensDia = conciliacoesDia.get(day);
                if (SCompProcessarExtratoBancario.isWithData(itensDia)) {
                    dia.setDataMovimento(itensDia.getFirst().getTransactionDate());
                    LinkedList<ItemConciliacaoExtrato> itensMovimentosDebitos = new LinkedList<ItemConciliacaoExtrato>();
                    LinkedList<ItemConciliacaoExtrato> itensMovimentosCreditos = new LinkedList<ItemConciliacaoExtrato>();
                    for (Statements.Statement i : itensDia) {
                        ItemConciliacaoExtrato vo = new ItemConciliacaoExtrato();
                        vo.setValor(i.getAmount());
                        vo.setDescricao(i.getTransactionName());
                        vo.setDataMovimento(i.getTransactionDate());
                        vo.setConciliado(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
                        vo.setConciliacaoBancariaDia(dia);
                        if (this.isEquals(i.getCreditDebitType(), EnumCreditDebitType.CREDITO)) {
                            vo.setDebCred(Short.valueOf((short)1));
                            totalConcCredito = totalConcCredito + vo.getValor();
                            itensMovimentosCreditos.add(vo);
                        } else if (this.isEquals(i.getCreditDebitType(), EnumCreditDebitType.DEBITO)) {
                            vo.setDebCred(Short.valueOf((short)0));
                            totalConcDebito = totalConcDebito + vo.getValor();
                            itensMovimentosDebitos.add(vo);
                        }
                        dia.getItemConciliacaoExtrato().add(vo);
                    }
                    dia.setValorCreditosExtrato(totalConcCredito);
                    dia.setValorDebitosExtrato(totalConcDebito);
                    dia.setValorSaldoAtualExtrato(Double.valueOf(dia.getValorSaldoAnteriorExtrato() + totalConcCredito - totalConcDebito));
                    List<MovimentoBancario> movimentosFin = this.serviceMovBancario.finsMovimentosByDataCompAndConta(dia.getDataMovimento(), conciliacao.getContaValores());
                    this.compGeradorMovimentosConciliacao.criarItemMovimentoConciliacao(dia, movimentosFin, itensMovimentosDebitos, itensMovimentosCreditos);
                }
                conciliacoes.add(dia);
            }
            this.conciliarItensViaParametrizacaoBancaria(conciliacoes);
            if (SCompProcessarExtratoBancario.isWithData(conciliacoes)) {
                this.compTotalizadoresConciliacao.calcularTotalizadoresConciliacaoDia(conciliacoes, saldoAnteriorExtrato, saldoAnteriorExtrato);
            }
            conciliacao.setConciliacaoBancariaDia(conciliacoes);
        }
    }

    private void conciliarItensViaParametrizacaoBancaria(List<ConciliacaoBancariaDia> conciliacoes) throws ExceptionInvalidData {
        for (ConciliacaoBancariaDia cc : conciliacoes) {
            if (!SCompProcessarExtratoBancario.isWithData(cc.getItemConciliacaoExtrato())) continue;
            for (ItemConciliacaoExtrato cce : cc.getItemConciliacaoExtrato()) {
                ModeloLancBancario modeloLancFin;
                if (this.isAffimative(cce.getConciliado()) || !this.isNotNull(modeloLancFin = this.compBuscarParamItemExtrato.buscarModeloLancBancario(cce)).booleanValue()) continue;
                ItemConciliacaoMovimento itemConcMov = this.compGeradorMovFinanceiro.criarMovimentoFinanceiro(cc, cce, modeloLancFin);
                cc.getItemConciliacaoMovimento().add(itemConcMov);
            }
        }
    }
}

