/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.condicoespagamento;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoCondicoesPagamentoImpl;
import com.touchcomp.basementorservice.helpers.impl.condicoespagamento.HelperCondicoesPagamento;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.touchvomodel.vo.condicoespagamento.web.DTOCondicoesPagamento;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceCondicoesPagamentoImpl
extends ServiceGenericEntityImpl<CondicoesPagamento, Long, DaoCondicoesPagamentoImpl> {
    HelperCondicoesPagamento helperCondicoesPagamento;

    @Autowired
    public ServiceCondicoesPagamentoImpl(DaoCondicoesPagamentoImpl genericDao, HelperCondicoesPagamento helperCondicoesPagamento) {
        super(genericDao);
        this.helperCondicoesPagamento = helperCondicoesPagamento;
    }

    @Override
    public CondicoesPagamento beforeSaveEntity(CondicoesPagamento aux) {
        if (this.isEquals(aux.getMutanteFixa(), EnumConstantsMentorSimNao.SIM.getValue())) {
            int res = this.helperCondicoesPagamento.calcularNrDiasMedios(aux, aux.getParcelasMutante());
            if (aux.getNrMaximoDiasMedios() > res) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0104.001", new Object[]{res}));
            }
        }
        return aux;
    }

    public List<CondicoesPagamento> getCondicoesPagamentoSaida() {
        return ((DaoCondicoesPagamentoImpl)this.getGenericDao()).getCondicoesPagamentoSaida();
    }

    public List<CondicoesPagamento> getCondicoesPagamentoEntrada() {
        return ((DaoCondicoesPagamentoImpl)this.getGenericDao()).getCondicoesPagamentoEntrada();
    }

    public List<CondicoesPagamento> getCondicoesSemPagDev() {
        return ((DaoCondicoesPagamentoImpl)this.getDao()).getCondicoesSemPagDev();
    }

    public List<CondicoesPagamento> getCondicoesPagamentoMutante() {
        return ((DaoCondicoesPagamentoImpl)this.getDao()).getCondicaoPagamentoMutante();
    }

    public List<DTOCondicoesPagamento> getCondicoesPagamentoSaidaDTO() {
        return this.buildToDTOGeneric(this.getCondicoesPagamentoSaida(), DTOCondicoesPagamento.class);
    }

    public List<DTOCondicoesPagamento> getCondicoesPagamentoEntradaDTO() {
        return this.buildToDTOGeneric(this.getCondicoesPagamentoEntrada(), DTOCondicoesPagamento.class);
    }

    public List<CondicoesPagamento> getCondicaoPagMutanteSemFixo() {
        return ((DaoCondicoesPagamentoImpl)this.getDao()).getCondicaoPagMutanteSemFixo();
    }

    public CondicoesPagamento getCondicoesPagamentoByCodSincronizacao(String codigo) {
        return ((DaoCondicoesPagamentoImpl)this.getGenericDao()).getCondicoesPagamentoByCodSincronizacao(codigo);
    }
}

