/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.conferencianfterceiros;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.confnfterceiros.EnumConstTipoConfNFTercItens;
import com.touchcomp.basementor.constants.enums.relacionamentopessoa.EnumConstTipoConfNFProduto;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTituloProvReal;
import com.touchcomp.basementor.model.vo.ConferenciaNFTerceiros;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.InfPagamentoNfTerceiros;
import com.touchcomp.basementor.model.vo.IntegracaoNotaTerceirosNotas;
import com.touchcomp.basementor.model.vo.ItemConfNFTerceiros;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.LiberacaoNFTerceiros;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.database.ExceptionDatabase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais.CompLancamentosEntradaSaidaFiscais;
import com.touchcomp.basementorservice.components.requisicao.impl.CompRequisicaoNotaFiscalTerceiros;
import com.touchcomp.basementorservice.dao.impl.DaoLoteFabricacaoImpl;
import com.touchcomp.basementorservice.helpers.impl.lotefabricacao.HelperLoteFabricacao;
import com.touchcomp.basementorservice.helpers.impl.notaterceiros.HelperItemNotaTerceiros;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.requisicao.ServiceRequisicaoImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.conferencianfterceiros.web.DTOConfItemNotaTerceiros;
import com.touchcomp.touchvomodel.vo.conferencianfterceiros.web.DTOConferenciaNFTerceiros;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SCompConferenciaNFTerceiros
extends ServiceGenericImpl {
    @Autowired
    ServiceRequisicaoImpl serviceRequisicao;
    @Autowired
    ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceiros;
    @Autowired
    HelperLoteFabricacao helperLoteFabricao;
    @Autowired
    HelperItemNotaTerceiros helperItemNotaTerceiros;
    @Autowired
    ServiceLoteFabricacaoImpl serviceLoteFabricacao;
    @Autowired
    ServiceGradeCorImpl serviceGradeCor;
    @Autowired
    CompLancamentosEntradaSaidaFiscais compLancamentosEntradaSaidaFiscais;
    @Autowired
    CompRequisicaoNotaFiscalTerceiros compRequisicaoNotaFiscalTerceiros;

    public LiberacaoNFTerceiros criarLiberacoes(LiberacaoNFTerceiros liberacao, OpcoesCompraSuprimentos opcoesCompra, EmpresaContabilidade empresaContabilidade, boolean liberada, OpcoesContabeis op) throws ExceptionDatabase, ExceptionInvalidData {
        liberacao.setConferidaTotalmente(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        liberacao.setDataConferenciaTotal(new Date());
        NotaFiscalTerceiros nota = liberacao.getNotaTerceiros();
        nota = this.atualizarDataNF(nota, opcoesCompra);
        nota = this.atualizarTitulosNotaTerceiros(nota, opcoesCompra, liberada);
        nota = this.atualizarMovimentacaoEstoqueNotaTerceiros(nota, opcoesCompra, liberada);
        nota = this.gerarLivrosFiscais(nota, opcoesCompra, liberada);
        nota = this.gerarLancamentosContabeis(nota, empresaContabilidade, opcoesCompra, liberada, op);
        nota = this.atualizarNotaTerceiros(nota);
        this.gerarRequisicao(nota);
        return liberacao;
    }

    public void isValidAndCreateUltimaLiberacao(OpcoesCompraSuprimentos opcoesCompra, LiberacaoNFTerceiros liberacao, EmpresaContabilidade empresaContabilidade, boolean liberada, OpcoesContabeis op) throws ExceptionInvalidData {
        if (this.isNotNull(liberacao.getLiberacaoEstoque()).booleanValue() && this.isAffimative(liberacao.getLiberacaoEstoque().getConferida())) {
            this.criarLiberacoes(liberacao, opcoesCompra, empresaContabilidade, liberada, op);
        }
        if (this.isNotNull(liberacao.getLiberacaoFinanceira()).booleanValue() && this.isAffimative(liberacao.getLiberacaoFinanceira().getConferida())) {
            this.criarLiberacoes(liberacao, opcoesCompra, empresaContabilidade, liberada, op);
        }
        if (this.isNotNull(liberacao.getLiberacaoFiscal()).booleanValue() && this.isAffimative(liberacao.getLiberacaoFiscal().getConferida())) {
            this.criarLiberacoes(liberacao, opcoesCompra, empresaContabilidade, liberada, op);
        }
        if (this.isNotNull(liberacao.getLiberacaoQualidade()).booleanValue() && this.isAffimative(liberacao.getLiberacaoQualidade().getConferida())) {
            this.criarLiberacoes(liberacao, opcoesCompra, empresaContabilidade, liberada, op);
        }
    }

    public void notaConferida(ConferenciaNFTerceiros vo) {
        if (this.isAffimative(vo.getLiberarConferencia())) {
            vo.setConferida(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            return;
        }
        OpcoesCompraSuprimentos opcoesCompra = this.getSharedData().getOpcoesCompraSuprimentos(vo.getEmpresa());
        boolean flag = true;
        for (ItemConfNFTerceiros i : vo.getItemConfNFTerceiros()) {
            if (!this.conferirProduto(i.getGradeCor(), opcoesCompra).booleanValue() || this.isEquals(i.getQuantidadeAConferir(), i.getQuantidadeConferida()) || this.isAffimative(i.getInfManualmente())) continue;
            flag = false;
            break;
        }
        if (flag) {
            vo.setConferida(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            return;
        }
        vo.setConferida(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
    }

    private NotaFiscalTerceiros gerarRequisicao(NotaFiscalTerceiros nota) throws ExceptionDatabase {
        Requisicao r = this.compRequisicaoNotaFiscalTerceiros.criarRequisicaoNotaTerceiros(nota);
        if (r != null) {
            r.setNotaFiscalTerc(nota);
            nota.setRequisicao(this.serviceRequisicao.saveOrUpdate(r));
        }
        return nota;
    }

    public NotaFiscalTerceiros atualizarNotaTerceiros(NotaFiscalTerceiros nota) throws ExceptionDatabase {
        if (this.isNotNull(nota.getRequisicao()).booleanValue()) {
            this.serviceRequisicao.delete(nota.getRequisicao());
            this.serviceRequisicao.flushData();
            nota.setRequisicao(null);
        }
        this.atualizarQtdTotalItensNota(nota);
        nota = this.serviceNotaFiscalTerceiros.saveOrUpdate(nota);
        return nota;
    }

    private NotaFiscalTerceiros gerarLancamentosContabeis(NotaFiscalTerceiros nota, EmpresaContabilidade empresaContabilidade, OpcoesCompraSuprimentos opcoesCompra, Boolean liberado, OpcoesContabeis op) throws ExceptionInvalidData {
        if (this.isNull(opcoesCompra.getUtilizarSomenteLibSel()).booleanValue() || !this.isAffimative(opcoesCompra.getUtilizarSomenteLibSel())) {
            this.contabilizar(nota, empresaContabilidade, liberado, op);
        } else if (this.isAffimative(opcoesCompra.getLiberacaoFiscal())) {
            this.contabilizar(nota, empresaContabilidade, liberado, op);
        }
        return nota;
    }

    private void contabilizar(NotaFiscalTerceiros nota, EmpresaContabilidade empresaContabilidade, Boolean liberado, OpcoesContabeis op) throws ExceptionInvalidData {
        if (liberado.booleanValue()) {
            if (this.isEquals(empresaContabilidade.getLancNotaTerceiros(), (short)0)) {
                LoteContabil loteContabil = this.compLancamentosEntradaSaidaFiscais.contabilizar(nota, op);
                IntegracaoNotaTerceirosNotas i = nota.getIntegracaoNotaTerceiros();
                if (this.isNull(i).booleanValue()) {
                    i = new IntegracaoNotaTerceirosNotas();
                    i.setNotaFiscalTerceiros(nota);
                }
                i.setLoteContabil(loteContabil);
                nota.setIntegracaoNotaTerceiros(i);
            }
        } else {
            nota.setIntegracaoNotaTerceiros(null);
        }
    }

    private NotaFiscalTerceiros gerarLivrosFiscais(NotaFiscalTerceiros nota, OpcoesCompraSuprimentos opcoesCompra, Boolean liberado) {
        if (this.isNull(opcoesCompra.getUtilizarSomenteLibSel()).booleanValue() || !this.isAffimative(opcoesCompra.getUtilizarSomenteLibSel())) {
            if (liberado.booleanValue()) {
                this.atualizarStatusLivroFiscal(nota, EnumConstantsMentorSimNao.NAO);
            } else {
                this.atualizarStatusLivroFiscal(nota, EnumConstantsMentorSimNao.SIM);
            }
        } else if (this.isAffimative(opcoesCompra.getLiberacaoFiscal())) {
            if (liberado.booleanValue()) {
                this.atualizarStatusLivroFiscal(nota, EnumConstantsMentorSimNao.NAO);
            } else {
                this.atualizarStatusLivroFiscal(nota, EnumConstantsMentorSimNao.SIM);
            }
        }
        return nota;
    }

    private void atualizarStatusLivroFiscal(NotaFiscalTerceiros nota, EnumConstantsMentorSimNao cancelado) {
        if (SCompConferenciaNFTerceiros.isWithData(nota.getLivrosFiscais())) {
            for (LivroFiscal lv : nota.getLivrosFiscais()) {
                lv.setCancelado(Short.valueOf(cancelado.getValue()));
            }
        }
    }

    public NotaFiscalTerceiros atualizarMovimentacaoEstoqueNotaTerceiros(NotaFiscalTerceiros notaTerceiros, OpcoesCompraSuprimentos opcoesCompra, Boolean liberado) {
        if (this.isNull(opcoesCompra.getUtilizarSomenteLibSel()).booleanValue() || !this.isAffimative(opcoesCompra.getUtilizarSomenteLibSel())) {
            this.atualizaMovimentacaoFisica(notaTerceiros, liberado);
        } else if (this.isAffimative(opcoesCompra.getLiberacaoEstoque())) {
            this.atualizaMovimentacaoFisica(notaTerceiros, liberado);
        }
        return notaTerceiros;
    }

    private void atualizaMovimentacaoFisica(NotaFiscalTerceiros nota, Boolean liberada) {
        if (SCompConferenciaNFTerceiros.isWithData(nota.getItemNotaTerceiros())) {
            for (ItemNotaTerceiros item : nota.getItemNotaTerceiros()) {
                if (!this.isAffimative(item.getModeloFiscal().getMovimentacaoFisica())) continue;
                for (GradeItemNotaTerceiros gr : item.getGrade()) {
                    if (liberada.booleanValue()) {
                        gr.setMovimentacaoFisica(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
                        continue;
                    }
                    gr.setMovimentacaoFisica(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
                }
            }
        }
    }

    private NotaFiscalTerceiros atualizarDataNF(NotaFiscalTerceiros nota, OpcoesCompraSuprimentos opcoesCompra) {
        if (this.isAffimative(opcoesCompra.getAtualizarDataNFLiberacao())) {
            nota.setDataEntrada(new Date());
            for (ItemNotaTerceiros i : nota.getItemNotaTerceiros()) {
                for (GradeItemNotaTerceiros g : i.getGrade()) {
                    g.setDataEntradaSaida(nota.getDataEntrada());
                }
            }
            for (LivroFiscal l : nota.getLivrosFiscais()) {
                l.setDataLivro(nota.getDataEntrada());
            }
        }
        return nota;
    }

    private NotaFiscalTerceiros atualizarTitulosNotaTerceiros(NotaFiscalTerceiros notaTerceiros, OpcoesCompraSuprimentos opcoesCompra, Boolean liberado) {
        if (this.isNull(opcoesCompra.getUtilizarSomenteLibSel()).booleanValue() || !this.isAffimative(opcoesCompra.getUtilizarSomenteLibSel())) {
            this.atualizarProvisaoTitulo(notaTerceiros, liberado);
        } else if (this.isAffimative(opcoesCompra.getLiberacaoFinanceiro())) {
            this.atualizarProvisaoTitulo(notaTerceiros, liberado);
        }
        return notaTerceiros;
    }

    private void atualizarProvisaoTitulo(NotaFiscalTerceiros notaTerceiros, Boolean liberado) {
        if (SCompConferenciaNFTerceiros.isWithData(notaTerceiros.getInfPagamentoNfTerceiros())) {
            for (InfPagamentoNfTerceiros inf : notaTerceiros.getInfPagamentoNfTerceiros()) {
                for (Titulo t : inf.getTitulos()) {
                    if (liberado.booleanValue()) {
                        t.setProvisao(EnumConstTituloProvReal.REALIZADO.getValue());
                        continue;
                    }
                    t.setProvisao(EnumConstTituloProvReal.PROVISIONADO.getValue());
                }
            }
        }
    }

    private HashMap<GradeCor, Double> agruparItensPorGradeCor(ItemNotaTerceiros item) {
        HashMap<GradeCor, Double> h = new HashMap<GradeCor, Double>();
        for (GradeItemNotaTerceiros g : item.getGrade()) {
            if (h.containsKey(g.getGradeCor())) {
                Double qtdeAnt = h.get(g.getGradeCor());
                h.put(g.getGradeCor(), qtdeAnt + g.getQuantidade() * item.getFatorConversao());
                continue;
            }
            h.put(g.getGradeCor(), g.getQuantidade() * item.getFatorConversao());
        }
        return h;
    }

    private HashMap<ItemConfNFTerceiros, Boolean> buildItemConfNFTerceiros(GradeCor gradeCor, Double qtde, OpcoesCompraSuprimentos opcoesCompraSup) {
        HashMap<ItemConfNFTerceiros, Boolean> hs = new HashMap<ItemConfNFTerceiros, Boolean>();
        ItemConfNFTerceiros itemConf = new ItemConfNFTerceiros();
        itemConf.setGradeCor(gradeCor);
        itemConf.setQuantidadeAConferir(qtde);
        hs.put((ItemConfNFTerceiros)"itemConferencia", (Boolean)itemConf);
        hs.put((ItemConfNFTerceiros)"conferir", this.conferirProduto(gradeCor, opcoesCompraSup));
        return hs;
    }

    public List<DTOConferenciaNFTerceiros.DTOItemConfNFTerceiros> criarItensConfNFTerceiros(NotaFiscalTerceiros notaTerceiros, List<DTOConferenciaNFTerceiros.DTOItemConfNFTerceiros> itensConferidos, OpcoesCompraSuprimentos opcoesCompraSup) {
        ArrayList<Object> dados = new ArrayList<Object>();
        for (ItemNotaTerceiros i : notaTerceiros.getItemNotaTerceiros()) {
            HashMap<GradeCor, Double> hashMap = this.agruparItensPorGradeCor(i);
            for (GradeCor gradeCor : hashMap.keySet()) {
                HashMap<ItemConfNFTerceiros, Boolean> hs = this.buildItemConfNFTerceiros(gradeCor, hashMap.get(gradeCor), opcoesCompraSup);
                dados.add(hs);
            }
        }
        ArrayList<DTOConferenciaNFTerceiros.DTOItemConfNFTerceiros> result = new ArrayList<DTOConferenciaNFTerceiros.DTOItemConfNFTerceiros>();
        for (HashMap hashMap : dados) {
            ItemConfNFTerceiros itemNovo = (ItemConfNFTerceiros)hashMap.get("itemConferencia");
            Boolean exists = false;
            if (SCompConferenciaNFTerceiros.isWithData(itensConferidos)) {
                for (DTOConferenciaNFTerceiros.DTOItemConfNFTerceiros itemAntigo : itensConferidos) {
                    if (!this.isEquals(itemNovo.getGradeCor().getIdentificador(), itemAntigo.getGradeCorIdentificador())) continue;
                    itemAntigo.setQuantidadeAConferir(Double.valueOf(itemNovo.getQuantidadeAConferir() + itemAntigo.getQuantidadeAConferir()));
                    itemAntigo.setQuantidadeConferida(Double.valueOf(itemNovo.getQuantidadeConferida() + itemAntigo.getQuantidadeConferida()));
                    result.add(itemAntigo);
                    exists = true;
                    break;
                }
            }
            if (exists.booleanValue()) continue;
            DTOConferenciaNFTerceiros.DTOItemConfNFTerceiros dto = this.buildToDTOGeneric(itemNovo, DTOConferenciaNFTerceiros.DTOItemConfNFTerceiros.class);
            dto.setConferir((Boolean)hashMap.get("conferir"));
            result.add(dto);
        }
        return result;
    }

    private Boolean conferirProduto(GradeCor gradeCor, OpcoesCompraSuprimentos opcoesCompraSuprimentos) {
        if (!this.isEquals(opcoesCompraSuprimentos.getTipoConfNFTerceirosItens(), EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.getValue())) {
            return true;
        }
        if (this.isNull(gradeCor.getProdutoGrade().getProduto().getTipoConfNFTerceirosProduto()).booleanValue()) {
            return false;
        }
        return this.isEquals(gradeCor.getProdutoGrade().getProduto().getTipoConfNFTerceirosProduto().getTipo(), EnumConstTipoConfNFProduto.CONFERIR.getValue());
    }

    public void conferenciaItensSubstitucaoLotes(NotaFiscalTerceiros nota, DTOConferenciaNFTerceiros conferencia, Usuario usuario) throws ExceptionObjNotFound {
        conferencia.getItemConfNFTerceiros().clear();
        this.substituirLotesProduto(nota, usuario, conferencia);
        conferencia.setLiberarConferencia(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        conferencia.setMotivoLiberacao("Liberada pelo sistema (Modo Confer\u00ef\u00bf\u00bdncia com Altera\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo de Lotes)");
    }

    public List<DTOConfItemNotaTerceiros> carregarItensConfComLotes(NotaFiscalTerceiros nota, ConferenciaNFTerceiros conf) {
        ArrayList<DTOConfItemNotaTerceiros> ret = new ArrayList<DTOConfItemNotaTerceiros>();
        for (ItemNotaTerceiros item : nota.getItemNotaTerceiros()) {
            DTOConfItemNotaTerceiros i = new DTOConfItemNotaTerceiros();
            i.setCodigoAuxiliar(item.getProduto().getCodigoAuxiliar());
            i.setProduto(item.getProduto().getNome());
            i.setProdutoIdentificador(item.getProduto().getIdentificador());
            i.setQtdeNaoFracionada(item.getProduto().getQtdeNaoFracionada());
            i.setItemNotaTerceirosIdentificador(item.getIdentificador());
            for (GradeItemNotaTerceiros grade : item.getGrade()) {
                Optional<ItemConfNFTerceiros> opt;
                DTOConfItemNotaTerceiros.DTOConfGradeNotaTerceiros g = new DTOConfItemNotaTerceiros.DTOConfGradeNotaTerceiros();
                g.setGrade(String.valueOf(grade.getGradeCor()));
                g.setGradeCorIdentificador(grade.getGradeCor().getIdentificador());
                g.setGradeNotaTerceirosIdentificador(grade.getIdentificador());
                g.setQuantidadeGrade(grade.getQuantidade());
                if (this.isNotNull(grade.getLoteFabricacao()).booleanValue()) {
                    g.setDataFabricacao(grade.getLoteFabricacao().getDataFabricacao());
                    g.setDataValidade(grade.getLoteFabricacao().getDataValidade());
                    g.setLoteFabricacao(grade.getLoteFabricacao().getLoteFabricacao());
                }
                if (this.isNotNull(conf).booleanValue() && (opt = conf.getItemConfNFTerceiros().stream().filter(j -> this.isEquals(j.getGradeCor(), grade.getGradeCor()) && this.isEquals(j.getQuantidadeAConferir(), grade.getQuantidade())).findAny()).isPresent()) {
                    g.setQuantidadeGrade(opt.get().getQuantidadeAConferir());
                    g.setQuantidadeLote(opt.get().getQuantidadeConferida());
                }
                i.getGrades().add(g);
            }
            ret.add(i);
        }
        return ret;
    }

    private void substituirLotesProduto(NotaFiscalTerceiros nota, Usuario usuario, DTOConferenciaNFTerceiros conferencia) throws ExceptionObjNotFound {
        List itensConf = conferencia.getLotes();
        if (TMethods.isNull((Object)nota).booleanValue() || !TMethods.isWithData((Collection)itensConf) || !TMethods.isWithData((Collection)nota.getItemNotaTerceiros())) {
            return;
        }
        for (DTOConfItemNotaTerceiros dtoItem : itensConf) {
            Optional<ItemNotaTerceiros> opt = nota.getItemNotaTerceiros().stream().filter(i -> this.isEquals(i.getIdentificador(), dtoItem.getItemNotaTerceirosIdentificador())).findFirst();
            if (!opt.isPresent()) continue;
            ItemNotaTerceiros item = opt.get();
            ArrayList<GradeItemNotaTerceiros> aux = new ArrayList<GradeItemNotaTerceiros>();
            for (DTOConfItemNotaTerceiros.DTOConfGradeNotaTerceiros dtoGrade : dtoItem.getGrades()) {
                GradeItemNotaTerceiros grade;
                Optional<GradeItemNotaTerceiros> optGrade = item.getGrade().stream().filter(i -> this.isEquals(i.getIdentificador(), dtoGrade.getGradeNotaTerceirosIdentificador())).findFirst();
                if (optGrade.isPresent()) {
                    grade = optGrade.get();
                    grade.setQuantidade(dtoGrade.getQuantidadeLote());
                } else {
                    grade = this.criarGrade(item, dtoGrade);
                }
                grade.setLoteFabricacao(this.novoLoteFabricacao(grade, usuario, dtoGrade));
                conferencia.getItemConfNFTerceiros().add(this.novoItemConferencia(grade, dtoGrade.getQuantidadeLote()));
                aux.add(grade);
            }
            item.getGrade().clear();
            item.getGrade().addAll(aux);
        }
        this.serviceNotaFiscalTerceiros.saveOrUpdateOnly(nota);
    }

    private GradeItemNotaTerceiros criarGrade(ItemNotaTerceiros item, DTOConfItemNotaTerceiros.DTOConfGradeNotaTerceiros dtoGrade) throws ExceptionObjNotFound {
        GradeItemNotaTerceiros grade = new GradeItemNotaTerceiros();
        if (SCompConferenciaNFTerceiros.isWithData(item.getGrade())) {
            GradeItemNotaTerceiros gr = (GradeItemNotaTerceiros)item.getGrade().getFirst();
            grade.setAuxTrigger(gr.getAuxTrigger());
            grade.setCentroEstoque(gr.getCentroEstoque());
            grade.setDataEntradaSaida(gr.getDataEntradaSaida());
            grade.setEmpresa(gr.getEmpresa());
            grade.setEstoqueTerceiros(gr.getEstoqueTerceiros());
            grade.setFatorConversao(gr.getFatorConversao());
            grade.setItemNotaTerceiros(item);
            grade.setMovimentacaoFisica(grade.getMovimentacaoFisica());
        } else {
            grade.setEmpresa(item.getNotaFiscalTerceiros().getEmpresa());
            grade.setDataEntradaSaida(item.getNotaFiscalTerceiros().getDataEmissao());
            grade.setFatorConversao(Double.valueOf(1.0));
        }
        grade.setQuantidade(dtoGrade.getQuantidadeLote());
        grade.setGradeCor((GradeCor)this.serviceGradeCor.getOrThrow(dtoGrade.getGradeCorIdentificador()));
        grade.setValorCusto(Double.valueOf(0.0));
        grade.setValorTransfFiscal(Double.valueOf(0.0));
        if (item.getQuantidadeTotal() > 0.0 && grade.getFatorConversao() > 0.0) {
            Double d = (item.getVrProduto() + item.getVrServico() + item.getItemNotaLivroFiscal().getVrIpiComercio() + item.getItemNotaLivroFiscal().getVrIpiIndustria() + item.getItemNotaLivroFiscal().getVrIpiObservacao() + item.getItemNotaLivroFiscal().getVrIcmsSt()) / (item.getQuantidadeTotal() * grade.getFatorConversao());
            grade.setValorUltPrecoCompra(d);
        }
        return grade;
    }

    private DTOConferenciaNFTerceiros.DTOItemConfNFTerceiros novoItemConferencia(GradeItemNotaTerceiros grade, Double quantidade) {
        DTOConferenciaNFTerceiros.DTOItemConfNFTerceiros itemConf = new DTOConferenciaNFTerceiros.DTOItemConfNFTerceiros();
        itemConf.setCodigoAuxiliar(grade.getItemNotaTerceiros().getProduto().getCodigoAuxiliar());
        itemConf.setProduto(grade.getItemNotaTerceiros().getProduto().getNome());
        itemConf.setProdutoIdenticador(grade.getItemNotaTerceiros().getProduto().getIdentificador());
        itemConf.setGradeCor(String.valueOf(grade.getGradeCor()));
        itemConf.setGradeCorIdentificador(grade.getGradeCor().getIdentificador());
        itemConf.setInfManualmente(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        itemConf.setLiberarConferenciaManual(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        itemConf.setQuantidadeAConferir(grade.getQuantidade());
        if (this.isAffimative(grade.getItemNotaTerceiros().getProduto().getQtdeNaoFracionada())) {
            itemConf.setQuantidadeConferida(this.arredondaNumero(quantidade, 0));
        } else {
            itemConf.setQuantidadeConferida(quantidade);
        }
        return itemConf;
    }

    private LoteFabricacao novoLoteFabricacao(GradeItemNotaTerceiros grade, Usuario usuario, DTOConfItemNotaTerceiros.DTOConfGradeNotaTerceiros dtoGradelote) {
        LoteFabricacao lote = this.serviceLoteFabricacao.findLoteFabricacao(grade.getItemNotaTerceiros().getProduto(), dtoGradelote.getLoteFabricacao());
        if (this.isNull(lote).booleanValue()) {
            lote = this.helperLoteFabricao.getLoteUnico(grade.getGradeCor());
            lote.setDataFabricacao(dtoGradelote.getDataFabricacao());
            lote.setDataValidade(dtoGradelote.getDataValidade());
            lote.setLoteFabricacao(dtoGradelote.getLoteFabricacao());
            lote.setDataLiberacao(new Date());
            lote.setUsuario(usuario);
            lote = this.serviceLoteFabricacao.saveOrUpdateFlush(lote);
        } else if (!this.isEquals(lote.getDataFabricacao(), dtoGradelote.getDataFabricacao()) || !this.isEquals(lote.getDataValidade(), dtoGradelote.getDataValidade())) {
            lote.setDataFabricacao(dtoGradelote.getDataFabricacao());
            lote.setDataValidade(dtoGradelote.getDataValidade());
            lote = (LoteFabricacao)((DaoLoteFabricacaoImpl)this.serviceLoteFabricacao.getGenericDao()).getSession().merge((Object)lote);
        }
        return lote;
    }

    private void atualizarQtdTotalItensNota(NotaFiscalTerceiros nota) {
        if (SCompConferenciaNFTerceiros.isWithData(nota.getItemNotaTerceiros())) {
            for (ItemNotaTerceiros item : nota.getItemNotaTerceiros()) {
                this.helperItemNotaTerceiros.build(item).calcularQuantidadeTotalItem();
            }
        }
    }
}

