/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.conferencianfterceiros;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.conferencianfterceiros.EnumConstModoConferenciaNFTerceiros;
import com.touchcomp.basementor.constants.enums.estoque.EnumTipoArquivoColetorCodBarras;
import com.touchcomp.basementor.constants.enums.liberacaonotaterceiros.EnumLiberacaoNFTerceiros;
import com.touchcomp.basementor.model.vo.CodigoBarras;
import com.touchcomp.basementor.model.vo.ConferenciaNFTerceiros;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LiberacaoNFTerceiros;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.database.ExceptionDatabase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.conferencianfterceiros.CompConferenciaNFTerceiros;
import com.touchcomp.basementorservice.dao.impl.DaoConferenciaNFTerceirosImpl;
import com.touchcomp.basementorservice.dao.impl.DaoNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.helpers.impl.liberacaonotaterceiros.HelperLiberacaoNotaTerceiros;
import com.touchcomp.basementorservice.model.TempSaveObj;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.conferencianfterceiros.SCompConferenciaNFTerceiros;
import com.touchcomp.basementorservice.service.impl.empresacontabilidade.ServiceEmpresaContabilidadeImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.liberacaonfterceiros.SCompLiberacaoNFTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.proccodigobarras.ServiceProcCodigoBarrasImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementorvalidator.crud.ValidGenericCrud;
import com.touchcomp.basementorvalidator.entities.ValidGeneric;
import com.touchcomp.touchvomodel.vo.DTOObjectInterface;
import com.touchcomp.touchvomodel.vo.conferencianfterceiros.web.DTOConferenciaNFTerceiros;
import com.touchcomp.touchvomodel.vo.notafiscalterceiros.web.DTONotaFiscalTerceirosRes;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import com.touchcomp.touchvomodel.web.WebDTOSaveResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ServiceConferenciaNFTerceirosImpl
extends ServiceGenericEntityImpl<ConferenciaNFTerceiros, Long, DaoConferenciaNFTerceirosImpl> {
    @Autowired
    HelperLiberacaoNotaTerceiros helperLiberacaoNotaTerceiros;
    @Autowired
    ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceiros;
    @Autowired
    ServiceProcCodigoBarrasImpl serviceProcCodigoBarras;
    @Autowired
    ServiceGradeCorImpl serviceGradeCor;
    @Autowired
    ServiceEmpresaContabilidadeImpl serviceEmpresaContabilidade;
    @Autowired
    SCompLiberacaoNFTerceirosImpl compLiberacaoNFTerceiros;
    @Autowired
    SCompConferenciaNFTerceiros compConferenciaNFTerceiros;

    @Autowired
    public ServiceConferenciaNFTerceirosImpl(DaoConferenciaNFTerceirosImpl dao) {
        super(dao);
    }

    public TempSaveObj<ConferenciaNFTerceiros> save(DTOConferenciaNFTerceiros dto, ValidGeneric<ConferenciaNFTerceiros> validator, ValidGenericCrud<ConferenciaNFTerceiros> validatorCrud) throws ExceptionObjNotFound {
        LiberacaoNFTerceiros lib;
        ConferenciaNFTerceiros toSave = (ConferenciaNFTerceiros)this.buildToEntity(dto);
        TempSaveObj<ConferenciaNFTerceiros> validResult = this.validate(toSave, validator, validatorCrud);
        if (validResult.getStatus().isErro()) {
            validResult.setStatus(EnumConstantsMentorStatus.ERRO);
            return validResult;
        }
        if (this.isEquals(toSave.getModoConferencia(), EnumConstModoConferenciaNFTerceiros.CONFERENCIA_ALTERACAO_LOTES.getValue())) {
            dto = this.buildItensConferenciaPorLotes(toSave.getUsuario(), dto);
            toSave = (ConferenciaNFTerceiros)this.buildToEntity(dto);
        }
        if (this.isNull(lib = toSave.getLiberacaoNota()).booleanValue()) {
            NotaFiscalTerceiros notaTerceiros = (NotaFiscalTerceiros)this.serviceNotaFiscalTerceiros.getOrThrow(dto.getNotaFiscalTerceirosIdentificador());
            lib = new LiberacaoNFTerceiros();
            lib.setNotaTerceiros(notaTerceiros);
            lib.setLiberacaoEstoque(toSave);
            notaTerceiros.setLiberacaoNFTerceiros(lib);
            toSave.setLiberacaoNota(lib);
        }
        ConferenciaNFTerceiros res = this.saveOrUpdate(toSave);
        validResult.setDtoResult((DTOObjectInterface)this.buildToDTOGeneric(res, WebDTOSaveResult.class));
        return validResult;
    }

    @Override
    public ConferenciaNFTerceiros beforeSaveEntity(ConferenciaNFTerceiros vo) {
        String idProduto;
        this.compConferenciaNFTerceiros.notaConferida(vo);
        if (this.isAffimative(vo.getConferida()) || this.isAffimative(vo.getLiberarConferencia())) {
            vo.setDataLiberacao(new Timestamp(new Date().getTime()));
        }
        if (ServiceConferenciaNFTerceirosImpl.isWithData(vo.getItemConfNFTerceiros())) {
            vo.getItemConfNFTerceiros().forEach(i -> i.setConferenciaNFTerceiros(vo));
        }
        if (this.isStrWithData(idProduto = vo.getItemConfNFTerceiros().stream().filter(i -> this.isEquals(i.getInfManualmente(), EnumConstantsMentorSimNao.SIM.getValue()) && this.isEquals(i.getGradeCor().getProdutoGrade().getProduto().getLiberarConferenciaManual(), EnumConstantsMentorSimNao.NAO.getValue())).map(item -> String.valueOf(item.getGradeCor().getProdutoGrade().getProduto().getIdentificador())).collect(Collectors.joining(",")))) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0835.011", new String[]{idProduto}));
        }
        return vo;
    }

    @Override
    public ConferenciaNFTerceiros afterSaveEntity(ConferenciaNFTerceiros vo) {
        try {
            if (vo != null) {
                OpcoesCompraSuprimentos opcoesCompra = this.getSharedData().getOpcoesCompraSuprimentos(vo.getEmpresa());
                OpcoesContabeis opcoesContabeis = this.getSharedData().getOpcoesContabeis(vo.getEmpresa());
                EmpresaContabilidade empresaContabilidade = this.serviceEmpresaContabilidade.findByEmpresa(vo.getEmpresa());
                if (this.isAffimative(vo.getConferida()) || this.isAffimative(vo.getLiberarConferencia())) {
                    this.compConferenciaNFTerceiros.isValidAndCreateUltimaLiberacao(opcoesCompra, vo.getLiberacaoNota(), empresaContabilidade, true, opcoesContabeis);
                } else {
                    vo.getLiberacaoNota().setConferidaTotalmente(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
                    NotaFiscalTerceiros nota = vo.getLiberacaoNota().getNotaTerceiros();
                    nota = this.compConferenciaNFTerceiros.atualizarMovimentacaoEstoqueNotaTerceiros(nota, opcoesCompra, false);
                    this.compConferenciaNFTerceiros.atualizarNotaTerceiros(nota);
                }
            }
            return vo;
        }
        catch (ExceptionDatabase | ExceptionInvalidData ex) {
            throw new ExceptionRuntimeBase(ex.getMessage());
        }
    }

    @Override
    public ConferenciaNFTerceiros beforeDeleteEntity(ConferenciaNFTerceiros vo) {
        if (vo != null) {
            if (this.isAffimative(vo.getConferida()) && this.isNotNull(vo.getLiberacaoNota()).booleanValue()) {
                OpcoesCompraSuprimentos opcoesCompra = this.getSharedData().getOpcoesCompraSuprimentos(vo.getEmpresa());
                NotaFiscalTerceiros nota = vo.getLiberacaoNota().getNotaTerceiros();
                this.compConferenciaNFTerceiros.atualizarMovimentacaoEstoqueNotaTerceiros(nota, opcoesCompra, false);
            }
            LiberacaoNFTerceiros l = vo.getLiberacaoNota();
            l.setLiberacaoEstoque(null);
            this.flushData();
            vo = this.saveOrUpdateFlush(vo);
        }
        return vo;
    }

    public List<NotaFiscalTerceiros> findNotasNaoLiberadasEstoque(Date dataInicial, Date dataFinal, Empresa empresa, Usuario usuario, OpcoesCompraSuprimentos opcoesCompras) {
        List<NotaFiscalTerceiros> notas = this.serviceNotaFiscalTerceiros.findNotasNaoLiberadasEstoque(dataInicial, dataFinal, empresa, opcoesCompras);
        if (notas != null) {
            for (NotaFiscalTerceiros n : notas) {
                ((DaoNotaFiscalTerceirosImpl)this.serviceNotaFiscalTerceiros.getGenericDao()).evict(n);
                this.helperLiberacaoNotaTerceiros.build(n).createLiberacaoEstoqueNFT(empresa, usuario);
            }
        }
        return notas;
    }

    public List<DTOConferenciaNFTerceiros.DTOItemConfNFTerceiros> carregarDadosNota(Long idNotaTerceiros, List<DTOConferenciaNFTerceiros.DTOItemConfNFTerceiros> itensConferidos, OpcoesCompraSuprimentos opcoesCompraSup) throws ExceptionObjNotFound, ExceptionInvalidData {
        NotaFiscalTerceiros vo = (NotaFiscalTerceiros)this.serviceNotaFiscalTerceiros.getOrThrow(idNotaTerceiros);
        if (this.isNotNull(vo.getLiberacaoNFTerceiros()).booleanValue() && this.isNotNull(vo.getLiberacaoNFTerceiros().getLiberacaoEstoque()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.0835.001", new Object[0]);
        }
        StringBuilder sb = CompConferenciaNFTerceiros.validaProdutoSemTipoConferenciaInNFT(vo, opcoesCompraSup);
        if (sb.length() > 0) {
            throw new ExceptionInvalidData("E.ERP.0835.002", new Object[]{sb.toString()});
        }
        return this.compConferenciaNFTerceiros.criarItensConfNFTerceiros(vo, itensConferidos, opcoesCompraSup);
    }

    public void conferirProdutoPorCodigoBarras(String codigoBarras, Short conferida, List<DTOConferenciaNFTerceiros.DTOItemConfNFTerceiros> itensConferidos) throws ExceptionInvalidData, ExceptionObjNotFound {
        if (this.isAffimative(conferida)) {
            throw new ExceptionInvalidData("E.ERP.0835.003", new Object[0]);
        }
        if (!this.isStrWithData(codigoBarras)) {
            throw new ExceptionInvalidData("E.ERP.0835.004", new Object[0]);
        }
        if (ServiceConferenciaNFTerceirosImpl.isWithData(itensConferidos)) {
            for (DTOConferenciaNFTerceiros.DTOItemConfNFTerceiros item : itensConferidos) {
                GradeCor gradeCor = (GradeCor)this.serviceGradeCor.getOrThrow(item.getGradeCorIdentificador());
                for (CodigoBarras cod : gradeCor.getProdutoGrade().getProduto().getCodigoBarras()) {
                    if (!cod.getCodigoBarras().equalsIgnoreCase(codigoBarras)) continue;
                    item.setQuantidadeConferida(Double.valueOf(item.getQuantidadeConferida() + 1.0));
                    return;
                }
            }
        }
        throw new ExceptionInvalidData("E.ERP.0835.005", new Object[]{codigoBarras});
    }

    public WebDTOResult processarDadosArquivo(List<DTOConferenciaNFTerceiros.DTOItemConfNFTerceiros> itensConferidos, MultipartFile arquivoColetor, String separador, EnumTipoArquivoColetorCodBarras tipoArquivo) throws ExceptionIO, FileNotFoundException, IOException {
        WebDTOResult result = new WebDTOResult();
        File arquivo = ToolFile.createTempFile((String)"dados_coletor");
        try (FileOutputStream os = new FileOutputStream(arquivo);){
            ((OutputStream)os).write(arquivoColetor.getBytes());
        }
        List<ServiceProcCodigoBarrasImpl.CodigoBarrasItem> dados = this.serviceProcCodigoBarras.processCodigoBarrasColetor(ToolFile.getConteudoArquivo((File)arquivo), tipoArquivo, separador);
        for (ServiceProcCodigoBarrasImpl.CodigoBarrasItem dado : dados) {
            if (dado.getEncontrou().booleanValue()) {
                Boolean exists = false;
                if (ServiceConferenciaNFTerceirosImpl.isWithData(itensConferidos)) {
                    for (DTOConferenciaNFTerceiros.DTOItemConfNFTerceiros item : itensConferidos) {
                        if (!this.isNotNull(dado.getGradeCor()).booleanValue() || !this.isEquals(item.getGradeCorIdentificador(), dado.getGradeCor().getIdentificador())) continue;
                        item.setQuantidadeConferida(dado.getQuantidade());
                        exists = true;
                        break;
                    }
                }
                if (exists.booleanValue()) continue;
                result.addWarning("E.ERP.0835.006", new Object[]{dado.getCodigoBarras()});
                continue;
            }
            result.addWarning("E.ERP.0835.007", new Object[]{dado.getCodigoBarras()});
        }
        result.setResult(itensConferidos);
        return result;
    }

    public List<DTONotaFiscalTerceirosRes> findNotaFiscalTerceirosLibEstoque(Long dataInicial, Long dataFinal, Empresa empresa, OpcoesCompraSuprimentos opcoesCompra) throws ExceptionValidacaoDados {
        if (this.isNull(dataInicial).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.0835.008", new Object[0]);
        }
        if (this.isNull(dataFinal).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.0835.009", new Object[0]);
        }
        if (dataFinal < dataInicial) {
            throw new ExceptionValidacaoDados("E.ERP.0835.010", new Object[0]);
        }
        return this.buildToDTOGeneric(this.serviceNotaFiscalTerceiros.findNotasByLiberacaoEstoque(ToolDate.dataPrimHora((Date)new Date(dataInicial)), ToolDate.dataUltHora((Date)new Date(dataFinal)), empresa, opcoesCompra), DTONotaFiscalTerceirosRes.class);
    }

    public DTOConferenciaNFTerceiros buildItensConferenciaPorLotes(Usuario usuario, DTOConferenciaNFTerceiros dto) throws ExceptionObjNotFound {
        NotaFiscalTerceiros nota = (NotaFiscalTerceiros)this.serviceNotaFiscalTerceiros.getOrThrow(dto.getNotaFiscalTerceirosIdentificador());
        this.compConferenciaNFTerceiros.conferenciaItensSubstitucaoLotes(nota, dto, usuario);
        return dto;
    }

    public DTOConferenciaNFTerceiros conferencia(Usuario usuario, DTOConferenciaNFTerceiros dto, Long idNotaTerceiros, Long idConferencia, OpcoesCompraSuprimentos opcoesCompra) throws ExceptionObjNotFound {
        NotaFiscalTerceiros nota = (NotaFiscalTerceiros)this.serviceNotaFiscalTerceiros.getOrThrow(idNotaTerceiros);
        if (this.isEquals(dto.getModoConferencia(), EnumConstModoConferenciaNFTerceiros.CONFERENCIA_NORMAL.getValue())) {
            dto.getItemConfNFTerceiros().clear();
            dto.getItemConfNFTerceiros().addAll(this.compConferenciaNFTerceiros.criarItensConfNFTerceiros(nota, dto.getItemConfNFTerceiros(), opcoesCompra));
        } else if (this.isNotNull(idConferencia).booleanValue()) {
            dto.setLotes(this.compConferenciaNFTerceiros.carregarItensConfComLotes(nota, (ConferenciaNFTerceiros)this.get(idConferencia)));
        } else {
            dto.setLotes(this.compConferenciaNFTerceiros.carregarItensConfComLotes(nota, null));
        }
        dto.setNotaFiscalTerceirosIdentificador(nota.getIdentificador());
        dto.setNotaFiscalTerceiros(String.valueOf(nota));
        return dto;
    }

    public List<DTOConferenciaNFTerceiros> liberacaoEstoqueNotaTerceiros(Long idNota, Empresa empresa, Usuario usuario, OpcoesCompraSuprimentos opcoesCompraSup) throws ExceptionInvalidData, ExceptionObjNotFound {
        NotaFiscalTerceiros nota = (NotaFiscalTerceiros)this.serviceNotaFiscalTerceiros.getOrThrow(idNota);
        StringBuilder sb = CompConferenciaNFTerceiros.validaProdutoSemTipoConferenciaInNFT(nota, opcoesCompraSup);
        if (sb.length() > 0) {
            throw new ExceptionInvalidData("E.ERP.0835.002", new Object[]{sb.toString()});
        }
        ArrayList<NotaFiscalTerceiros> notas = new ArrayList<NotaFiscalTerceiros>();
        notas.add(nota);
        List liberacoes = this.compLiberacaoNFTerceiros.getLiberacacoes(notas, empresa, usuario, EnumLiberacaoNFTerceiros.LIBERACAO_ESTOQUE);
        liberacoes = this.saveOrUpdate(liberacoes);
        return this.buildToDTOGeneric(liberacoes, DTOConferenciaNFTerceiros.class);
    }
}

