/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.configservicos;

import com.touchcomp.basementor.constants.enums.configservicos.EnumConstConfigServicos;
import com.touchcomp.basementor.model.vo.ConfigServicos;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoConfigServicosImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceConfigServicosImpl
extends ServiceGenericEntityImpl<ConfigServicos, Long, DaoConfigServicosImpl> {
    @Autowired
    public ServiceConfigServicosImpl(DaoConfigServicosImpl genericDao) {
        super(genericDao);
    }

    @Override
    public ConfigServicos beforeSave(ConfigServicos vo) {
        if (vo.getItensConfig() != null) {
            vo.getItensConfig().forEach(it -> it.setConfigServicos(vo));
        }
        return vo;
    }

    public ConfigServicos get(String id, EnumConstConfigServicos key) {
        return ((DaoConfigServicosImpl)this.getDao()).get(id, key);
    }

    @Override
    public ConfigServicos get(EnumConstConfigServicos key) {
        return ((DaoConfigServicosImpl)this.getDao()).get(key);
    }

    @Override
    public ConfigServicos getOrThrow(EnumConstConfigServicos key) throws ExceptionObjNotFound {
        ConfigServicos conf = ((DaoConfigServicosImpl)this.getDao()).get(key);
        if (conf == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.1876.001", new Object[]{key}));
        }
        return conf;
    }

    public ConfigServicos get(EnumConstConfigServicos config, String chave, String valor) {
        return ((DaoConfigServicosImpl)this.getDao()).get(config, chave, valor);
    }

    public ConfigServicos getContainsValueOrThrow(EnumConstConfigServicos config, String chave, String valor) {
        ConfigServicos configServicos = this.getContainsValue(config, chave, valor);
        this.checkAndThrownNotExists((Object)configServicos, "Configuracao: " + config.getChave() + ", chave: " + chave + ", valor: " + valor);
        return configServicos;
    }

    public ConfigServicos getContainsValue(EnumConstConfigServicos config, String chave, String valor) {
        return ((DaoConfigServicosImpl)this.getDao()).getContainsValue(config, chave, valor);
    }
}

