/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.configuracaoliberacaoordemcompra;

import com.touchcomp.basementor.model.vo.ConfiguracaoLiberacaoEmpresa;
import com.touchcomp.basementor.model.vo.ConfiguracaoLiberacaoOrdemCompra;
import com.touchcomp.basementor.model.vo.ItemConfLibOCClassificacao;
import com.touchcomp.basementor.model.vo.ItemConfLibOCUsuValor;
import com.touchcomp.basementor.model.vo.ItemConfLibOrdemCompraUsuario;
import com.touchcomp.basementor.model.vo.ItemConfLibUsuOCEspecie;
import com.touchcomp.basementorservice.dao.impl.DaoConfiguracaoLiberacaoOrdemCompraImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.classificacaoordemcompra.ServiceClassificacaoOrdemCompraImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.especie.ServiceEspecieImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.touchvomodel.vo.configuracaoliberacaoempresa.web.DTOConfiguracaoLiberacaoEmpresa;
import com.touchcomp.touchvomodel.vo.itemconflibocclassificacao.web.DTOItemConfLibOCClassificacao;
import com.touchcomp.touchvomodel.vo.itemconflibordemcomprausuario.web.DTOItemConfLibOrdemCompraUsuario;
import com.touchcomp.touchvomodel.vo.itemconflibusuocespecie.web.DTOItemConfLibUsuOCEspecie;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceConfiguracaoLiberacaoOrdemCompraImpl
extends ServiceGenericEntityImpl<ConfiguracaoLiberacaoOrdemCompra, Long, DaoConfiguracaoLiberacaoOrdemCompraImpl> {
    ServiceEmpresaImpl serviceEmpresaImpl;
    ServiceUsuarioImpl serviceUsuarioImpl;
    ServiceEspecieImpl serviceEspecieImpl;
    ServiceClassificacaoOrdemCompraImpl serviceClassificacaoOrdemCompraImpl;

    @Autowired
    public ServiceConfiguracaoLiberacaoOrdemCompraImpl(DaoConfiguracaoLiberacaoOrdemCompraImpl dao, ServiceEmpresaImpl serviceEmpresaImpl, ServiceUsuarioImpl serviceUsuarioImpl, ServiceEspecieImpl serviceEspecieImpl, ServiceClassificacaoOrdemCompraImpl serviceClassificacaoOrdemCompraImpl) {
        super(dao);
        this.serviceEmpresaImpl = serviceEmpresaImpl;
        this.serviceUsuarioImpl = serviceUsuarioImpl;
        this.serviceEspecieImpl = serviceEspecieImpl;
        this.serviceClassificacaoOrdemCompraImpl = serviceClassificacaoOrdemCompraImpl;
    }

    @Override
    public ConfiguracaoLiberacaoOrdemCompra beforeSaveEntity(ConfiguracaoLiberacaoOrdemCompra aux) {
        aux.getEmpresas().forEach(i -> i.setConfLiberacaoOrdemCompra(aux));
        aux.getItemConfUsuario().forEach(i -> {
            i.getEspecieLiberacaoOrdemCompra().forEach(e -> e.setItemConfLibOrdemCompraUsuario(i));
            i.getItemClassificacao().forEach(c -> c.setItemConfUsuario(i));
            i.setConfLiberacaoOC(aux);
        });
        return aux;
    }

    public List<DTOConfiguracaoLiberacaoEmpresa> getConfiguracaoLiberacaoEmpresa(Long[] ids) {
        List empresas = this.serviceEmpresaImpl.gets(ids);
        List configuracoesLiberacaoEmpresa = empresas.stream().map(i -> {
            ConfiguracaoLiberacaoEmpresa item = new ConfiguracaoLiberacaoEmpresa();
            item.setEmpresa(i);
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(configuracoesLiberacaoEmpresa, DTOConfiguracaoLiberacaoEmpresa.class);
    }

    public List<DTOItemConfLibOrdemCompraUsuario> getItemConfLibOrdemCompraUsuario(Long[] ids) {
        List usuarios = this.serviceUsuarioImpl.gets(ids);
        List itensConfLibOrdemCompraUsuario = usuarios.stream().map(i -> {
            ItemConfLibOrdemCompraUsuario item = new ItemConfLibOrdemCompraUsuario();
            item.setUsuario(i);
            item.setItemConfLibOCValor(new ItemConfLibOCUsuValor());
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(itensConfLibOrdemCompraUsuario, DTOItemConfLibOrdemCompraUsuario.class);
    }

    public List<DTOItemConfLibUsuOCEspecie> getItemEspecie(Long[] ids) {
        List especie = this.serviceEspecieImpl.gets(ids);
        List itemConfLibUsuOCEspecie = especie.stream().map(i -> {
            ItemConfLibUsuOCEspecie item = new ItemConfLibUsuOCEspecie();
            item.setEspecie(i);
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(itemConfLibUsuOCEspecie, DTOItemConfLibUsuOCEspecie.class);
    }

    public List<DTOItemConfLibOCClassificacao> getItemClassificacao(Long[] ids) {
        List classificacaoOrdemCompra = this.serviceClassificacaoOrdemCompraImpl.gets(ids);
        List itemConfLibOCClassificacao = classificacaoOrdemCompra.stream().map(i -> {
            ItemConfLibOCClassificacao item = new ItemConfLibOCClassificacao();
            item.setClassificacaoOC(i);
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(itemConfLibOCClassificacao, DTOItemConfLibOCClassificacao.class);
    }
}

