/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.configuracaopainelbi;

import com.touchcomp.basementor.constants.enums.configuracaopainelbi.EnumConstConfigPainelColunas;
import com.touchcomp.basementor.model.vo.BusinessIntelligencePref;
import com.touchcomp.basementor.model.vo.ConfiguracaoPainelBI;
import com.touchcomp.basementor.model.vo.ConfiguracaoPainelBIGrupo;
import com.touchcomp.basementor.model.vo.ConfiguracaoPainelBIItem;
import com.touchcomp.basementor.model.vo.ConfiguracaoPainelBILinha;
import com.touchcomp.basementor.model.vo.ConfiguracaoPainelBIUsuario;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.SmartComponentPref;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.dao.impl.DaoConfiguracaoPainelBIImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.businessintelligencepref.ServiceBusinessIntelligencePrefImpl;
import com.touchcomp.basementorservice.service.impl.grupousuarios.ServiceGrupoUsuariosImpl;
import com.touchcomp.basementorservice.service.impl.smartcomponentpref.ServiceSmartComponentPrefImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.touchvomodel.vo.configuracaopainelbi.web.DTOConfiguracaoPainelBI;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ServiceConfiguracaoPainelBIImpl
extends ServiceGenericEntityImpl<ConfiguracaoPainelBI, Long, DaoConfiguracaoPainelBIImpl> {
    ServiceSmartComponentPrefImpl serviceSmartComponentPrefImpl;
    ServiceBusinessIntelligencePrefImpl serviceBusinessIntelligencePrefImpl;
    ServiceUsuarioImpl serviceUsuarioImpl;
    ServiceGrupoUsuariosImpl serviceGrupoUsuariosImpl;

    public ServiceConfiguracaoPainelBIImpl(DaoConfiguracaoPainelBIImpl dao, ServiceSmartComponentPrefImpl serviceSmartComponentPrefImpl, ServiceBusinessIntelligencePrefImpl serviceBusinessIntelligencePrefImpl, ServiceUsuarioImpl serviceUsuarioImpl, ServiceGrupoUsuariosImpl serviceGrupoUsuariosImpl) {
        super(dao);
        this.serviceSmartComponentPrefImpl = serviceSmartComponentPrefImpl;
        this.serviceBusinessIntelligencePrefImpl = serviceBusinessIntelligencePrefImpl;
        this.serviceUsuarioImpl = serviceUsuarioImpl;
        this.serviceGrupoUsuariosImpl = serviceGrupoUsuariosImpl;
    }

    public <Z> List<Z> getConfiguracao(Usuario usuario, Grupo grupoUsuarios, Class<Z> clazz) {
        List<ConfiguracaoPainelBI> conf = ((DaoConfiguracaoPainelBIImpl)this.getDao()).getConfiguracao(usuario, grupoUsuarios);
        return this.buildToDTO(conf, clazz);
    }

    public List<DTOConfiguracaoPainelBI.DTOConfiguracaoPainelBIItem> getBusinessIntelligencePrefs(Long[] idBusinessIntelligencePrefs) {
        List data = this.serviceBusinessIntelligencePrefImpl.gets(idBusinessIntelligencePrefs);
        LinkedList<ConfiguracaoPainelBIItem> ret = new LinkedList<ConfiguracaoPainelBIItem>();
        for (BusinessIntelligencePref pref : data) {
            ConfiguracaoPainelBIItem item = new ConfiguracaoPainelBIItem();
            item.setBusinessIntelligencePref(pref);
            item.setTamanhoColunas(EnumConstConfigPainelColunas.COLUNAS_4.getEnumId());
            ret.add(item);
        }
        return this.buildToDTOGeneric(ret, DTOConfiguracaoPainelBI.DTOConfiguracaoPainelBIItem.class);
    }

    public List<DTOConfiguracaoPainelBI.DTOConfiguracaoPainelBIItem> getSmartComponentPrefs(Long[] idSmartComponentPrefs) {
        List data = this.serviceSmartComponentPrefImpl.gets(idSmartComponentPrefs);
        LinkedList<ConfiguracaoPainelBIItem> ret = new LinkedList<ConfiguracaoPainelBIItem>();
        for (SmartComponentPref pref : data) {
            ConfiguracaoPainelBIItem item = new ConfiguracaoPainelBIItem();
            item.setSmartComponentPref(pref);
            item.setTamanhoColunas(EnumConstConfigPainelColunas.COLUNAS_4.getEnumId());
            ret.add(item);
        }
        return this.buildToDTOGeneric(ret, DTOConfiguracaoPainelBI.DTOConfiguracaoPainelBIItem.class);
    }

    public List<DTOConfiguracaoPainelBI.DTOConfiguracaoPainelBIGrupo> getGrupoUsuarios(Long[] idGrupoUsuarios) {
        List data = this.serviceGrupoUsuariosImpl.gets(idGrupoUsuarios);
        LinkedList<ConfiguracaoPainelBIGrupo> ret = new LinkedList<ConfiguracaoPainelBIGrupo>();
        for (Grupo pref : data) {
            ConfiguracaoPainelBIGrupo item = new ConfiguracaoPainelBIGrupo();
            item.setGrupoUsuarios(pref);
            ret.add(item);
        }
        return this.buildToDTOGeneric(ret, DTOConfiguracaoPainelBI.DTOConfiguracaoPainelBIGrupo.class);
    }

    public List<DTOConfiguracaoPainelBI.DTOConfiguracaoPainelBIUsuario> getUsuarios(Long[] idUsuarios) {
        List data = this.serviceUsuarioImpl.gets(idUsuarios);
        LinkedList<ConfiguracaoPainelBIUsuario> ret = new LinkedList<ConfiguracaoPainelBIUsuario>();
        for (Usuario pref : data) {
            ConfiguracaoPainelBIUsuario item = new ConfiguracaoPainelBIUsuario();
            item.setUsuario(pref);
            ret.add(item);
        }
        return this.buildToDTOGeneric(ret, DTOConfiguracaoPainelBI.DTOConfiguracaoPainelBIUsuario.class);
    }

    @Override
    public ConfiguracaoPainelBI beforeSaveEntity(ConfiguracaoPainelBI entity) {
        for (ConfiguracaoPainelBIGrupo grupo : entity.getGrupoUsuarios()) {
            grupo.setConfiguracaoPainelBI(entity);
        }
        for (ConfiguracaoPainelBILinha linha : entity.getLinhasPainel()) {
            linha.setConfiguracaoPainelBI(entity);
            for (ConfiguracaoPainelBIItem item : linha.getItensConfPainelBI()) {
                item.setConfiguracaoPainelBILinha(linha);
            }
        }
        for (ConfiguracaoPainelBIUsuario usuario : entity.getUsuarios()) {
            usuario.setConfiguracaoPainelBI(entity);
        }
        return entity;
    }
}

