/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.consultaposicaoestoque;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorservice.helpers.impl.saldoestoquegeral.HelperSaldoEstoqueGeral;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.localizacao.ServiceLocalizacaoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchvomodel.vo.DTOConsultaPosicaoEstoque;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceConsultaPosicaoEstoqueImpl
extends ServiceGenericImpl {
    ServiceSaldoEstoqueImpl serviceSaldoEstoque;
    ServiceLocalizacaoImpl serviceLocalizacao;
    HelperSaldoEstoqueGeral helperSaldoEstoqueGeral;

    @Autowired
    public ServiceConsultaPosicaoEstoqueImpl(ServiceSaldoEstoqueImpl serviceSaldoEstoque, HelperSaldoEstoqueGeral helperSaldoEstoqueGeral, ServiceLocalizacaoImpl serviceLocalizacao) {
        this.serviceSaldoEstoque = serviceSaldoEstoque;
        this.helperSaldoEstoqueGeral = helperSaldoEstoqueGeral;
        this.serviceLocalizacao = serviceLocalizacao;
    }

    public List<SaldoEstoqueGeral> consulta(Long idProduto, Short tipoEstoqueProprioTerceiro, Short somenteEmpresaLogada, Short somenteSaldoMaiorQueZero, Empresa empresaLogada) {
        Long idEmpresaInicial = 0L;
        Long idEmpresaFinal = 99999999L;
        if (this.isEquals(somenteEmpresaLogada, EnumConstantsMentorSimNao.SIM.getValue())) {
            idEmpresaInicial = idEmpresaFinal = empresaLogada.getIdentificador();
        }
        EnumConstSaldoEstTipoSaldoQtde tipoQtd = EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO;
        if (this.isEquals(somenteSaldoMaiorQueZero, EnumConstantsMentorSimNao.SIM.getValue())) {
            tipoQtd = EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_MAIOR_0;
        }
        EnumConstCentroEstTipoPropTerc tipoCentroEstoque = EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_TERCEIROS;
        if (this.isEquals(EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue(), tipoEstoqueProprioTerceiro)) {
            tipoCentroEstoque = EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO;
        }
        List<SaldoEstoqueGeral> saldo = this.serviceSaldoEstoque.findSaldoIdGradeCorLista(idProduto, idProduto, null, null, ToolDate.getCurrentDate(), idEmpresaInicial, idEmpresaFinal, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_CENTRO_ESTOQUE, tipoQtd, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_TUDO, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, tipoCentroEstoque, null);
        this.buscarOutrosDados(saldo, idEmpresaInicial, idEmpresaFinal, tipoCentroEstoque, tipoQtd);
        return saldo;
    }

    private void buscarOutrosDados(List<SaldoEstoqueGeral> saldo, Long inicialEmpresaId, Long finalEmpresaId, EnumConstCentroEstTipoPropTerc tipoCentroEstoquePropTerc, EnumConstSaldoEstTipoSaldoQtde tipoQtd) {
        saldo.forEach(s -> {
            List<SaldoEstoqueGeral> sub = this.serviceSaldoEstoque.findSaldoGradeCentroEstoqueLoteLista(s.getProduto().getIdentificador(), s.getProduto().getIdentificador(), s.getGradeCor().getIdentificador(), s.getGradeCor().getIdentificador(), ToolDate.getCurrentDate(), inicialEmpresaId, finalEmpresaId, null, s.getCentroEstoque().getIdentificador(), s.getCentroEstoque().getIdentificador(), null, tipoCentroEstoquePropTerc, null, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO, tipoQtd, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_TUDO);
            s.setLocalizacao(this.serviceLocalizacao.findLocalizacaoByProdutoAndCentroEstoque(s.getProduto(), s.getCentroEstoque()));
            s.setSubSaldo(sub);
        });
    }

    public DTOConsultaPosicaoEstoque toDTO(Produto p, List<SaldoEstoqueGeral> saldos) {
        DTOConsultaPosicaoEstoque dto = new DTOConsultaPosicaoEstoque();
        dto.setProdutoIdentificador(p.getIdentificador());
        dto.setProduto(p.getNome());
        dto.setNcm(p.getNcm().getCodigo());
        dto.setLocalizacao(p.getLocalizacao().getNome());
        dto.setUnidadeMedida(p.getUnidadeMedida().getSigla());
        dto.setEstoqueMinimo(p.getQtdMin());
        dto.setEstoqueMaximo(p.getQtdMax());
        dto.setQuantidadeEstoque(Double.valueOf(saldos.stream().mapToDouble(s -> s.getQuantidade()).sum()));
        dto.setSaldos(this.helperSaldoEstoqueGeral.toDto(saldos));
        return dto;
    }
}

