/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.consultaprecolote;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.model.impl.CustoProdutoUltimaNF;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorservice.helpers.impl.produto.HelperProduto;
import com.touchcomp.basementorservice.helpers.impl.saldoestoquegeral.HelperSaldoEstoqueGeral;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.touchvomodel.vo.produto.web.DTOCustoProdutoUltimaNF;
import com.touchcomp.touchvomodel.vo.saldoestoque.DTOSaldoEstoqueGeral;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceConsultaPrecoLoteImpl {
    HelperSaldoEstoqueGeral helperSaldoEstoqueGeral;
    HelperProduto helperProduto;
    ServiceSaldoEstoqueImpl serviceSaldoEstoque;
    ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceiros;

    @Autowired
    public ServiceConsultaPrecoLoteImpl(ServiceSaldoEstoqueImpl serviceSaldoEstoque, HelperSaldoEstoqueGeral helperSaldoEstoqueGeral, ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceiros, HelperProduto helperProduto) {
        this.serviceSaldoEstoque = serviceSaldoEstoque;
        this.helperSaldoEstoqueGeral = helperSaldoEstoqueGeral;
        this.serviceNotaFiscalTerceiros = serviceNotaFiscalTerceiros;
        this.helperProduto = helperProduto;
    }

    public List<DTOSaldoEstoqueGeral> findInfDetalhadaProduto(Long produto, Empresa empresa) {
        Long idEmpresa = 0L;
        if (empresa != null) {
            idEmpresa = empresa.getIdentificador();
        }
        List<SaldoEstoqueGeral> saldos = this.serviceSaldoEstoque.findSaldoIdGradeCorLista(produto, produto, null, null, new Date(), idEmpresa, idEmpresa, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_MAIOR_0, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_TUDO, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
        return this.helperSaldoEstoqueGeral.toDto(saldos);
    }

    public List<DTOCustoProdutoUltimaNF> getUltimasEntradasProduto(Long produto, Empresa empresa) {
        List<CustoProdutoUltimaNF> dados = this.serviceNotaFiscalTerceiros.getUltimasEntradasProd(produto, empresa, 10);
        return this.helperProduto.toDTO(dados);
    }
}

