/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.contabilizacaorps;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilRps;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.rps.CompLancamentoRps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceContabilizacaoRps {
    @Autowired
    CompLancamentoRps compLancamentoRps;

    public Rps contabilizar(Rps r, OpcoesContabeis op, Short atualizarPlanos) throws ExceptionParametrizacao, ExceptionInvalidData {
        CompParametrizacaoContabilRps.DadosContas dados = this.buscaDadosContas(r, op);
        if (atualizarPlanos.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            r.setPlanoContaCred(dados.getPlanoContaCred());
            r.setPlanoContaDeb(dados.getPlanoContaDeb());
        }
        LoteContabil lote = this.compLancamentoRps.contabilizar(r, dados, op);
        r.setLoteContabil(lote);
        return r;
    }

    CompParametrizacaoContabilRps.DadosContas buscaDadosContas(Rps vo, OpcoesContabeis op) throws ExceptionParametrizacao {
        CompParametrizacaoContabilRps.DadosContas dados = new CompParametrizacaoContabilRps().getPlanoContasNfPropria(vo.getModeloRps(), vo.getUnidadeTomPrestRPS(), vo.getEmpresa(), vo.getCategoriaPessoa(), op, vo.getClassificacaoPessoas());
        return dados;
    }
}

