/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.contagemprodutos;

import com.touchcomp.basementor.constants.enums.estoque.EnumTipoArquivoColetorCodBarras;
import com.touchcomp.basementor.model.vo.ColetorDadosEstoque;
import com.touchcomp.basementor.model.vo.ContagemProdCentroEstoque;
import com.touchcomp.basementor.model.vo.ContagemProdGrade;
import com.touchcomp.basementor.model.vo.ContagemProdProduto;
import com.touchcomp.basementor.model.vo.ContagemProdutos;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.service.impl.coletordadosestoque.ServiceColetorDadosEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.proccodigobarras.ServiceProcCodigoBarrasImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class AuxImportaDadosColetor
extends ContagemProdutos {
    final ServiceColetorDadosEstoqueImpl serviceColetorDadosEstoqueImpl;
    final ServiceProcCodigoBarrasImpl serviceProc;
    final ServiceGradeCorImpl serviceGradeCorImpl;
    final ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl;

    public AuxImportaDadosColetor(ServiceColetorDadosEstoqueImpl serviceColetorDadosEstoqueImpl, ServiceProcCodigoBarrasImpl serviceProc, ServiceGradeCorImpl serviceGradeCorImpl, ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl) {
        this.serviceColetorDadosEstoqueImpl = serviceColetorDadosEstoqueImpl;
        this.serviceProc = serviceProc;
        this.serviceGradeCorImpl = serviceGradeCorImpl;
        this.serviceLoteFabricacaoImpl = serviceLoteFabricacaoImpl;
    }

    ContagemProdutos importarDados(String contentData, Long idColetor, Empresa empresa, Usuario usuario, ContagemProdutos contagem) throws ExceptionObjNotFound, ExceptionIO {
        ColetorDadosEstoque coletor = (ColetorDadosEstoque)this.serviceColetorDadosEstoqueImpl.get(idColetor);
        if (coletor == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0796.001", new Object[]{idColetor}));
        }
        StringBuilder sb = new StringBuilder();
        if (contagem == null) {
            contagem = new ContagemProdutos();
        }
        contagem.setDataCadastro(new Date());
        contagem.setDataContagem(new Date());
        contagem.setEmpresa(empresa);
        contagem.setUsuario(usuario);
        ContagemProdCentroEstoque ce = contagem.getCentrosEstoqueContagem().isEmpty() ? new ContagemProdCentroEstoque() : (ContagemProdCentroEstoque)contagem.getCentrosEstoqueContagem().get(0);
        ce.setContagemProdutos(contagem);
        contagem.getCentrosEstoqueContagem().add(ce);
        this.importItens(ce, coletor, contentData, sb);
        contagem.setObservacao(sb.toString());
        return contagem;
    }

    private void importItens(ContagemProdCentroEstoque ce, ColetorDadosEstoque coletor, String contentData, StringBuilder sb) throws ExceptionIO {
        EnumTipoArquivoColetorCodBarras tipoColetor = EnumTipoArquivoColetorCodBarras.get((Object)coletor.getTipoColetor());
        String separador = coletor.getSeparador();
        List<ServiceProcCodigoBarrasImpl.CodigoBarrasItem> codigos = this.serviceProc.processCodigoBarrasColetor(contentData, tipoColetor, separador);
        for (ServiceProcCodigoBarrasImpl.CodigoBarrasItem item : codigos) {
            this.importarItem(ce, item, sb);
        }
    }

    private void importarItem(ContagemProdCentroEstoque ce, ServiceProcCodigoBarrasImpl.CodigoBarrasItem item, StringBuilder sb) {
        ContagemProdGrade cg;
        ContagemProdProduto cp;
        if (!item.getEncontrou().booleanValue()) {
            String message = MessagesBaseMentor.getTextDetailsMsg((String)"M.ERP.0796.001", (Object[])new Object[]{item.getCodigoBarras()});
            sb.append(message).append("\n");
            return;
        }
        Optional<ContagemProdProduto> foundProd = ce.getProdutosContagem().stream().filter(i -> TMethods.isEquals((Object)i.getProduto(), (Object)item.getProduto())).findFirst();
        if (foundProd.isPresent()) {
            cp = foundProd.get();
        } else {
            cp = new ContagemProdProduto();
            ce.getProdutosContagem().add(cp);
        }
        cp.setProduto(item.getProduto());
        cp.setContagemProdCentroEstoque(ce);
        LoteFabricacao lote = null;
        if (TMethods.isAffirmative((Number)item.getProduto().getLoteUnico())) {
            lote = this.serviceLoteFabricacaoImpl.findLoteUnico(item.getProduto());
        }
        LoteFabricacao loteTemp = lote;
        Optional<ContagemProdGrade> foundProdGrade = cp.getGradesLotesContados().stream().filter(i -> TMethods.isEquals((Object)i.getGradeCor(), (Object)item.getGradeCor()) && TMethods.isEquals((Object)i.getLotefabricacao(), (Object)loteTemp)).findFirst();
        if (foundProdGrade.isPresent()) {
            cg = foundProdGrade.get();
        } else {
            cg = new ContagemProdGrade();
            cp.getGradesLotesContados().add(cg);
        }
        cg.setGradeCor(item.getGradeCor());
        if (item.getGradeCor() == null) {
            cg.setGradeCor(this.serviceGradeCorImpl.getFirstGradeCor(item.getProduto()));
        }
        cg.setContagemProdProdutos(cp);
        cg.setLotefabricacao(lote);
        cg.setQuantidadeContada(Double.valueOf(cg.getQuantidadeContada() + item.getQuantidade()));
    }
}

