/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.contagemprodutos;

import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.ContagemProdCentroEstoque;
import com.touchcomp.basementor.model.vo.ContagemProdGrade;
import com.touchcomp.basementor.model.vo.ContagemProdProduto;
import com.touchcomp.basementor.model.vo.ContagemProdutos;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoContagemProdutosImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.centroestoque.ServiceCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.coletordadosestoque.ServiceColetorDadosEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.contagemprodutos.AuxImportaDadosColetor;
import com.touchcomp.basementorservice.service.impl.contagemprodutos.DTOContagemProdutoInfo;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.proccodigobarras.ServiceProcCodigoBarrasImpl;
import com.touchcomp.basementorservice.service.impl.produto.DTOProdutoInfoColetorEstoque;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.touchvomodel.vo.contagemprodutos.web.DTOContagemProdutos;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceContagemProdutosImpl
extends ServiceGenericEntityImpl<ContagemProdutos, Long, DaoContagemProdutosImpl> {
    @Autowired
    ServiceProdutoImpl serviceProduto;
    @Autowired
    ServiceGradeCorImpl serviceGradeCorImpl;
    @Autowired
    ServiceCentroEstoqueImpl serviceCentroEstoque;
    @Autowired
    ServiceColetorDadosEstoqueImpl serviceColetorDadosEstoqueImpl;
    @Autowired
    ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl;
    @Autowired
    ServiceProcCodigoBarrasImpl serviceProc;

    public ServiceContagemProdutosImpl(DaoContagemProdutosImpl dao) {
        super(dao);
    }

    public DTOContagemProdutos.DTOContagemProdGrade getGradeCorContagem(Long idGradeCor) {
        GradeCor gc = (GradeCor)this.serviceGradeCorImpl.get(idGradeCor);
        if (gc == null) {
            return null;
        }
        ContagemProdGrade cg = new ContagemProdGrade();
        cg.setGradeCor(gc);
        return this.buildToDTOGeneric(cg, DTOContagemProdutos.DTOContagemProdGrade.class);
    }

    public DTOContagemProdutos.DTOContagemProdProduto getProdutoContagem(Long idProduto) {
        Produto produto = (Produto)this.serviceProduto.get(idProduto);
        if (produto == null) {
            return null;
        }
        ContagemProdProduto cp = new ContagemProdProduto();
        cp.setProduto(produto);
        GradeCor gc = this.serviceGradeCorImpl.getFirstGradeCor(produto);
        if (gc != null) {
            ContagemProdGrade cg = new ContagemProdGrade();
            cg.setGradeCor(gc);
            LoteFabricacao lote = this.serviceLoteFabricacaoImpl.findLoteUnico(produto);
            cg.setLotefabricacao(lote);
            cp.getGradesLotesContados().add(cg);
        }
        return this.buildToDTOGeneric(cp, DTOContagemProdutos.DTOContagemProdProduto.class);
    }

    public DTOContagemProdutos.DTOContagemProdCentroEstoque getCentroEstoqueContagem(Long idCentroEstoque) {
        CentroEstoque cc = (CentroEstoque)this.serviceCentroEstoque.get(idCentroEstoque);
        if (cc == null) {
            return null;
        }
        ContagemProdCentroEstoque ce = new ContagemProdCentroEstoque();
        ce.setCentroEstoque(cc);
        return this.buildToDTOGeneric(ce, DTOContagemProdutos.DTOContagemProdCentroEstoque.class);
    }

    public DTOContagemProdutoInfo getNovaContagem(String informacoes, Long idGradeCor, Long idLoteFab, Empresa empresa) {
        try {
            DTOProdutoInfoColetorEstoque infoProd;
            if (!TMethods.isStrWithData((String)informacoes)) {
                return null;
            }
            String[] data = TString.splitString((String)informacoes, (char[])new char[0]);
            Double qtd = 0.0;
            if (data.length > 1 && TString.isADoubleNumber((String)data[0])) {
                qtd = Double.valueOf(data[0]);
                informacoes = data[1];
            }
            if ((infoProd = this.serviceProduto.getInfoProdGradeLoteFabColetor(informacoes, idGradeCor, idLoteFab, empresa)) == null) {
                return null;
            }
            DTOContagemProdutoInfo ret = new DTOContagemProdutoInfo();
            BeanUtils.copyProperties((Object)ret, (Object)infoProd);
            ret.setQuantidade(qtd);
            return ret;
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionErroProgramacao("erro-copia-dados", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new ExceptionErroProgramacao("erro-copia-dados", (Throwable)ex);
        }
    }

    public ContagemProdutos processarDadosColetor(String contentData, Long idColetor, Long idContagem, Empresa empresa, Usuario usuario) throws ExceptionIO, ExceptionObjNotFound {
        ContagemProdutos contagem = null;
        if (TMethods.isWithData((Number)idContagem)) {
            contagem = (ContagemProdutos)this.get(idContagem);
        }
        contagem = new AuxImportaDadosColetor(this.serviceColetorDadosEstoqueImpl, this.serviceProc, this.serviceGradeCorImpl, this.serviceLoteFabricacaoImpl).importarDados(contentData, idColetor, empresa, usuario, contagem);
        return this.saveOrUpdate(contagem);
    }

    public ContagemProdutos processarDadosColetorFile(File file, Long idColetor, Long idContagem, Empresa empresa, Usuario usuario) throws ExceptionIO, ExceptionObjNotFound {
        String data = ToolFile.getConteudoArquivo((File)file);
        return this.processarDadosColetor(data, idColetor, idContagem, empresa, usuario);
    }

    public List<DTOContagemProdutos> getContagensUsuario(Usuario loggedUser) {
        List<ContagemProdutos> data = ((DaoContagemProdutosImpl)this.getDao()).getContagensUsuarios(loggedUser);
        return this.buildToDTO(data, DTOContagemProdutos.class);
    }

    @Override
    public ContagemProdutos beforeSave(ContagemProdutos aux) {
        for (ContagemProdCentroEstoque ce : aux.getCentrosEstoqueContagem()) {
            ce.setContagemProdutos(aux);
            for (ContagemProdProduto cp : ce.getProdutosContagem()) {
                double qtdNec = 0.0;
                double qtd = 0.0;
                cp.setContagemProdCentroEstoque(ce);
                for (ContagemProdGrade gc : cp.getGradesLotesContados()) {
                    gc.setContagemProdProdutos(cp);
                    if (gc.getQuantidadeContada() != null) {
                        qtd += gc.getQuantidadeContada().doubleValue();
                    }
                    if (gc.getQuantidadeNecessaria() == null) continue;
                    qtdNec += gc.getQuantidadeNecessaria().doubleValue();
                }
                cp.setQuantidadeContada(Double.valueOf(qtd));
                cp.setQuantidadeNecessaria(Double.valueOf(qtdNec));
            }
        }
        return aux;
    }

    public ContagemProdutos getByIdMobile(Long id) {
        return ((DaoContagemProdutosImpl)this.getGenericDao()).getByIdMobile(id);
    }
}

