/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.contasalariocolaborador;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoContaColaborador;
import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.vo.ContaSalarioColaborador;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidDataRuntime;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoContaSalarioColaboradorImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.touchvomodel.vo.contasalariocolaborador.web.DTOContaSalarioColaborador;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceContaSalarioColaboradorImpl
extends ServiceGenericEntityImpl<ContaSalarioColaborador, Long, DaoContaSalarioColaboradorImpl> {
    @Autowired
    private ServicePessoaImpl servicePessoa;

    @Autowired
    public ServiceContaSalarioColaboradorImpl(DaoContaSalarioColaboradorImpl genericDao) {
        super(genericDao);
    }

    @Override
    public ContaSalarioColaborador beforeSaveEntity(ContaSalarioColaborador entity) {
        if (!ServiceContaSalarioColaboradorImpl.isWithData(this.findContasAtivasPessoa(entity.getPessoa())) && !this.isEquals(entity.getAtivo(), EnumConstStatusObjeto.ATIVO.getValue())) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.ERP.1246.002"));
        }
        ContaSalarioColaborador contaPreferencial = this.findContaPreferencialPessoa(entity.getPessoa());
        if (this.isNull(contaPreferencial).booleanValue() && !this.isEquals(entity.getPreferencial(), EnumConstantsMentorSimNao.SIM.getValue()) || this.isEquals(entity, contaPreferencial) && !this.isEquals(entity.getPreferencial(), EnumConstantsMentorSimNao.SIM.getValue())) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.ERP.1246.003"));
        }
        return entity;
    }

    @Override
    public ContaSalarioColaborador beforeDeleteEntity(ContaSalarioColaborador entity) {
        if (this.isAffimative(entity.getPreferencial()) && this.isAffimative(entity.getAtivo())) {
            throw new ExceptionRuntimeBase("E.ERP.1246.004");
        }
        return entity;
    }

    public List<ContaSalarioColaborador> findContasPessoa(Long idPessoa) {
        return ((DaoContaSalarioColaboradorImpl)this.getGenericDao()).findContasPessoa(idPessoa);
    }

    public List<ContaSalarioColaborador> findContasAtivasPessoa(Pessoa pessoa) {
        return ((DaoContaSalarioColaboradorImpl)this.getGenericDao()).findContasAtivasPessoa(pessoa);
    }

    public List<ContaSalarioColaborador> findContasPreferenciaisPessoa(Pessoa pessoa) {
        return ((DaoContaSalarioColaboradorImpl)this.getGenericDao()).findContasPreferenciaisPessoa(pessoa);
    }

    public ContaSalarioColaborador findContaPreferencialPessoa(Pessoa pessoa) {
        return ((DaoContaSalarioColaboradorImpl)this.getGenericDao()).findContaPreferencialPessoa(pessoa);
    }

    public List<DTOContaSalarioColaborador> findContasPessoaDTO(Long idPessoa) {
        return this.buildToDTO(((DaoContaSalarioColaboradorImpl)this.getGenericDao()).findContasPessoa(idPessoa), DTOContaSalarioColaborador.class);
    }

    public DTOContaSalarioColaborador novaContaSalario(Long idPessoa) throws ExceptionObjNotFound {
        ContaSalarioColaborador vo = new ContaSalarioColaborador();
        vo.setPessoa((Pessoa)this.servicePessoa.getOrThrow(idPessoa));
        vo.setDataCadastro(new Date());
        vo.setAtivo(Short.valueOf(EnumConstStatusObjeto.ATIVO.getValue()));
        vo.setTipoConta(EnumConstTipoContaColaborador.CONTA_CORRENTE.getEnumId());
        vo.setPreferencial(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        return this.buildToDTO(vo, DTOContaSalarioColaborador.class);
    }

    @Override
    public ContaSalarioColaborador afterSaveEntity(ContaSalarioColaborador entity) {
        if (this.isAffimative(entity.getPreferencial())) {
            List<ContaSalarioColaborador> contas = this.findContasPreferenciaisPessoa(entity.getPessoa());
            for (ContaSalarioColaborador c : contas) {
                if (this.isEquals(c, entity)) continue;
                c.setPreferencial(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
                this.saveOrUpdateOnly(c);
            }
        }
        return entity;
    }
}

