/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.contavalores;

import com.touchcomp.basementor.model.vo.BorderoChequeTerceirosMovBancario;
import com.touchcomp.basementor.model.vo.ChequeTerceiros;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementorservice.dao.impl.DaoContaValoresImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.borderochequesterceiros.ServiceBorderoChequesTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.chequeterceiros.ServiceChequeTerceirosImpl;
import java.util.Map;
import org.apache.commons.collections.map.LinkedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceContaValoresImpl
extends ServiceGenericEntityImpl<ContaValores, Long, DaoContaValoresImpl> {
    ServiceChequeTerceirosImpl serviceChequeTerceirosImpl;
    ServiceBorderoChequesTerceirosImpl serviceBorderoChequesTerceirosImpl;

    @Autowired
    public ServiceContaValoresImpl(DaoContaValoresImpl genericDao, ServiceChequeTerceirosImpl serviceChequeTerceirosImpl, ServiceBorderoChequesTerceirosImpl serviceBorderoChequesTerceirosImpl) {
        super(genericDao);
        this.serviceChequeTerceirosImpl = serviceChequeTerceirosImpl;
        this.serviceBorderoChequesTerceirosImpl = serviceBorderoChequesTerceirosImpl;
    }

    public ContaValores findByNrContaAndAgencia(String nrConta, String nrAgencia) {
        return this.getGenericDao().findByNrContaAndAgencia(nrConta, nrAgencia);
    }

    @Override
    public DaoContaValoresImpl getGenericDao() {
        return (DaoContaValoresImpl)super.getGenericDao();
    }

    public Map getContaValorUltimoBorderoCheque(Long idCheque) {
        ChequeTerceiros chequeTerceiro = (ChequeTerceiros)this.serviceChequeTerceirosImpl.get(idCheque);
        if (this.isNull(chequeTerceiro).booleanValue()) {
            return null;
        }
        BorderoChequeTerceirosMovBancario bord = this.serviceBorderoChequesTerceirosImpl.getUltimoBorderoChequeTerceiro(idCheque);
        if (this.isNull(bord).booleanValue() || this.isNull(bord.getMovimentoBancarioCredito()).booleanValue()) {
            return null;
        }
        LinkedMap h = new LinkedMap();
        h.put("contaValorIdentificador", bord.getMovimentoBancarioCredito().getContaValor().getIdentificador());
        h.put("contaValor", bord.getMovimentoBancarioCredito().getContaValor().toString());
        return h;
    }
}

