/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.controlearmariocolaborador;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ControleArmarioColaborador;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoControleArmarioColaboradorImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.touchvomodel.vo.controlearmariocolaborador.web.DTOControleArmarioColaborador;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceControleArmarioColaboradorImpl
extends ServiceGenericEntityImpl<ControleArmarioColaborador, Long, DaoControleArmarioColaboradorImpl> {
    ServiceColaboradorImpl serviceColaboradorImpl;

    @Autowired
    public ServiceControleArmarioColaboradorImpl(DaoControleArmarioColaboradorImpl dao, ServiceColaboradorImpl serviceColaboradorImpl) {
        super(dao);
        this.serviceColaboradorImpl = serviceColaboradorImpl;
    }

    public DTOControleArmarioColaborador getColaborador(Long idColaborador) {
        Colaborador colaborador = (Colaborador)this.serviceColaboradorImpl.get(idColaborador);
        if (this.isNull(colaborador).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0516.002", new Object[]{idColaborador}));
        }
        DTOControleArmarioColaborador dto = new DTOControleArmarioColaborador();
        dto.setColaboradorIdentificador(colaborador.getIdentificador());
        dto.setColaborador(colaborador.getPessoa().getNome());
        dto.setCentroCusto(colaborador.getCentroCusto().getNome());
        dto.setDataAdmissao(colaborador.getDataAdmissao());
        dto.setDataDemissao(colaborador.getDataDemissao());
        return dto;
    }
}

