/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.controleentregaequipamento;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.controleentregaequipamento.EnumConstControleEpiTipoOperacao;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ControleEntregaEquipamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemControleEquipamento;
import com.touchcomp.basementor.model.vo.ItemEquipamento;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.ExceptionParamCtbRequisicao;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoControleEntregaEquipamentoImpl;
import com.touchcomp.basementorservice.helpers.impl.requisicao.HelperRequisicao;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.implantacaosaldos.SCompImplantacaoSaldosImpl;
import com.touchcomp.basementorservice.service.impl.itemcontroleequipamento.ServiceItemControleEquipamentoImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.naturezarequisicao.ServiceNaturezaRequisicaoImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaoequipamentoseguranca.ServiceParametrizacaoEquipamentoSegurancaImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.clone.ToolClone;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchvomodel.res.DTOEntidadeRes;
import com.touchcomp.touchvomodel.vo.itemcontroleequipamento.web.DTOItemControleEquipamento;
import com.touchcomp.touchvomodel.vo.lotefabricacao.web.DTOLoteFabricacaoRes;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceControleEntregaEquipamentoImpl
extends ServiceGenericEntityImpl<ControleEntregaEquipamento, Long, DaoControleEntregaEquipamentoImpl> {
    ServiceColaboradorImpl serviceColaboradorImpl;
    ServiceParametrizacaoEquipamentoSegurancaImpl serviceParametrizacaoEquipamentoSegurancaImpl;
    ServiceItemControleEquipamentoImpl serviceItemControleEquipamentoImpl;
    ServiceGradeCorImpl serviceGradeCorImpl;
    ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl;
    ServiceSaldoEstoqueImpl serviceSaldoEstoqueImpl;
    ServiceNaturezaRequisicaoImpl serviceNaturezaRequisicaoImpl;
    HelperRequisicao helperRequisicao;
    SCompImplantacaoSaldosImpl sCompImplantacaoSaldosImpl;

    @Autowired
    public ServiceControleEntregaEquipamentoImpl(DaoControleEntregaEquipamentoImpl dao, ServiceColaboradorImpl serviceColaboradorImpl, ServiceParametrizacaoEquipamentoSegurancaImpl serviceParametrizacaoEquipamentoSegurancaImpl, ServiceItemControleEquipamentoImpl serviceItemControleEquipamentoImpl, ServiceGradeCorImpl serviceGradeCorImpl, ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl, ServiceSaldoEstoqueImpl serviceSaldoEstoqueImpl, ServiceNaturezaRequisicaoImpl serviceNaturezaRequisicaoImpl, HelperRequisicao helperRequisicao, SCompImplantacaoSaldosImpl sCompImplantacaoSaldosImpl) {
        super(dao);
        this.serviceColaboradorImpl = serviceColaboradorImpl;
        this.serviceParametrizacaoEquipamentoSegurancaImpl = serviceParametrizacaoEquipamentoSegurancaImpl;
        this.serviceItemControleEquipamentoImpl = serviceItemControleEquipamentoImpl;
        this.serviceGradeCorImpl = serviceGradeCorImpl;
        this.serviceLoteFabricacaoImpl = serviceLoteFabricacaoImpl;
        this.serviceSaldoEstoqueImpl = serviceSaldoEstoqueImpl;
        this.serviceNaturezaRequisicaoImpl = serviceNaturezaRequisicaoImpl;
        this.helperRequisicao = helperRequisicao;
        this.sCompImplantacaoSaldosImpl = sCompImplantacaoSaldosImpl;
    }

    @Override
    public ControleEntregaEquipamento beforeSaveEntity(ControleEntregaEquipamento aux) {
        aux.getItemControleEquipamentos().forEach(i -> i.setControleEntregaEquipamento(aux));
        if (this.isNotNull(this.getSharedData().getEmpresaRh(aux.getEmpresa())).booleanValue() && this.isEquals(this.getSharedData().getEmpresaRh(aux.getEmpresa()).getGerarRequisicaoParaEPI(), EnumConstantsMentorSimNao.SIM.getValue()) && this.isEquals(aux.getTipoOperacao(), EnumConstControleEpiTipoOperacao.TIPO_OPERACAO_ENTREGA.getEnumId())) {
            Requisicao requisicao = this.helperRequisicao.gerarRequisicaoEntregaEquipamento(aux);
            aux.setRequisicao(requisicao);
        }
        if (this.isEquals(aux.getTipoOperacao(), EnumConstControleEpiTipoOperacao.TIPO_OPERACAO_DEVOLUCAO.getEnumId())) {
            boolean quantidadeMaior = aux.getItemControleEquipamentos().stream().filter(itemControle -> this.isNotNull(itemControle.getItemDevolvido())).anyMatch(i -> i.getQuantidade() > i.getItemDevolvido().getQuantidade());
            if (quantidadeMaior) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1231.004"));
            }
            this.sCompImplantacaoSaldosImpl.criarImplantacaoSaldo(aux);
        }
        return aux;
    }

    @Override
    public ControleEntregaEquipamento afterSaveEntity(ControleEntregaEquipamento vo) {
        if (this.isEquals(vo.getTipoOperacao(), EnumConstControleEpiTipoOperacao.TIPO_OPERACAO_DEVOLUCAO.getEnumId()) && this.isNotNull(vo.getImplantacaoSaldos()).booleanValue()) {
            vo.getImplantacaoSaldos().setObservacao(this.getMessage("M.ERP.1231.001", vo.getIdentificador()));
        }
        return vo;
    }

    public List<DTOItemControleEquipamento> procurarParametrizacaoEquipamento(Long idColaborador, Long dtEntrega) throws ExceptionObjNotFound {
        Colaborador colaborador = (Colaborador)this.serviceColaboradorImpl.getOrThrow(idColaborador);
        if (this.isNull(dtEntrega).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1231.001", new Object[]{dtEntrega}));
        }
        List<ItemEquipamento> equipamentoSemEntrega = this.serviceParametrizacaoEquipamentoSegurancaImpl.buscarEquipamentosSemEntrega(idColaborador, colaborador.getFuncao().getIdentificador(), colaborador.getEmpresa().getIdentificador(), new Date(dtEntrega));
        List<ItemControleEquipamento> equipamentoVencido = this.serviceItemControleEquipamentoImpl.buscarEquipamentosVencidos(idColaborador, colaborador.getEmpresa().getIdentificador(), new Date(dtEntrega));
        if (ServiceControleEntregaEquipamentoImpl.isWithData(equipamentoSemEntrega) || ServiceControleEntregaEquipamentoImpl.isWithData(equipamentoVencido)) {
            ArrayList<ItemControleEquipamento> itens = new ArrayList<ItemControleEquipamento>();
            this.setarControleEquipamento(equipamentoSemEntrega, itens, new Date(dtEntrega));
            this.setarControleEquipamentoVencido(equipamentoVencido, itens);
            return this.buildToDTOGeneric(itens, DTOItemControleEquipamento.class);
        }
        throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1231.002", new String[]{colaborador.getFuncao().toString()}));
    }

    private void setarControleEquipamento(List<ItemEquipamento> equipamentoSemEntrega, List<ItemControleEquipamento> itens, Date dataEntrega) {
        for (ItemEquipamento itemEquipamento : equipamentoSemEntrega) {
            ItemControleEquipamento itemControleEquipamento = new ItemControleEquipamento();
            itemControleEquipamento.setDataVencimento(ToolDate.nextDays((Date)dataEntrega, (int)(itemEquipamento.getVidaUtil().intValue() - 1)));
            itemControleEquipamento.setItemEquipamento(itemEquipamento);
            itemControleEquipamento.setGradeCor(itemEquipamento.getGradeCor());
            if (this.isNotNull(itemEquipamento).booleanValue() && this.isNotNull(itemEquipamento.getParametrizacaoEquipamentoSeguranca()).booleanValue()) {
                itemControleEquipamento.setCentroEstoque(itemEquipamento.getParametrizacaoEquipamentoSeguranca().getCentroEstoque());
            }
            itens.add(itemControleEquipamento);
        }
    }

    private void setarControleEquipamentoVencido(List<ItemControleEquipamento> equipamentoVencido, List<ItemControleEquipamento> itens) {
        for (ItemControleEquipamento itemAnterior : equipamentoVencido) {
            ItemControleEquipamento itemNovo = new ItemControleEquipamento();
            if (this.isNotNull(itemAnterior.getItemEquipamento()).booleanValue()) {
                itemNovo.setDataVencimento(ToolDate.nextDays((Date)itemAnterior.getDataVencimento(), (int)itemAnterior.getItemEquipamento().getVidaUtil().intValue()));
            }
            itemNovo.setItemEquipamento(itemAnterior.getItemEquipamento());
            itemNovo.setGradeCor(itemAnterior.getGradeCor());
            itemNovo.setItemAnterior(itemAnterior);
            if (this.isNotNull(itemAnterior.getItemEquipamento()).booleanValue() && this.isNotNull(itemAnterior.getItemEquipamento().getParametrizacaoEquipamentoSeguranca()).booleanValue()) {
                itemNovo.setCentroEstoque(itemAnterior.getItemEquipamento().getParametrizacaoEquipamentoSeguranca().getCentroEstoque());
            }
            itens.add(itemNovo);
        }
    }

    public List<DTOItemControleEquipamento> adicionarEquipamentos(Long[] ids, Long idColaborador) throws ExceptionObjNotFound {
        Colaborador colaborador = (Colaborador)this.serviceColaboradorImpl.getOrThrow(idColaborador);
        List listaGradeCor = this.serviceGradeCorImpl.gets(ids);
        List itemControleEquipamento = listaGradeCor.stream().map(i -> {
            ItemControleEquipamento itemNovo = new ItemControleEquipamento();
            itemNovo.setGradeCor(i);
            itemNovo.setItemEquipamento(this.serviceParametrizacaoEquipamentoSegurancaImpl.pesquisarItemEquipamentoFuncaoGradeCor(colaborador.getFuncao(), (GradeCor)i));
            return itemNovo;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(itemControleEquipamento, DTOItemControleEquipamento.class);
    }

    public List<DTOLoteFabricacaoRes> comboLoteFabricacao(Long idGradeCor, Empresa empresa) throws ExceptionObjNotFound {
        GradeCor gradeCor = (GradeCor)this.serviceGradeCorImpl.getOrThrow(idGradeCor);
        List<Object> listaLotes = new ArrayList();
        if (this.isNotNull(gradeCor).booleanValue() && this.isEquals(gradeCor.getProdutoGrade().getProduto().getLoteUnico(), EnumConstantsMentorSimNao.SIM.getValue())) {
            LoteFabricacao loteFabricacao = this.serviceLoteFabricacaoImpl.findLoteUnico(gradeCor.getProdutoGrade().getProduto());
            if (this.isNotNull(loteFabricacao).booleanValue()) {
                listaLotes.add(loteFabricacao);
            }
        } else {
            listaLotes = this.serviceSaldoEstoqueImpl.findLotesAbertos(null, gradeCor, empresa, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO);
        }
        return this.buildToDTOGeneric(listaLotes, DTOLoteFabricacaoRes.class);
    }

    public List<DTOEntidadeRes> comboNaturezaRequisicao(Long idGradeCor, Empresa empresa) throws ExceptionObjNotFound, ExceptionParamCtbRequisicao {
        GradeCor gradeCor = (GradeCor)this.serviceGradeCorImpl.getOrThrow(idGradeCor);
        List<NaturezaRequisicao> listaNaturezaRequisicao = this.serviceNaturezaRequisicaoImpl.getOrThrow(gradeCor.getProdutoGrade().getProduto(), empresa);
        return this.buildToDTOGeneric(listaNaturezaRequisicao, DTOEntidadeRes.class);
    }

    public List<DTOItemControleEquipamento> buscarItensControleEquipamentoColaborador(Long idColaborador) throws ExceptionObjNotFound {
        Colaborador colaborador = (Colaborador)this.serviceColaboradorImpl.getOrThrow(idColaborador);
        List<ItemControleEquipamento> listItemControleEquipamento = this.serviceItemControleEquipamentoImpl.buscarEquipamentosPorColaboradorTipoOperacao(colaborador.getIdentificador(), EnumConstControleEpiTipoOperacao.TIPO_OPERACAO_ENTREGA);
        if (!ServiceControleEntregaEquipamentoImpl.isWithData(listItemControleEquipamento)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1231.003", new String[]{colaborador.getPessoa().getNome(), EnumConstControleEpiTipoOperacao.TIPO_OPERACAO_ENTREGA.getEnumDesc()}));
        }
        return this.buildToDTOGeneric(listItemControleEquipamento, DTOItemControleEquipamento.class);
    }

    public List<DTOItemControleEquipamento> criarItensControleEquipamento(Long[] ids) {
        List listItemControleEquipamento = this.serviceItemControleEquipamentoImpl.gets(ids);
        List newListItemControleEquipamento = listItemControleEquipamento.stream().map(i -> {
            try {
                ItemControleEquipamento item = (ItemControleEquipamento)ToolClone.cloneEntity((Object)i);
                item.setItemDevolvido(i);
                return item;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(newListItemControleEquipamento, DTOItemControleEquipamento.class);
    }
}

