/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.controlesolicitacaoservico;

import com.touchcomp.basementor.constants.enums.ordemservico.EnumConstStatusOrdemServico;
import com.touchcomp.basementor.model.vo.ControleSolicitacaoServico;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemControleSolicitacaoServico;
import com.touchcomp.basementor.model.vo.SolicitacaoServico;
import com.touchcomp.basementorservice.dao.impl.DaoControleSolicitacaoServicoImpl;
import com.touchcomp.basementorservice.helpers.impl.solicitacaoservicos.HelperSolicitacaoServicos;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.itemcontrolesolicitacaoservico.ServiceItemControleSolicitacaoServicoImpl;
import com.touchcomp.basementorservice.service.impl.solicitacaoservico.ServiceSolicitacaoServicoImpl;
import com.touchcomp.touchvomodel.vo.controlesolicitacaoservico.web.DTOControleSolicitacaoServico;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceControleSolicitacaoServicoImpl
extends ServiceGenericEntityImpl<ControleSolicitacaoServico, Long, DaoControleSolicitacaoServicoImpl> {
    private ServiceSolicitacaoServicoImpl serviceSolicitacaoServico;
    private ServiceItemControleSolicitacaoServicoImpl serviceItemControleSolicitacaoServico;

    @Autowired
    public ServiceControleSolicitacaoServicoImpl(DaoControleSolicitacaoServicoImpl dao, ServiceSolicitacaoServicoImpl serviceSolicitacaoServico, ServiceItemControleSolicitacaoServicoImpl serviceItemControleSolicitacaoServico) {
        super(dao);
        this.serviceSolicitacaoServico = serviceSolicitacaoServico;
        this.serviceItemControleSolicitacaoServico = serviceItemControleSolicitacaoServico;
    }

    @Override
    public ControleSolicitacaoServico beforeSave(ControleSolicitacaoServico vo) {
        if (vo.getItemControleSolicitacaoService() != null) {
            vo.getItemControleSolicitacaoService().forEach(i -> i.setControleSolicitacaoServico(vo));
        }
        return vo;
    }

    public List<DTOControleSolicitacaoServico.DTOItemControleSolicitacaoServico> getItemControleSolicitacaoAbertas(Empresa empresa) {
        List<SolicitacaoServico> solicitacoes = this.serviceSolicitacaoServico.getSolicitacoesAbertas();
        if (solicitacoes == null || solicitacoes.isEmpty()) {
            return new ArrayList<DTOControleSolicitacaoServico.DTOItemControleSolicitacaoServico>();
        }
        ArrayList<ItemControleSolicitacaoServico> itens = new ArrayList<ItemControleSolicitacaoServico>();
        for (SolicitacaoServico s : solicitacoes) {
            HelperSolicitacaoServicos helper = new HelperSolicitacaoServicos().build(s);
            itens.add(helper.buildItemControleSolicitacaoServico(empresa));
        }
        return this.serviceItemControleSolicitacaoServico.buildToDTO(itens, DTOControleSolicitacaoServico.DTOItemControleSolicitacaoServico.class);
    }

    @Override
    public ControleSolicitacaoServico beforeDeleteEntity(ControleSolicitacaoServico entity) {
        if (entity != null) {
            for (ItemControleSolicitacaoServico itemControleSolicitacaoServico : entity.getItemControleSolicitacaoService()) {
                if (itemControleSolicitacaoServico.getSolicitacaoServico() == null) continue;
                itemControleSolicitacaoServico.getSolicitacaoServico().setStatus(Short.valueOf(EnumConstStatusOrdemServico.ABERTO.getValue()));
                this.serviceSolicitacaoServico.saveOrUpdate(itemControleSolicitacaoServico.getSolicitacaoServico());
            }
        }
        return entity;
    }

    @Override
    public ControleSolicitacaoServico beforeSaveEntity(ControleSolicitacaoServico entity) {
        if (entity != null) {
            for (ItemControleSolicitacaoServico itemControleSolicitacaoServico : entity.getItemControleSolicitacaoService()) {
                if (!this.isAffimative(itemControleSolicitacaoServico.getAprovado())) {
                    itemControleSolicitacaoServico.setOrdemServico(null);
                    if (itemControleSolicitacaoServico.getSolicitacaoServico() != null) {
                        itemControleSolicitacaoServico.getSolicitacaoServico().setStatus(Short.valueOf(EnumConstStatusOrdemServico.CANCELADO.getValue()));
                    }
                } else if (itemControleSolicitacaoServico.getSolicitacaoServico() != null) {
                    itemControleSolicitacaoServico.getSolicitacaoServico().setStatus(Short.valueOf(EnumConstStatusOrdemServico.FECHADA.getValue()));
                }
                if (itemControleSolicitacaoServico.getSolicitacaoServico() == null) continue;
                this.serviceSolicitacaoServico.saveOrUpdate(itemControleSolicitacaoServico.getSolicitacaoServico());
            }
        }
        return entity;
    }
}

